/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.analysis;

import java.util.ArrayList;
import java.util.List;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.core.router.MainModeIdentifier;

public final class TransportPlanningMainModeIdentifier
implements MainModeIdentifier {
    private final List<String> modeHierarchy = new ArrayList<String>();

    public TransportPlanningMainModeIdentifier() {
        this.modeHierarchy.add("non_network_walk");
        this.modeHierarchy.add("non_network_walk");
        this.modeHierarchy.add("undefined");
        this.modeHierarchy.add("other");
        this.modeHierarchy.add("transit_walk");
        this.modeHierarchy.add("walk");
        this.modeHierarchy.add("bike");
        this.modeHierarchy.add("drt");
        this.modeHierarchy.add("pt");
        this.modeHierarchy.add("ride");
        this.modeHierarchy.add("car");
    }

    @Override
    public String identifyMainMode(List<? extends PlanElement> planElements) {
        int mainModeIndex = -1;
        for (PlanElement planElement : planElements) {
            if (!(planElement instanceof Leg)) continue;
            Leg leg = (Leg)planElement;
            int index = this.modeHierarchy.indexOf(leg.getMode());
            if (index < 0) {
                throw new RuntimeException("unknown mode=" + leg.getMode());
            }
            if (index <= mainModeIndex) continue;
            mainModeIndex = index;
        }
        if (mainModeIndex <= this.modeHierarchy.indexOf("transit_walk")) {
            mainModeIndex = this.modeHierarchy.indexOf("walk");
        }
        return this.modeHierarchy.get(mainModeIndex);
    }
}

