/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.analysis;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.core.config.Config;
import org.matsim.core.config.groups.ControlerConfigGroup;
import org.matsim.core.config.groups.GlobalConfigGroup;
import org.matsim.core.controler.OutputDirectoryHierarchy;
import org.matsim.core.utils.charts.XYLineChart;
import org.matsim.core.utils.io.IOUtils;
import org.matsim.core.utils.io.UncheckedIOException;

public class TravelDistanceStats {
    private final ControlerConfigGroup controlerConfigGroup;
    private final GlobalConfigGroup globalConfigGroup;
    private final BufferedWriter out;
    private final String fileName;
    private double[] history = null;
    private Thread[] threads = null;
    private StatsCalculator[] statsCalculators = null;
    private final AtomicBoolean hadException = new AtomicBoolean(false);
    private final ExceptionHandler exceptionHandler = new ExceptionHandler(this.hadException);
    private static final Logger log = Logger.getLogger(TravelDistanceStats.class);

    @Inject
    TravelDistanceStats(ControlerConfigGroup controlerConfigGroup, GlobalConfigGroup globalConfigGroup, OutputDirectoryHierarchy controlerIO) {
        this(controlerConfigGroup, globalConfigGroup, controlerIO.getOutputFilename("traveldistancestats"), controlerConfigGroup.isCreateGraphs());
    }

    public TravelDistanceStats(Config config, String filename, boolean createPNG) throws UncheckedIOException {
        this(config.controler(), config.global(), filename, createPNG);
    }

    TravelDistanceStats(ControlerConfigGroup controlerConfigGroup, GlobalConfigGroup globalConfigGroup, String filename, boolean createPNG) {
        this.controlerConfigGroup = controlerConfigGroup;
        this.globalConfigGroup = globalConfigGroup;
        this.fileName = filename;
        if (createPNG) {
            int iterations = controlerConfigGroup.getLastIteration() - controlerConfigGroup.getFirstIteration();
            if (iterations > 5000) {
                iterations = 5000;
            }
            this.history = new double[iterations + 1];
        }
        this.out = filename.toLowerCase(Locale.ROOT).endsWith(".txt") ? IOUtils.getBufferedWriter(filename) : IOUtils.getBufferedWriter(filename + ".txt");
        try {
            this.out.write("ITERATION\tavg. EXECUTED\tavg. WORST\tavg. AVG\tavg. BEST\n");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void addIteration(int iteration, Map<Id<Person>, Plan> map) {
        int numOfThreads = this.globalConfigGroup.getNumberOfThreads();
        if (numOfThreads < 1) {
            numOfThreads = 1;
        }
        this.initThreads(numOfThreads);
        int roundRobin = 0;
        for (Plan plan : map.values()) {
            this.statsCalculators[roundRobin++ % numOfThreads].addPerson(plan);
        }
        log.info("[" + this.getClass().getSimpleName() + "] using " + numOfThreads + " thread(s).");
        for (Thread thread : this.threads) {
            thread.start();
        }
        try {
            for (Thread thread : this.threads) {
                thread.join();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        log.info("[" + this.getClass().getSimpleName() + "] all threads finished.");
        if (this.hadException.get()) {
            throw new RuntimeException("Some threads crashed, thus not all persons may have been handled.");
        }
        double sumAvgPlanLegTravelDistanceExecuted = 0.0;
        int nofLegTravelDistanceExecuted = 0;
        for (StatsCalculator statsCalculator : this.statsCalculators) {
            sumAvgPlanLegTravelDistanceExecuted += statsCalculator.sumAvgPlanLegTravelDistanceExecuted;
            nofLegTravelDistanceExecuted += statsCalculator.nofLegTravelDistanceExecuted;
        }
        this.statsCalculators = null;
        this.threads = null;
        log.info("-- average of the average leg distance per plan (executed plans only): " + sumAvgPlanLegTravelDistanceExecuted / (double)nofLegTravelDistanceExecuted);
        log.info("(TravelDistanceStats takes an average over all legs where the simulation reports travelled distances. These are car legs, pt legs,");
        log.info("(and teleported legs whose route contains a distance.)");
        try {
            this.out.write(iteration + "\t" + sumAvgPlanLegTravelDistanceExecuted / (double)nofLegTravelDistanceExecuted + "\t" + "\n");
            this.out.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (this.history != null) {
            int n = iteration - this.controlerConfigGroup.getFirstIteration();
            this.history[n] = sumAvgPlanLegTravelDistanceExecuted / (double)nofLegTravelDistanceExecuted;
            if (iteration != this.controlerConfigGroup.getFirstIteration()) {
                XYLineChart chart = new XYLineChart("Leg Travel Distance Statistics", "iteration", "average of the average leg distance per plan ");
                double[] iterations = new double[n + 1];
                for (int i = 0; i <= n; ++i) {
                    iterations[i] = i + this.controlerConfigGroup.getFirstIteration();
                }
                double[] values = new double[n + 1];
                System.arraycopy(this.history, 0, values, 0, n + 1);
                chart.addSeries("executed plan", iterations, values);
                chart.addMatsimLogo();
                chart.saveAsPng(this.fileName + ".png", 800, 600);
            }
            if (n == this.history.length - 1) {
                this.history = null;
            }
        }
    }

    public void close() {
        try {
            this.out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initThreads(int numOfThreads) {
        if (this.threads != null) {
            throw new RuntimeException("threads are already initialized");
        }
        this.hadException.set(false);
        this.threads = new Thread[numOfThreads];
        this.statsCalculators = new StatsCalculator[numOfThreads];
        for (int i = 0; i < numOfThreads; ++i) {
            StatsCalculator statsCalculatorThread = new StatsCalculator();
            Thread thread = new Thread((Runnable)statsCalculatorThread, this.getClass().getSimpleName() + "." + StatsCalculator.class.getSimpleName() + "." + i);
            thread.setUncaughtExceptionHandler(this.exceptionHandler);
            this.threads[i] = thread;
            this.statsCalculators[i] = statsCalculatorThread;
        }
    }

    private static class ExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private final AtomicBoolean hadException;

        public ExceptionHandler(AtomicBoolean hadException) {
            this.hadException = hadException;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            log.error("Thread " + t.getName() + " died with exception. Will stop after all threads finished.", e);
            this.hadException.set(true);
        }
    }

    private class StatsCalculator
    implements Runnable {
        double sumAvgPlanLegTravelDistanceExecuted = 0.0;
        int nofLegTravelDistanceExecuted = 0;
        private Collection<Plan> persons = new ArrayList<Plan>();

        private StatsCalculator() {
        }

        public void addPerson(Plan plan) {
            this.persons.add(plan);
        }

        @Override
        public void run() {
            for (Plan plan : this.persons) {
                this.sumAvgPlanLegTravelDistanceExecuted += this.getAvgLegTravelDistance(plan);
                ++this.nofLegTravelDistanceExecuted;
            }
        }

        private double getAvgLegTravelDistance(Plan plan) {
            double planTravelDistance = 0.0;
            int numberOfLegs = 0;
            for (PlanElement pe : plan.getPlanElements()) {
                Leg leg;
                double distance;
                if (!(pe instanceof Leg) || Double.isNaN(distance = (leg = (Leg)pe).getRoute().getDistance())) continue;
                planTravelDistance += distance;
                ++numberOfLegs;
            }
            if (numberOfLegs > 0) {
                return planTravelDistance / (double)numberOfLegs;
            }
            return 0.0;
        }
    }
}

