/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.analysis;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.LinkLeaveEvent;
import org.matsim.api.core.v01.events.VehicleEntersTrafficEvent;
import org.matsim.api.core.v01.events.handler.LinkLeaveEventHandler;
import org.matsim.api.core.v01.events.handler.VehicleEntersTrafficEventHandler;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.vehicles.Vehicle;

public class VolumesAnalyzer
implements LinkLeaveEventHandler,
VehicleEntersTrafficEventHandler {
    private static final Logger log = Logger.getLogger(VolumesAnalyzer.class);
    private final int timeBinSize;
    private final int maxTime;
    private final int maxSlotIndex;
    private final Map<Id<Link>, int[]> links;
    private final boolean observeModes;
    private final Map<Id<Vehicle>, String> enRouteModes;
    private final Map<Id<Link>, Map<String, int[]>> linksPerMode;

    @Inject
    VolumesAnalyzer(Network network, EventsManager eventsManager) {
        this(3600, 86399, network);
        eventsManager.addHandler(this);
    }

    public VolumesAnalyzer(int timeBinSize, int maxTime, Network network) {
        this(timeBinSize, maxTime, network, true);
    }

    public VolumesAnalyzer(int timeBinSize, int maxTime, Network network, boolean observeModes) {
        this.timeBinSize = timeBinSize;
        this.maxTime = maxTime;
        this.maxSlotIndex = this.maxTime / this.timeBinSize + 1;
        this.links = new HashMap<Id<Link>, int[]>((int)((double)network.getLinks().size() * 1.1), 0.95f);
        this.observeModes = observeModes;
        if (this.observeModes) {
            this.enRouteModes = new HashMap<Id<Vehicle>, String>();
            this.linksPerMode = new HashMap<Id<Link>, Map<String, int[]>>((int)((double)network.getLinks().size() * 1.1), 0.95f);
        } else {
            this.enRouteModes = null;
            this.linksPerMode = null;
        }
    }

    @Override
    public void handleEvent(VehicleEntersTrafficEvent event) {
        if (this.observeModes) {
            this.enRouteModes.put(event.getVehicleId(), event.getNetworkMode());
        }
    }

    @Override
    public void handleEvent(LinkLeaveEvent event) {
        int timeslot;
        int[] volumes = this.links.get(event.getLinkId());
        if (volumes == null) {
            volumes = new int[this.maxSlotIndex + 1];
            this.links.put(event.getLinkId(), volumes);
        }
        int n = timeslot = this.getTimeSlotIndex(event.getTime());
        volumes[n] = volumes[n] + 1;
        if (this.observeModes) {
            String mode;
            Map<String, int[]> modeVolumes = this.linksPerMode.get(event.getLinkId());
            if (modeVolumes == null) {
                modeVolumes = new HashMap<String, int[]>();
                this.linksPerMode.put(event.getLinkId(), modeVolumes);
            }
            if ((volumes = modeVolumes.get(mode = this.enRouteModes.get(event.getVehicleId()))) == null) {
                volumes = new int[this.maxSlotIndex + 1];
                modeVolumes.put(mode, volumes);
            }
            int n2 = timeslot;
            volumes[n2] = volumes[n2] + 1;
        }
    }

    private int getTimeSlotIndex(double time) {
        if (time > (double)this.maxTime) {
            return this.maxSlotIndex;
        }
        return (int)time / this.timeBinSize;
    }

    public int[] getVolumesForLink(Id<Link> linkId) {
        return this.links.get(linkId);
    }

    public int[] getVolumesForLink(Id<Link> linkId, String mode) {
        Map<String, int[]> modeVolumes;
        if (this.observeModes && (modeVolumes = this.linksPerMode.get(linkId)) != null) {
            return modeVolumes.get(mode);
        }
        return null;
    }

    public int getVolumesArraySize() {
        return this.maxSlotIndex + 1;
    }

    public double[] getVolumesPerHourForLink(Id<Link> linkId) {
        if (3600.0 % (double)this.timeBinSize != 0.0) {
            log.error("Volumes per hour and per link probably not correct!");
        }
        double[] volumes = new double[24];
        int[] volumesForLink = this.getVolumesForLink(linkId);
        if (volumesForLink == null) {
            return volumes;
        }
        int slotsPerHour = (int)(3600.0 / (double)this.timeBinSize);
        for (int hour = 0; hour < 24; ++hour) {
            double time = (double)hour * 3600.0;
            for (int i = 0; i < slotsPerHour; ++i) {
                int n = hour;
                volumes[n] = volumes[n] + (double)volumesForLink[this.getTimeSlotIndex(time)];
                time += (double)this.timeBinSize;
            }
        }
        return volumes;
    }

    public double[] getVolumesPerHourForLink(Id<Link> linkId, String mode) {
        if (this.observeModes) {
            if (3600.0 % (double)this.timeBinSize != 0.0) {
                log.error("Volumes per hour and per link probably not correct!");
            }
            double[] volumes = new double[24];
            for (int hour = 0; hour < 24; ++hour) {
                volumes[hour] = 0.0;
            }
            int[] volumesForLink = this.getVolumesForLink(linkId, mode);
            if (volumesForLink == null) {
                return volumes;
            }
            int slotsPerHour = (int)(3600.0 / (double)this.timeBinSize);
            for (int hour = 0; hour < 24; ++hour) {
                double time = (double)hour * 3600.0;
                for (int i = 0; i < slotsPerHour; ++i) {
                    int n = hour;
                    volumes[n] = volumes[n] + (double)volumesForLink[this.getTimeSlotIndex(time)];
                    time += (double)this.timeBinSize;
                }
            }
            return volumes;
        }
        return null;
    }

    public Set<String> getModes() {
        TreeSet<String> modes = new TreeSet<String>();
        for (Map<String, int[]> map : this.linksPerMode.values()) {
            modes.addAll(map.keySet());
        }
        return modes;
    }

    public Set<Id<Link>> getLinkIds() {
        return this.links.keySet();
    }

    @Override
    public void reset(int iteration) {
        this.links.clear();
        if (this.observeModes) {
            this.linksPerMode.clear();
            this.enRouteModes.clear();
        }
    }
}

