/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.api.core.v01;

import java.io.Serializable;

public final class Coord
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double x;
    private double y;
    private double z = Double.NEGATIVE_INFINITY;

    public Coord() {
    }

    public Coord(double x, double y) {
        this.x = x;
        this.y = y;
        this.z = Double.NEGATIVE_INFINITY;
    }

    public Coord(double[] coord) {
        this();
        switch (coord.length) {
            case 3: {
                this.z = coord[2];
            }
            case 2: {
                this.x = coord[0];
                this.y = coord[1];
                break;
            }
            default: {
                throw new RuntimeException("double[] of wrong length; cannot be interpreted as coordinate ");
            }
        }
    }

    public Coord(double x, double y, double z) {
        if (z == Double.NEGATIVE_INFINITY) {
            throw new IllegalArgumentException("Double.NEGATIVE_INFINITY is an invalid elevation. If you want to ignore elevation, use Coord(x, y) constructor instead.");
        }
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        if (!this.hasZ()) {
            throw new IllegalStateException("Requesting elevation (z) without having first set it.");
        }
        return this.z;
    }

    public boolean hasZ() {
        return this.z != Double.NEGATIVE_INFINITY;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Coord)) {
            return false;
        }
        Coord o = (Coord)other;
        if (!this.hasZ()) {
            if (o.hasZ()) {
                return false;
            }
            return this.x == o.getX() && this.y == o.getY();
        }
        if (!o.hasZ()) {
            return false;
        }
        return this.x == o.getX() && this.y == o.getY() && this.z == o.getZ();
    }

    public int hashCode() {
        long xbits = Double.doubleToLongBits(this.x);
        long ybits = Double.doubleToLongBits(this.y);
        long zbits = Double.doubleToLongBits(this.z);
        int result = (int)(xbits ^ xbits >>> 32);
        result = 31 * result + (int)(ybits ^ ybits >>> 32);
        result = 31 * result + (int)(zbits ^ zbits >>> 32);
        return result;
    }

    public final String toString() {
        if (!this.hasZ()) {
            return "[x=" + this.x + "][y=" + this.y + "]";
        }
        return "[x=" + this.x + "][y=" + this.y + "][z=" + this.z + "]";
    }
}

