/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.api.core.v01;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Node;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.gbl.Gbl;
import org.matsim.vehicles.Vehicle;

public abstract class Id<T>
implements Comparable<Id<T>> {
    private static final Map<Class<?>, Map<String, Id<?>>> cache = new ConcurrentHashMap();

    public static <T> Id<T> create(long key, Class<T> type) {
        return Id.create(Long.toString(key), type);
    }

    public static <T> Id<T> create(Id<?> id, Class<T> type) {
        if (id == null) {
            return null;
        }
        return Id.create(id.toString(), type);
    }

    public static <T> Id<T> create(String key, Class<T> type) {
        Map<String, Id<?>> map = cache.get(type);
        if (map == null) {
            map = new ConcurrentHashMap();
            cache.put(type, map);
        }
        Gbl.assertNotNull(key);
        Id<?> id = map.get(key);
        if (id == null) {
            id = new IdImpl(key);
            map.put(key, id);
        }
        return id;
    }

    @Override
    public int compareTo(Id<T> o) throws IllegalArgumentException {
        int res = this.toString().compareTo(o.toString());
        return res;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Id) {
            return this.compareTo((Id)obj) == 0;
        }
        return false;
    }

    public static <T> String writeId(Id<T> id) {
        if (id == null) {
            return "null";
        }
        return id.toString();
    }

    public static Id<Person> createPersonId(long key) {
        return Id.create(key, Person.class);
    }

    public static Id<Person> createPersonId(Id<?> id) {
        return Id.create(id, Person.class);
    }

    public static Id<Person> createPersonId(String str) {
        return Id.create(str, Person.class);
    }

    public static Id<Link> createLinkId(long key) {
        return Id.create(key, Link.class);
    }

    public static Id<Link> createLinkId(Id<?> id) {
        return Id.create(id, Link.class);
    }

    public static Id<Link> createLinkId(String str) {
        return Id.create(str, Link.class);
    }

    public static Id<Node> createNodeId(long key) {
        return Id.create(key, Node.class);
    }

    public static Id<Node> createNodeId(Id<?> id) {
        return Id.create(id, Node.class);
    }

    public static Id<Node> createNodeId(String str) {
        return Id.create(str, Node.class);
    }

    public static Id<Vehicle> createVehicleId(long key) {
        return Id.create(key, Vehicle.class);
    }

    public static Id<Vehicle> createVehicleId(Id<?> id) {
        return Id.create(id, Vehicle.class);
    }

    public static Id<Vehicle> createVehicleId(String str) {
        return Id.create(str, Vehicle.class);
    }

    private static class IdImpl<T>
    extends Id<T> {
        private final String id;

        IdImpl(String id) {
            this.id = id;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public String toString() {
            return this.id;
        }
    }
}

