/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.api.core.v01.events;

import java.util.LinkedHashMap;
import java.util.Map;
import org.matsim.core.api.internal.HasPersonId;

public abstract class Event {
    public static final String ATTRIBUTE_TIME = "time";
    public static final String ATTRIBUTE_TYPE = "type";
    private final double time;

    public Event(double time) {
        this.time = time;
    }

    public Map<String, String> getAttributes() {
        LinkedHashMap<String, String> attr = new LinkedHashMap<String, String>();
        attr.put(ATTRIBUTE_TIME, Double.toString(this.time));
        attr.put(ATTRIBUTE_TYPE, this.getEventType());
        if (this instanceof HasPersonId) {
            attr.put("person", ((HasPersonId)((Object)this)).getPersonId().toString());
        }
        return attr;
    }

    public abstract String getEventType();

    public final double getTime() {
        return this.time;
    }

    public String toString() {
        Map<String, String> attr = this.getAttributes();
        StringBuilder eventXML = new StringBuilder("\t<event ");
        for (Map.Entry<String, String> entry : attr.entrySet()) {
            eventXML.append(entry.getKey());
            eventXML.append("=\"");
            eventXML.append(entry.getValue());
            eventXML.append("\" ");
        }
        eventXML.append(" />");
        return eventXML.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event)obj;
        return this.time == other.time && this.getEventType().equals(other.getEventType()) && this.getAttributes().equals(other.getAttributes());
    }

    public int hashCode() {
        return this.getAttributes().hashCode();
    }
}

