/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.api.core.v01.events;

import java.util.Map;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.Event;
import org.matsim.api.core.v01.events.HasLinkId;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.population.Person;
import org.matsim.vehicles.Vehicle;

public class LinkEnterEvent
extends Event
implements HasLinkId {
    public static final String EVENT_TYPE = "entered link";
    public static final String ATTRIBUTE_VEHICLE = "vehicle";
    public static final String ATTRIBUTE_LINK = "link";
    private final Id<Link> linkId;
    private final Id<Vehicle> vehicleId;
    static final String missingVehicleIdMessage = "vehicleId=null in LinkEnter/LeaveEvent; this would cause problems downstream thus we are not accepting it";

    public LinkEnterEvent(double time, Id<Vehicle> vehicleId, Id<Link> linkId) {
        super(time);
        this.linkId = linkId;
        if (vehicleId == null) {
            throw new RuntimeException(missingVehicleIdMessage);
        }
        this.vehicleId = vehicleId;
    }

    @Override
    public String getEventType() {
        return EVENT_TYPE;
    }

    @Deprecated
    public Id<Person> getDriverId() {
        throw new RuntimeException("driver (or person) ID does no longer exist in LinkEnter/LeaveEvent; use vehicle ID instead. See Vehicle2DriverEventHandler for an approach to reconstruct the driver ID and/or EventsConverterXML to convert your old event file.");
    }

    @Override
    public Id<Link> getLinkId() {
        return this.linkId;
    }

    public Id<Vehicle> getVehicleId() {
        return this.vehicleId;
    }

    @Override
    public Map<String, String> getAttributes() {
        Map<String, String> attr = super.getAttributes();
        attr.put(ATTRIBUTE_VEHICLE, this.vehicleId.toString());
        attr.put(ATTRIBUTE_LINK, this.linkId.toString());
        return attr;
    }
}

