/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.api.core.v01.events;

import java.util.Map;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.Event;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.api.internal.HasPersonId;

public class PersonArrivalEvent
extends Event
implements HasPersonId {
    public static final String EVENT_TYPE = "arrival";
    public static final String ATTRIBUTE_PERSON = "person";
    public static final String ATTRIBUTE_LINK = "link";
    public static final String ATTRIBUTE_LEGMODE = "legMode";
    private final Id<Person> personId;
    private final Id<Link> linkId;
    private final String legMode;

    public PersonArrivalEvent(double time, Id<Person> agentId, Id<Link> linkId, String legMode) {
        super(time);
        this.linkId = linkId;
        this.legMode = legMode;
        this.personId = agentId;
    }

    @Override
    public Id<Person> getPersonId() {
        return this.personId;
    }

    public Id<Link> getLinkId() {
        return this.linkId;
    }

    public String getLegMode() {
        return this.legMode;
    }

    @Override
    public String getEventType() {
        return EVENT_TYPE;
    }

    @Override
    public Map<String, String> getAttributes() {
        Map<String, String> attr = super.getAttributes();
        attr.put(ATTRIBUTE_PERSON, this.personId.toString());
        attr.put(ATTRIBUTE_LINK, this.linkId == null ? null : this.linkId.toString());
        if (this.legMode != null) {
            attr.put(ATTRIBUTE_LEGMODE, this.legMode);
        }
        return attr;
    }
}

