/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.api.core.v01.events;

import java.util.Map;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.Event;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.api.internal.HasPersonId;
import org.matsim.vehicles.Vehicle;

public class PersonEntersVehicleEvent
extends Event
implements HasPersonId {
    public static final String EVENT_TYPE = "PersonEntersVehicle";
    public static final String ATTRIBUTE_PERSON = "person";
    public static final String ATTRIBUTE_VEHICLE = "vehicle";
    private final Id<Person> personId;
    private final Id<Vehicle> vehicleId;

    public PersonEntersVehicleEvent(double time, Id<Person> personId, Id<Vehicle> vehicleId) {
        super(time);
        this.personId = personId;
        this.vehicleId = vehicleId;
    }

    public Id<Vehicle> getVehicleId() {
        return this.vehicleId;
    }

    @Override
    public Id<Person> getPersonId() {
        return this.personId;
    }

    @Override
    public String getEventType() {
        return EVENT_TYPE;
    }

    @Override
    public Map<String, String> getAttributes() {
        Map<String, String> attrs = super.getAttributes();
        attrs.put(ATTRIBUTE_PERSON, this.personId.toString());
        attrs.put(ATTRIBUTE_VEHICLE, this.vehicleId.toString());
        return attrs;
    }
}

