/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.api.core.v01.events;

import java.util.Map;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.Event;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.api.internal.HasPersonId;

public final class PersonMoneyEvent
extends Event
implements HasPersonId {
    public static final String ATTRIBUTE_AMOUNT = "amount";
    public static final String EVENT_TYPE = "personMoney";
    public static final String ATTRIBUTE_PERSON = "person";
    private final Id<Person> personId;
    private final double amount;

    public PersonMoneyEvent(double time, Id<Person> agentId, double amount) {
        super(time);
        this.personId = agentId;
        this.amount = amount;
    }

    @Override
    public Id<Person> getPersonId() {
        return this.personId;
    }

    public double getAmount() {
        return this.amount;
    }

    @Override
    public String getEventType() {
        return EVENT_TYPE;
    }

    @Override
    public Map<String, String> getAttributes() {
        Map<String, String> attr = super.getAttributes();
        attr.put(ATTRIBUTE_AMOUNT, Double.toString(this.amount));
        attr.put(ATTRIBUTE_PERSON, this.personId.toString());
        return attr;
    }
}

