/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.api.core.v01.events;

import java.util.Map;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.Event;
import org.matsim.api.core.v01.population.Person;
import org.matsim.pt.transitSchedule.api.Departure;
import org.matsim.pt.transitSchedule.api.TransitLine;
import org.matsim.pt.transitSchedule.api.TransitRoute;
import org.matsim.vehicles.Vehicle;

public class TransitDriverStartsEvent
extends Event {
    public static final String EVENT_TYPE = "TransitDriverStarts";
    public static final String ATTRIBUTE_DRIVER_ID = "driverId";
    public static final String ATTRIBUTE_VEHICLE_ID = "vehicleId";
    public static final String ATTRIBUTE_TRANSIT_LINE_ID = "transitLineId";
    public static final String ATTRIBUTE_TRANSIT_ROUTE_ID = "transitRouteId";
    public static final String ATTRIBUTE_DEPARTURE_ID = "departureId";
    private final Id<Person> driverId;
    private final Id<Vehicle> vehicleId;
    private final Id<TransitRoute> transitRouteId;
    private final Id<TransitLine> transitLineId;
    private final Id<Departure> departureId;

    public TransitDriverStartsEvent(double time, Id<Person> driverId, Id<Vehicle> vehicleId, Id<TransitLine> transitLineId, Id<TransitRoute> transitRouteId, Id<Departure> departureId) {
        super(time);
        this.driverId = driverId;
        this.vehicleId = vehicleId;
        this.transitRouteId = transitRouteId;
        this.transitLineId = transitLineId;
        this.departureId = departureId;
    }

    public Id<Person> getDriverId() {
        return this.driverId;
    }

    public Id<Vehicle> getVehicleId() {
        return this.vehicleId;
    }

    public Id<TransitRoute> getTransitRouteId() {
        return this.transitRouteId;
    }

    public Id<TransitLine> getTransitLineId() {
        return this.transitLineId;
    }

    public Id<Departure> getDepartureId() {
        return this.departureId;
    }

    @Override
    public String getEventType() {
        return EVENT_TYPE;
    }

    @Override
    public Map<String, String> getAttributes() {
        Map<String, String> atts = super.getAttributes();
        atts.put(ATTRIBUTE_DRIVER_ID, this.getDriverId().toString());
        atts.put(ATTRIBUTE_VEHICLE_ID, this.getVehicleId().toString());
        atts.put(ATTRIBUTE_TRANSIT_LINE_ID, this.getTransitLineId().toString());
        atts.put(ATTRIBUTE_TRANSIT_ROUTE_ID, this.getTransitRouteId().toString());
        atts.put(ATTRIBUTE_DEPARTURE_ID, this.getDepartureId().toString());
        return atts;
    }
}

