/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.api.core.v01.network;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.matsim.api.core.v01.network.Network;
import org.matsim.core.api.internal.MatsimWriter;
import org.matsim.utils.objectattributes.AttributeConverter;

public class NetworkWriter
implements MatsimWriter {
    private final Network network;
    private final Map<Class<?>, AttributeConverter<?>> converters = new HashMap();

    public NetworkWriter(Network network) {
        this.network = network;
    }

    public void putAttributeConverters(Map<Class<?>, AttributeConverter<?>> converters) {
        this.converters.putAll(converters);
    }

    public void putAttributeConverter(Class<?> clazz, AttributeConverter<?> converter) {
        this.converters.put(clazz, converter);
    }

    @Override
    public void write(String filename) {
        this.writeV2(filename);
    }

    public void write(OutputStream stream) {
        this.writeV2(stream);
    }

    public void writeV1(String filename) {
        new org.matsim.core.network.io.NetworkWriter(this.network).writeFileV1(filename);
    }

    public void writeV2(String filename) {
        org.matsim.core.network.io.NetworkWriter writer = new org.matsim.core.network.io.NetworkWriter(this.network);
        writer.putAttributeConverters(this.converters);
        writer.writeFileV2(filename);
    }

    public void writeV2(OutputStream stream) {
        org.matsim.core.network.io.NetworkWriter writer = new org.matsim.core.network.io.NetworkWriter(this.network);
        writer.putAttributeConverters(this.converters);
        writer.writeStreamV2(stream);
    }
}

