/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.api.core.v01.population;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.population.Population;
import org.matsim.core.api.internal.MatsimWriter;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.core.utils.geometry.transformations.IdentityTransformation;
import org.matsim.utils.objectattributes.AttributeConverter;

public final class PopulationWriter
implements MatsimWriter {
    private final CoordinateTransformation transformation;
    private final Population population;
    private final Network network;
    private final Map<Class<?>, AttributeConverter<?>> attributeConverters = new HashMap();

    public PopulationWriter(CoordinateTransformation transformation, Population population, Network network) {
        this.transformation = transformation;
        this.population = population;
        this.network = network;
    }

    public PopulationWriter(CoordinateTransformation transformation, Population population) {
        this(transformation, population, null);
    }

    public PopulationWriter(Population population, Network network) {
        this(new IdentityTransformation(), population, network);
    }

    public PopulationWriter(Population population) {
        this(new IdentityTransformation(), population, null);
    }

    public <T> void putAttributeConverter(Class<T> clazz, AttributeConverter<T> converter) {
        this.attributeConverters.put(clazz, converter);
    }

    public void putAttributeConverters(Map<Class<?>, AttributeConverter<?>> converters) {
        this.attributeConverters.putAll(converters);
    }

    @Override
    public void write(String filename) {
        this.writeV6(filename);
    }

    public void write(OutputStream stream) {
        this.writeV6(stream);
    }

    public void writeV4(String filename) {
        new org.matsim.core.population.io.PopulationWriter(this.transformation, this.population, this.network).writeV4(filename);
    }

    public void writeV5(String filename) {
        new org.matsim.core.population.io.PopulationWriter(this.transformation, this.population, this.network).writeV5(filename);
    }

    public void writeV6(String filename) {
        org.matsim.core.population.io.PopulationWriter writer = new org.matsim.core.population.io.PopulationWriter(this.transformation, this.population, this.network);
        writer.putAttributeConverters(this.attributeConverters);
        writer.writeV6(filename);
    }

    public void writeV6(OutputStream stream) {
        org.matsim.core.population.io.PopulationWriter writer = new org.matsim.core.population.io.PopulationWriter(this.transformation, this.population, this.network);
        writer.putAttributeConverters(this.attributeConverters);
        writer.writeV6(stream);
    }
}

