/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.contrib.pythonmatsim.events;

import org.matsim.api.core.v01.events.Event;
import org.matsim.contrib.pythonmatsim.protobuf.Event2ProtoEvent;
import org.matsim.contrib.pythonmatsim.protobuf.EventBufferOuterClass;
import org.matsim.contrib.pythonmatsim.protobuf.ProtobufEvents;
import org.matsim.core.controler.events.AfterMobsimEvent;
import org.matsim.core.controler.listener.AfterMobsimListener;
import org.matsim.core.events.handler.BasicEventHandler;

public class BufferedProtocolBufferSender
implements BasicEventHandler,
AfterMobsimListener {
    private final int bufferSize;
    private final Listener[] listeners;
    private final EventBufferOuterClass.EventBuffer.Builder bufferBuilder = EventBufferOuterClass.EventBuffer.newBuilder();

    public BufferedProtocolBufferSender(int bufferSize, Listener ... listener) {
        this.bufferSize = bufferSize;
        this.listeners = listener;
    }

    @Override
    public void reset(int iteration) {
        if (this.bufferBuilder.getEventCount() > 0) {
            throw new IllegalStateException("buffer was not emptied at end of simulation: " + this.bufferBuilder.getEventList());
        }
        for (Listener listener : this.listeners) {
            listener.reset(iteration);
        }
    }

    @Override
    public void handleEvent(Event event) {
        ProtobufEvents.Event protoEvent = Event2ProtoEvent.getProtoEvent(event);
        this.bufferBuilder.addEvent(protoEvent);
        if (this.bufferBuilder.getEventCount() >= this.bufferSize) {
            this.flush();
        }
    }

    public void flush() {
        byte[] message = this.bufferBuilder.build().toByteArray();
        for (Listener listener : this.listeners) {
            listener.handleEventBuffer(message);
        }
        this.bufferBuilder.clear();
    }

    @Override
    public void notifyAfterMobsim(AfterMobsimEvent event) {
        this.flush();
    }

    public static interface Listener {
        public void handleEventBuffer(byte[] var1);

        public void reset(int var1);
    }
}

