/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.contrib.pythonmatsim.typehints;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.matsim.contrib.pythonmatsim.typehints.TypeHintsUtils;

class Packages {
    private static final Logger log = Logger.getLogger(Packages.class);
    private final Map<String, PackageInfo> packages = new HashMap<String, PackageInfo>();

    Packages() {
    }

    public void addClass(Class<?> classe) {
        if (TypeHintsUtils.PRIMITIVE_TYPES.contains(classe)) {
            return;
        }
        log.debug(classe);
        if (classe.isArray()) {
            Class<?> component = classe.getComponentType();
            this.createPackage(component).addClass(classe);
        } else {
            this.createPackage(classe).addClass(classe);
        }
    }

    private PackageInfo createPackage(Class<?> classe) {
        if (classe == null) {
            throw new IllegalArgumentException();
        }
        return this.packages.computeIfAbsent(classe.getPackage().getName(), x$0 -> new PackageInfo((String)x$0));
    }

    public Iterable<PackageInfo> getPackages() {
        return this.packages.values();
    }

    public static class ClassInfo {
        private final Class<?> classe;
        private final Map<Class<?>, ClassInfo> innerClasses = new LinkedHashMap();

        public ClassInfo(Class<?> classe) {
            this.classe = classe;
            for (Class<?> inner : classe.getDeclaredClasses()) {
                this.innerClasses.put(inner, new ClassInfo(inner));
            }
        }

        public Class<?> getRootClass() {
            return this.classe;
        }

        public Collection<ClassInfo> getInnerClasses() {
            return this.innerClasses.values();
        }

        public String toString() {
            return "ClassInfo{classe=" + this.classe + ", innerClasses=" + this.innerClasses + '}';
        }
    }

    public class PackageInfo {
        private final String packageName;
        private final Map<Class<?>, ClassInfo> rootClasses = new LinkedHashMap();

        public PackageInfo(String packageName) {
            this.packageName = packageName;
        }

        private void addClass(Class<?> classe) {
            try {
                if (classe.isMemberClass() || classe.isLocalClass() || classe.isAnonymousClass() || !Modifier.isPublic(classe.getModifiers())) {
                    return;
                }
                this.rootClasses.put(classe, new ClassInfo(classe));
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }

        public String getPackageName() {
            return this.packageName;
        }

        public Iterable<ClassInfo> getClasses() {
            return this.rootClasses.values();
        }

        public Iterable<String> getImportedPackages() {
            return this.rootClasses.values().stream().flatMap(c -> TypeHintsUtils.getMethods(c).values().stream()).flatMap(Collection::stream).flatMap(this::getTypes).flatMap(t -> TypeHintsUtils.getImportedTypes(t).stream()).filter(t -> !TypeHintsUtils.PRIMITIVE_TYPES.contains(t)).map(Class::getPackage).map(Package::getName).collect(Collectors.toSet());
        }

        private Stream<Class<?>> getTypes(Method method) {
            ArrayList list = new ArrayList();
            list.add(method.getReturnType());
            list.addAll(Arrays.asList(method.getParameterTypes()));
            return list.stream();
        }
    }
}

