/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.contrib.pythonmatsim.typehints;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;
import org.matsim.contrib.pythonmatsim.typehints.Packages;
import org.matsim.contrib.pythonmatsim.typehints.TypeHintsUtils;
import org.matsim.core.utils.io.IOUtils;

public class PyiUtils {
    private static final Logger log = Logger.getLogger(PyiUtils.class);

    public static Iterable<Packages.PackageInfo> scan() {
        HashSet classes = new HashSet();
        try {
            for (ClassLoader loader = Thread.currentThread().getContextClassLoader(); loader != null; loader = loader.getParent()) {
                PyiUtils.addClasses(loader, classes);
            }
            PyiUtils.addBootstrapClasses(classes);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        Packages packages = new Packages();
        classes.forEach(packages::addClass);
        return packages.getPackages();
    }

    private static void addClasses(ClassLoader loader, Collection<Class<?>> classes) throws IOException {
        ImmutableSet<ClassPath.ClassInfo> loadableClasses = ClassPath.from(loader).getAllClasses();
        log.info("adding " + loadableClasses.size() + " classes from class loader " + loader);
        for (ClassPath.ClassInfo c : loadableClasses) {
            try {
                Class<?> loaded = c.load();
                classes.add(loaded);
            }
            catch (LinkageError e) {
                log.warn("could not load class " + c.getName());
            }
        }
    }

    private static void addBootstrapClasses(final Collection<Class<?>> classes) throws IOException, ClassNotFoundException {
        try {
            URL fileURL = ((JarURLConnection)ClassLoader.getSystemResource("java/lang/Class.class").openConnection()).getJarFileURL();
            JarFile file = ((JarURLConnection)ClassLoader.getSystemResource("java/lang/Class.class").openConnection()).getJarFile();
            URLClassLoader cl = URLClassLoader.newInstance(new URL[]{new URL("jar:" + fileURL.toString() + "!/")});
            ArrayList<JarEntry> entries = Collections.list(file.entries());
            log.info("loading " + entries.size() + " bootstrap classes from JAR " + fileURL);
            for (JarEntry entry : entries) {
                if (!entry.getName().endsWith(".class")) continue;
                String className = entry.getName().substring(0, entry.getName().length() - 6).replace("/", ".");
                Class<?> classe = cl.loadClass(className);
                classes.add(classe);
            }
        }
        catch (ClassCastException e) {
            log.info("loading bootstrap classes from JRT");
            FileSystem fs = FileSystems.getFileSystem(URI.create("jrt:/"));
            String basePath = "/modules/java.base/";
            final int prefixLength = "jrt:/modules/java.base/".length();
            final ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Files.walkFileTree(fs.getPath("/modules/java.base/", new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String fileName = file.toUri().toString();
                    if (fileName.endsWith(".class") && !fileName.contains("$")) {
                        log.debug("found class " + fileName);
                        String className = fileName.substring(prefixLength, fileName.length() - 6).replace("/", ".");
                        log.debug("try to load class " + className);
                        try {
                            classes.add(cl.loadClass(className));
                        }
                        catch (ClassNotFoundException | LinkageError ex) {
                            log.warn("could not load class " + className);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public static void generatePythonWrappers(String rootPath, String rootPackage) {
        try {
            PyiUtils.generatePyiFiles(rootPath, rootPackage);
            PyiUtils.generatePythonFiles(rootPath, rootPackage);
            PyiUtils.generateInitFiles(new File(rootPath));
            new File(rootPath + "/" + rootPackage + "/py.typed").createNewFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void generatePyiFiles(String rootPath, String rootPackage) throws IOException {
        String packagePath = rootPath + "/" + rootPackage;
        log.debug("generating python .pyi files in " + packagePath);
        File rootDir = new File(packagePath);
        for (Packages.PackageInfo info : PyiUtils.scan()) {
            File file = PyiUtils.getPackageFile(rootDir, info, ".pyi");
            log.debug("generate " + file.getCanonicalPath());
            BufferedWriter writer = IOUtils.getBufferedWriter(file.getCanonicalPath());
            try {
                PyiUtils.writeHeader(writer);
                PyiUtils.writeImports(writer, rootPackage, info.getImportedPackages());
                writer.write("from typing import overload");
                writer.newLine();
                writer.newLine();
                for (Packages.ClassInfo classTypeInfo : info.getClasses()) {
                    log.debug("generate class " + classTypeInfo);
                    PyiUtils.writeClassHints("", writer, rootPackage, classTypeInfo);
                }
            }
            finally {
                if (writer == null) continue;
                writer.close();
            }
        }
    }

    private static void generatePythonFiles(String rootPath, String rootPackage) throws IOException {
        String packagePath = rootPath + "/" + rootPackage;
        log.debug("generating python .py files in " + packagePath);
        File rootDir = new File(packagePath);
        for (Packages.PackageInfo info : PyiUtils.scan()) {
            File file = PyiUtils.getPackageFile(rootDir, info, ".py");
            log.debug("generate " + file.getCanonicalPath());
            BufferedWriter writer = IOUtils.getBufferedWriter(file.getCanonicalPath());
            try {
                PyiUtils.writeHeader(writer);
                writer.write("import jpype");
                writer.newLine();
                writer.newLine();
                for (Packages.ClassInfo classTypeInfo : info.getClasses()) {
                    log.debug("generate class " + classTypeInfo);
                    PyiUtils.writePythonJpypeClass(writer, classTypeInfo);
                }
            }
            finally {
                if (writer == null) continue;
                writer.close();
            }
        }
    }

    private static void generateInitFiles(File rootDir) throws IOException {
        log.debug("generating python __init__.py files in " + rootDir.getPath());
        PyiUtils.writeInitFile(rootDir);
        for (File directory : rootDir.listFiles(File::isDirectory)) {
            PyiUtils.generateInitFiles(directory);
        }
    }

    private static void writeInitFile(File directory) throws IOException {
        try (BufferedWriter writer = IOUtils.getBufferedWriter(directory.getCanonicalPath() + "/__init__.py");){
            PyiUtils.writeHeader(writer);
            for (File pythonFile : directory.listFiles(f -> f.getName().matches("_.*\\.py") && !f.getName().equals("__init__.py"))) {
                String pack = pythonFile.getName().substring(0, pythonFile.getName().length() - 3);
                writer.newLine();
                writer.write("from ." + pack + " import *");
            }
        }
    }

    private static void writePythonJpypeClass(BufferedWriter writer, Packages.ClassInfo classTypeInfo) throws IOException {
        String pythonClassName = TypeHintsUtils.pythonClassName(classTypeInfo.getRootClass());
        if (pythonClassName.equals("Any")) {
            log.debug("ABORT class " + classTypeInfo);
            return;
        }
        String canonicalName = classTypeInfo.getRootClass().getCanonicalName();
        if (canonicalName == null) {
            log.debug("ABORT class " + classTypeInfo);
            return;
        }
        writer.newLine();
        writer.newLine();
        writer.write(pythonClassName);
        writer.write(" = jpype.JClass('");
        writer.write(classTypeInfo.getRootClass().getName());
        writer.write("')");
    }

    private static void writeClassHints(String prefix, BufferedWriter writer, String rootPackage, Packages.ClassInfo classTypeInfo) throws IOException {
        Class<?> rootClass = classTypeInfo.getRootClass();
        String pythonName = TypeHintsUtils.pythonClassName(rootClass);
        if (pythonName.equals("Any")) {
            return;
        }
        if (rootClass.isMemberClass()) {
            String parentName = TypeHintsUtils.pythonClassName(rootClass.getDeclaringClass());
            pythonName = pythonName.substring(parentName.length() + 1);
        }
        writer.write(prefix + "class " + pythonName + ":");
        writer.newLine();
        PyiUtils.writeConstructorsHints(prefix + '\t', writer, rootPackage, rootClass);
        if (classTypeInfo.getRootClass().isEnum()) {
            PyiUtils.writeEnumHints(prefix + '\t', writer, rootPackage, classTypeInfo);
        }
        for (Packages.ClassInfo classInfo : classTypeInfo.getInnerClasses()) {
            PyiUtils.writeClassHints(prefix + '\t', writer, rootPackage, classInfo);
        }
        for (Map.Entry entry : TypeHintsUtils.getMethods(classTypeInfo).entrySet()) {
            PyiUtils.writeMethodHints(prefix + '\t', writer, rootPackage, (String)entry.getKey(), (Collection)entry.getValue());
        }
        writer.newLine();
        writer.newLine();
    }

    private static void writeEnumHints(String prefix, BufferedWriter writer, String rootPackage, Packages.ClassInfo classTypeInfo) throws IOException {
        for (Object constant : classTypeInfo.getRootClass().getEnumConstants()) {
            writer.write(prefix);
            writer.write(((Enum)constant).name() + ": ");
            writer.write(TypeHintsUtils.pythonClassName(classTypeInfo.getRootClass()));
            writer.write(" = ...");
            writer.newLine();
        }
    }

    private static void writeConstructorsHints(String prefix, BufferedWriter writer, String rootPackage, Class<?> classe) throws IOException {
        Constructor<?>[] constructors = null;
        try {
            constructors = classe.getConstructors();
        }
        catch (NoClassDefFoundError e) {
            return;
        }
        boolean overload = constructors.length > 1;
        for (Constructor<?> constructor : constructors) {
            if (overload) {
                writer.write(prefix);
                writer.write("@overload");
                writer.newLine();
            }
            writer.write(prefix + "def __init__(self, ");
            for (Parameter parameter : constructor.getParameters()) {
                String parameterName = parameter.isVarArgs() ? "*" + parameter.getName() : parameter.getName();
                Class<?> parameterType = parameter.isVarArgs() ? parameter.getType().getComponentType() : parameter.getType();
                String pythonQualifiedClassName = TypeHintsUtils.pythonQualifiedClassName(rootPackage, parameterType);
                writer.write(parameterName + ": " + pythonQualifiedClassName + ", ");
            }
            writer.write("): ...");
            writer.newLine();
        }
    }

    private static void writeMethodHints(String prefix, BufferedWriter writer, String rootPackage, String name, Collection<Method> methods) throws IOException {
        String methodName = TypeHintsUtils.getJPypeName(name);
        boolean overload = methods.size() > 1;
        for (Method method : methods) {
            if (overload) {
                writer.write(prefix);
                writer.write("@overload");
                writer.newLine();
            }
            PyiUtils.writeMethodHints(prefix, writer, rootPackage, methodName, method);
        }
    }

    private static void writeMethodHints(String prefix, BufferedWriter writer, String rootPackage, String name, Method method) throws IOException {
        boolean isStatic = Modifier.isStatic(method.getModifiers());
        if (isStatic) {
            writer.write(prefix + "@staticmethod");
            writer.newLine();
        }
        writer.write(prefix + "def " + name + "(");
        if (!isStatic) {
            writer.write("self, ");
        }
        for (Parameter parameter : method.getParameters()) {
            String parameterName = parameter.isVarArgs() ? "*" + parameter.getName() : parameter.getName();
            Class<?> parameterType = parameter.isVarArgs() ? parameter.getType().getComponentType() : parameter.getType();
            String pythonQualifiedClassName = TypeHintsUtils.pythonQualifiedClassName(rootPackage, parameterType);
            writer.write(parameterName + ": " + pythonQualifiedClassName + ", ");
        }
        writer.write(")");
        if (method.getReturnType() != null) {
            writer.write(" -> " + TypeHintsUtils.pythonQualifiedClassName(rootPackage, method.getReturnType()));
        }
        writer.write(": ...");
        writer.newLine();
    }

    private static void writeImports(BufferedWriter writer, String rootPackage, Iterable<String> importedPackages) throws IOException {
        for (String packageName : importedPackages) {
            writer.write("import " + rootPackage + "." + packageName);
            writer.newLine();
        }
        writer.newLine();
        writer.write("from jpype.types import *");
        writer.newLine();
        writer.write("from typing import Union");
        writer.newLine();
        writer.newLine();
    }

    private static File getPackageFile(File rootDir, Packages.PackageInfo packageInfo, String extension) {
        try {
            String rootPath = rootDir.getCanonicalPath();
            String moduleName = packageInfo.getPackageName();
            int lastPoint = moduleName.lastIndexOf(46);
            String packageDir = moduleName.replace('.', '/') + "/";
            String moduleFileName = '_' + moduleName.substring(lastPoint + 1) + extension;
            String path = rootPath + '/' + packageDir + moduleFileName;
            File file = new File(path);
            PyiUtils.createParentPackageDirs(file, rootDir);
            return file;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void createParentPackageDirs(File file, File rootDir) throws IOException {
        File parent = file.getParentFile();
        if (!file.equals(rootDir)) {
            PyiUtils.createParentPackageDirs(parent, rootDir);
        }
        parent.mkdirs();
    }

    private static void writeHeader(BufferedWriter writer) throws IOException {
        writer.write("################################################################################");
        writer.newLine();
        writer.write("#          This file was automatically generated. Please do not edit.          #");
        writer.newLine();
        writer.write("################################################################################");
        writer.newLine();
        writer.newLine();
    }
}

