/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.contrib.pythonmatsim.typehints;

import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.matsim.contrib.pythonmatsim.typehints.Packages;

class TypeHintsUtils {
    private static final Map<Class<?>, String> PRIMITIVE_TYPE_NAMES = new HashMap();
    static final Collection<Class<?>> PRIMITIVE_TYPES;
    private static final Set<String> PY_KEYWORDS;

    TypeHintsUtils() {
    }

    public static Collection<Class<?>> getImportedTypes(Class<?> classe) {
        if (!classe.isArray()) {
            return Collections.singleton(classe);
        }
        return TypeHintsUtils.getImportedTypes(classe.getComponentType());
    }

    public static Map<String, Collection<Method>> getMethods(Packages.ClassInfo classe) {
        HashMap<String, Collection<Method>> methods = new HashMap<String, Collection<Method>>();
        Queue<Packages.ClassInfo> stack = Collections.asLifoQueue(new ArrayDeque());
        stack.add(classe);
        while (!stack.isEmpty()) {
            Packages.ClassInfo info = (Packages.ClassInfo)stack.remove();
            stack.addAll(info.getInnerClasses());
            for (Method method : TypeHintsUtils.getMethods(info.getRootClass())) {
                methods.computeIfAbsent(method.getName(), k -> new HashSet()).add(method);
            }
        }
        return methods;
    }

    public static Collection<Method> getMethods(Class<?> classe) {
        try {
            return Arrays.asList(classe.getMethods());
        }
        catch (NoClassDefFoundError e) {
            return Collections.emptyList();
        }
    }

    public static String pythonPackage(String module) {
        int lastPoint = module.lastIndexOf(46);
        if (lastPoint < 0) {
            return "";
        }
        return module.substring(0, lastPoint);
    }

    public static String className(String fullName) {
        int lastPoint = fullName.lastIndexOf(46);
        if (lastPoint < 0) {
            return fullName;
        }
        return fullName.substring(lastPoint + 1);
    }

    static String pythonQualifiedClassName(String rootPackage, Class<?> classe) {
        if (PRIMITIVE_TYPES.contains(classe)) {
            return TypeHintsUtils.primitivePythonClassName(classe);
        }
        try {
            String canonicalName = classe.getCanonicalName();
            if (canonicalName == null) {
                return "Any";
            }
            if (classe.isArray()) {
                Class<?> componentType = classe.getComponentType();
                return "JArray(" + TypeHintsUtils.pythonQualifiedClassName(rootPackage, componentType) + ", 1)";
            }
            if (rootPackage == null || rootPackage.length() == 0) {
                return canonicalName;
            }
            return rootPackage + "." + canonicalName;
        }
        catch (NoClassDefFoundError e) {
            return "Any";
        }
    }

    static String pythonClassName(Class<?> classe) {
        try {
            String pythonQualifiedName = TypeHintsUtils.pythonQualifiedClassName(null, classe);
            String packageName = classe.getPackage().getName();
            return pythonQualifiedName.startsWith(packageName) ? pythonQualifiedName.substring(packageName.length() + 1) : pythonQualifiedName;
        }
        catch (NoClassDefFoundError e) {
            return "Any";
        }
    }

    private static String primitivePythonClassName(Class<?> classe) {
        return PRIMITIVE_TYPE_NAMES.get(classe);
    }

    static String getJPypeName(String rawName) {
        return PY_KEYWORDS.contains(rawName) ? rawName + "_" : rawName;
    }

    static {
        PRIMITIVE_TYPE_NAMES.put(Integer.TYPE, "Union[int, JInt]");
        PRIMITIVE_TYPE_NAMES.put(Short.TYPE, "Union[int, JShort]");
        PRIMITIVE_TYPE_NAMES.put(Boolean.TYPE, "Union[int, JBoolean]");
        PRIMITIVE_TYPE_NAMES.put(Character.TYPE, "Union[string, JString]");
        PRIMITIVE_TYPE_NAMES.put(Byte.TYPE, "JByte");
        PRIMITIVE_TYPE_NAMES.put(Long.TYPE, "Union[long, JLong]");
        PRIMITIVE_TYPE_NAMES.put(Float.TYPE, "Union[float, JFloat]");
        PRIMITIVE_TYPE_NAMES.put(Double.TYPE, "Union[float, JDouble]");
        PRIMITIVE_TYPE_NAMES.put(Void.TYPE, "None");
        PRIMITIVE_TYPES = Collections.unmodifiableSet(PRIMITIVE_TYPE_NAMES.keySet());
        PY_KEYWORDS = new HashSet<String>(Arrays.asList("del", "for", "is", "raise", "assert", "elif", "from", "lambda", "return", "break", "else", "global", "not", "try", "class", "except", "if", "or", "while", "continue", "exec", "import", "pass", "yield", "def", "finally", "in", "print", "as", "None"));
    }
}

