/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.api.experimental.events;

import java.util.Map;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.Event;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.api.internal.HasPersonId;
import org.matsim.vehicles.Vehicle;

public final class BoardingDeniedEvent
extends Event
implements HasPersonId {
    public static final String EVENT_TYPE = "BoardingDeniedEvent";
    public static final String ATTRIBUTE_PERSON_ID = "person";
    public static final String ATTRIBUTE_VEHICLE_ID = "vehicle";
    private Id<Person> personId;
    private Id<Vehicle> vehicleId;

    public BoardingDeniedEvent(double time, Id<Person> personId, Id<Vehicle> vehicleId) {
        super(time);
        this.personId = personId;
        this.vehicleId = vehicleId;
    }

    @Override
    public Id<Person> getPersonId() {
        return this.personId;
    }

    public Id<Vehicle> getVehicleId() {
        return this.vehicleId;
    }

    @Override
    public Map<String, String> getAttributes() {
        Map<String, String> atts = super.getAttributes();
        atts.put(ATTRIBUTE_PERSON_ID, this.personId.toString());
        atts.put(ATTRIBUTE_VEHICLE_ID, this.vehicleId.toString());
        return atts;
    }

    @Override
    public String getEventType() {
        return EVENT_TYPE;
    }
}

