/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.api.experimental.events;

import java.util.Map;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.Event;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.api.internal.HasPersonId;

public final class TeleportationArrivalEvent
extends Event
implements HasPersonId {
    public static final String ATTRIBUTE_PERSON = "person";
    public static final String ATTRIBUTE_DISTANCE = "distance";
    public static final String EVENT_TYPE = "travelled";
    private Id<Person> agentId;
    private double distance;

    public TeleportationArrivalEvent(double time, Id<Person> agentId, double distance) {
        super(time);
        this.agentId = agentId;
        this.distance = distance;
    }

    @Override
    public Id<Person> getPersonId() {
        return this.agentId;
    }

    public double getDistance() {
        return this.distance;
    }

    @Override
    public String getEventType() {
        return EVENT_TYPE;
    }

    @Override
    public Map<String, String> getAttributes() {
        Map<String, String> attributes = super.getAttributes();
        attributes.put(ATTRIBUTE_PERSON, this.agentId.toString());
        attributes.put(ATTRIBUTE_DISTANCE, Double.toString(this.distance));
        return attributes;
    }
}

