/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.api.experimental.events;

import java.util.Map;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.Event;
import org.matsim.pt.transitSchedule.api.TransitStopFacility;
import org.matsim.vehicles.Vehicle;

public final class VehicleDepartsAtFacilityEvent
extends Event {
    public static final String EVENT_TYPE = "VehicleDepartsAtFacility";
    public static final String ATTRIBUTE_VEHICLE = "vehicle";
    public static final String ATTRIBUTE_FACILITY = "facility";
    public static final String ATTRIBUTE_DELAY = "delay";
    private final Id<Vehicle> vehicleId;
    private final Id<TransitStopFacility> facilityId;
    private final double delay;

    public VehicleDepartsAtFacilityEvent(double time, Id<Vehicle> vehicleId, Id<TransitStopFacility> facilityId, double delay) {
        super(time);
        this.vehicleId = vehicleId;
        this.facilityId = facilityId;
        this.delay = delay;
    }

    @Deprecated
    public double getDelay() {
        return this.delay;
    }

    public Id<TransitStopFacility> getFacilityId() {
        return this.facilityId;
    }

    public Id<Vehicle> getVehicleId() {
        return this.vehicleId;
    }

    @Override
    public String getEventType() {
        return EVENT_TYPE;
    }

    @Override
    public Map<String, String> getAttributes() {
        Map<String, String> attributes = super.getAttributes();
        attributes.put(ATTRIBUTE_VEHICLE, this.vehicleId.toString());
        attributes.put(ATTRIBUTE_FACILITY, this.facilityId.toString());
        attributes.put(ATTRIBUTE_DELAY, Double.toString(this.delay));
        return attributes;
    }
}

