/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.config;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.matsim.core.api.internal.MatsimExtensionPoint;
import org.matsim.core.config.ConfigGroup;
import org.matsim.core.config.consistency.ConfigConsistencyChecker;
import org.matsim.core.config.consistency.UnmaterializedConfigGroupChecker;
import org.matsim.core.config.consistency.VspConfigConsistencyCheckerImpl;
import org.matsim.core.config.groups.ChangeLegModeConfigGroup;
import org.matsim.core.config.groups.ChangeModeConfigGroup;
import org.matsim.core.config.groups.ControlerConfigGroup;
import org.matsim.core.config.groups.CountsConfigGroup;
import org.matsim.core.config.groups.FacilitiesConfigGroup;
import org.matsim.core.config.groups.GlobalConfigGroup;
import org.matsim.core.config.groups.HouseholdsConfigGroup;
import org.matsim.core.config.groups.LinkStatsConfigGroup;
import org.matsim.core.config.groups.NetworkConfigGroup;
import org.matsim.core.config.groups.ParallelEventHandlingConfigGroup;
import org.matsim.core.config.groups.PlanCalcScoreConfigGroup;
import org.matsim.core.config.groups.PlansCalcRouteConfigGroup;
import org.matsim.core.config.groups.PlansConfigGroup;
import org.matsim.core.config.groups.PtCountsConfigGroup;
import org.matsim.core.config.groups.QSimConfigGroup;
import org.matsim.core.config.groups.ScenarioConfigGroup;
import org.matsim.core.config.groups.StrategyConfigGroup;
import org.matsim.core.config.groups.SubtourModeChoiceConfigGroup;
import org.matsim.core.config.groups.TimeAllocationMutatorConfigGroup;
import org.matsim.core.config.groups.TravelTimeCalculatorConfigGroup;
import org.matsim.core.config.groups.VehiclesConfigGroup;
import org.matsim.core.config.groups.VspExperimentalConfigGroup;
import org.matsim.core.mobsim.jdeqsim.JDEQSimConfigGroup;
import org.matsim.pt.config.TransitConfigGroup;
import org.matsim.pt.config.TransitRouterConfigGroup;

public final class Config
implements MatsimExtensionPoint {
    private final TreeMap<String, ConfigGroup> modules = new TreeMap();
    private PlanCalcScoreConfigGroup charyparNagelScoring = null;
    private ControlerConfigGroup controler = null;
    private CountsConfigGroup counts = null;
    private FacilitiesConfigGroup facilities = null;
    private GlobalConfigGroup global = null;
    private HouseholdsConfigGroup households;
    private NetworkConfigGroup network = null;
    private ParallelEventHandlingConfigGroup parallelEventHandling = null;
    private PlansCalcRouteConfigGroup plansCalcRoute = null;
    private PlansConfigGroup plans = null;
    private QSimConfigGroup qSimConfigGroup = null;
    private ScenarioConfigGroup scenarioConfigGroup = null;
    private StrategyConfigGroup strategy = null;
    private TransitConfigGroup transit = null;
    private TransitRouterConfigGroup transitRouter = null;
    private LinkStatsConfigGroup linkStats = null;
    private VspExperimentalConfigGroup vspExperimentalGroup = null;
    private TimeAllocationMutatorConfigGroup timeAllocationMutator = null;
    private SubtourModeChoiceConfigGroup subtourModeChoice = null;
    private TravelTimeCalculatorConfigGroup travelTimeCalculatorConfigGroup = null;
    private PtCountsConfigGroup ptCounts = null;
    private VehiclesConfigGroup vehicles = null;
    private ChangeModeConfigGroup changeMode = null;
    private JDEQSimConfigGroup jdeqSim = null;
    private final List<ConfigConsistencyChecker> consistencyCheckers = new ArrayList<ConfigConsistencyChecker>();
    private static final Logger log = Logger.getLogger(Config.class);
    private boolean locked = false;
    private URL context;

    public Config() {
        try {
            URL currentDir = Paths.get("", new String[0]).toUri().toURL();
            this.setContext(currentDir);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public void addCoreModules() {
        this.global = new GlobalConfigGroup();
        this.modules.put("global", this.global);
        this.controler = new ControlerConfigGroup();
        this.modules.put("controler", this.controler);
        this.qSimConfigGroup = new QSimConfigGroup();
        this.modules.put("qsim", this.qSimConfigGroup);
        this.counts = new CountsConfigGroup();
        this.modules.put("counts", this.counts);
        this.charyparNagelScoring = new PlanCalcScoreConfigGroup();
        this.modules.put("planCalcScore", this.charyparNagelScoring);
        this.network = new NetworkConfigGroup();
        this.modules.put("network", this.network);
        this.plans = new PlansConfigGroup();
        this.modules.put("plans", this.plans);
        this.households = new HouseholdsConfigGroup();
        this.modules.put("households", this.households);
        this.parallelEventHandling = new ParallelEventHandlingConfigGroup();
        this.modules.put("parallelEventHandling", this.parallelEventHandling);
        this.facilities = new FacilitiesConfigGroup();
        this.modules.put("facilities", this.facilities);
        this.strategy = new StrategyConfigGroup();
        this.modules.put("strategy", this.strategy);
        this.travelTimeCalculatorConfigGroup = new TravelTimeCalculatorConfigGroup();
        this.modules.put("travelTimeCalculator", this.travelTimeCalculatorConfigGroup);
        this.scenarioConfigGroup = new ScenarioConfigGroup();
        this.modules.put("scenario", this.scenarioConfigGroup);
        this.plansCalcRoute = new PlansCalcRouteConfigGroup();
        this.modules.put("planscalcroute", this.plansCalcRoute);
        this.timeAllocationMutator = new TimeAllocationMutatorConfigGroup();
        this.modules.put("TimeAllocationMutator", this.timeAllocationMutator);
        this.vspExperimentalGroup = new VspExperimentalConfigGroup();
        this.modules.put("vspExperimental", this.vspExperimentalGroup);
        this.ptCounts = new PtCountsConfigGroup();
        this.modules.put("ptCounts", this.ptCounts);
        this.transit = new TransitConfigGroup();
        this.modules.put("transit", this.transit);
        this.linkStats = new LinkStatsConfigGroup();
        this.modules.put("linkStats", this.linkStats);
        this.transitRouter = new TransitRouterConfigGroup();
        this.modules.put("transitRouter", this.transitRouter);
        this.subtourModeChoice = new SubtourModeChoiceConfigGroup();
        this.modules.put("subtourModeChoice", this.subtourModeChoice);
        this.vehicles = new VehiclesConfigGroup();
        this.modules.put("vehicles", this.vehicles);
        this.changeMode = new ChangeModeConfigGroup();
        this.modules.put("changeMode", this.changeMode);
        this.modules.put("changeLegMode", new ChangeLegModeConfigGroup());
        this.jdeqSim = new JDEQSimConfigGroup();
        this.modules.put("JDEQSim", this.jdeqSim);
        this.addConfigConsistencyChecker(new VspConfigConsistencyCheckerImpl());
        this.addConfigConsistencyChecker(new UnmaterializedConfigGroupChecker());
    }

    public void checkConsistency() {
        for (ConfigGroup m3 : this.modules.values()) {
            m3.checkConsistency(this);
        }
        for (ConfigConsistencyChecker c : this.consistencyCheckers) {
            c.checkConsistency(this);
        }
    }

    public final ConfigGroup createModule(String name) {
        if (this.modules.containsKey(name)) {
            throw new IllegalArgumentException("Module " + name + " exists already.");
        }
        ConfigGroup m3 = new ConfigGroup(name);
        this.modules.put(name, m3);
        return m3;
    }

    public final void addModule(ConfigGroup specializedConfigModule) {
        String name = specializedConfigModule.getName();
        if (name == null || name.isEmpty()) {
            throw new RuntimeException("cannot insert module with empty name");
        }
        ConfigGroup m3 = this.modules.get(name);
        if (m3 != null) {
            if (m3.getClass() == ConfigGroup.class && specializedConfigModule.getClass() != ConfigGroup.class) {
                for (Map.Entry<String, String> e : m3.getParams().entrySet()) {
                    specializedConfigModule.addParam(e.getKey(), e.getValue());
                }
                this.modules.put(name, specializedConfigModule);
            } else {
                throw new IllegalArgumentException("Module " + name + " exists already.");
            }
        }
        this.modules.put(name, specializedConfigModule);
    }

    public final void removeModule(String name) {
        if (this.modules.containsKey(name)) {
            this.modules.remove(name);
            log.warn("Module \"" + name + "\" is removed manually from config");
        }
    }

    public final TreeMap<String, ConfigGroup> getModules() {
        return this.modules;
    }

    @Deprecated
    public final ConfigGroup getModule(String moduleName) {
        return this.modules.get(moduleName);
    }

    @Deprecated
    public final String getParam(String moduleName, String paramName) {
        ConfigGroup m3 = this.modules.get(moduleName);
        if (m3 == null) {
            log.error("Module \"" + moduleName + "\" is not known.");
            throw new IllegalArgumentException("Module \"" + moduleName + "\" is not known.");
        }
        String str = m3.getValue(paramName);
        if (str == null) {
            String message = "Parameter \"" + paramName + "\" of module \"" + moduleName + "\" is not known";
            log.error(message);
            throw new IllegalArgumentException(message);
        }
        return str;
    }

    @Deprecated
    public final String findParam(String moduleName, String paramName) {
        ConfigGroup m3 = this.modules.get(moduleName);
        if (m3 == null) {
            return null;
        }
        try {
            String str = m3.getValue(paramName);
            if (str == null) {
                return null;
            }
            return str;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public final String toString() {
        return "[nof_modules=" + this.modules.size() + "]";
    }

    @Deprecated
    public final void setParam(String moduleName, String paramName, String value) {
        this.checkIfLocked();
        ConfigGroup m3 = this.modules.get(moduleName);
        if (m3 == null) {
            m3 = this.createModule(moduleName);
            log.info("module \"" + moduleName + "\" added.");
        }
        m3.addParam(paramName, value);
    }

    public final GlobalConfigGroup global() {
        return this.global;
    }

    public final ControlerConfigGroup controler() {
        return this.controler;
    }

    public final CountsConfigGroup counts() {
        return this.counts;
    }

    public final PlanCalcScoreConfigGroup planCalcScore() {
        return this.charyparNagelScoring;
    }

    public final NetworkConfigGroup network() {
        return this.network;
    }

    public final PlansConfigGroup plans() {
        return this.plans;
    }

    public final HouseholdsConfigGroup households() {
        return this.households;
    }

    public final FacilitiesConfigGroup facilities() {
        return this.facilities;
    }

    public final StrategyConfigGroup strategy() {
        return this.strategy;
    }

    public TravelTimeCalculatorConfigGroup travelTimeCalculator() {
        return this.travelTimeCalculatorConfigGroup;
    }

    public ScenarioConfigGroup scenario() {
        return this.scenarioConfigGroup;
    }

    public PlansCalcRouteConfigGroup plansCalcRoute() {
        return this.plansCalcRoute;
    }

    public VspExperimentalConfigGroup vspExperimental() {
        return this.vspExperimentalGroup;
    }

    public QSimConfigGroup qsim() {
        return this.qSimConfigGroup;
    }

    public PtCountsConfigGroup ptCounts() {
        return this.ptCounts;
    }

    public TransitConfigGroup transit() {
        return this.transit;
    }

    public TransitRouterConfigGroup transitRouter() {
        return this.transitRouter;
    }

    public LinkStatsConfigGroup linkStats() {
        return this.linkStats;
    }

    public TimeAllocationMutatorConfigGroup timeAllocationMutator() {
        return this.timeAllocationMutator;
    }

    public ParallelEventHandlingConfigGroup parallelEventHandling() {
        return this.parallelEventHandling;
    }

    public SubtourModeChoiceConfigGroup subtourModeChoice() {
        return this.subtourModeChoice;
    }

    public ChangeModeConfigGroup changeMode() {
        return this.changeMode;
    }

    public JDEQSimConfigGroup jdeqSim() {
        return this.jdeqSim;
    }

    public void addConfigConsistencyChecker(ConfigConsistencyChecker checker) {
        boolean alreadyExists = false;
        for (ConfigConsistencyChecker ch : this.consistencyCheckers) {
            if (!ch.getClass().equals(checker.getClass())) continue;
            alreadyExists = true;
        }
        if (!alreadyExists) {
            this.consistencyCheckers.add(checker);
        } else {
            log.info("ConfigConsistencyChecker with runtime type=" + checker.getClass() + " was already added; not adding it a second time");
        }
    }

    public void removeConfigConsistencyChecker(Class clazz) {
        this.consistencyCheckers.removeIf(ch -> ch.getClass().equals(clazz));
    }

    public final boolean isLocked() {
        return this.locked;
    }

    public final void setLocked(boolean locked) {
        this.locked = locked;
    }

    private void checkIfLocked() {
        if (this.isLocked()) {
            log.error("too late in execution sequence to set config items. Use");
            log.error("   Config config = ConfigUtils.loadConfig(filename); ");
            log.error("   config.xxx().setYyy(...); ");
            log.error("   Controler ctrl = new Controler( config );");
            log.error("or");
            log.error("   Config config = ConfigUtils.loadConfig(filename); ");
            log.error("   config.xxx().setYyy(...); ");
            log.error("   Scenario scenario = ScenarioUtils.loadScenario(config);");
            log.error("   // do something with scenario");
            log.error("   Controler ctrl = new Controler( scenario );");
            log.error("This will be changed to an abortive error in the future.");
        }
    }

    public final VehiclesConfigGroup vehicles() {
        return this.vehicles;
    }

    public void setContext(URL context) {
        if (this.context == null || !context.toString().equals(this.context.toString())) {
            log.info("setting context to [" + context + "]");
        }
        this.context = context;
    }

    public URL getContext() {
        return this.context;
    }
}

