/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.config;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.validation.Valid;
import org.apache.log4j.Logger;
import org.matsim.core.api.internal.MatsimExtensionPoint;
import org.matsim.core.config.Config;
import org.matsim.core.utils.io.IOUtils;

public class ConfigGroup
implements MatsimExtensionPoint {
    private final String name;
    private final TreeMap<String, String> params;
    private final Map<String, Collection<@Valid ConfigGroup>> parameterSetsPerType = new HashMap<String, Collection<ConfigGroup>>();
    private boolean locked = false;
    private static final Logger log = Logger.getLogger(ConfigGroup.class);

    public ConfigGroup(String name) {
        this.name = name;
        this.params = new TreeMap();
    }

    public void addParam(String paramName, String value) {
        if (this.params.containsKey(paramName)) {
            log.info(this.toString() + "[paramName=" + paramName + ",oldValue=" + this.params.get(paramName) + ",value=" + value + " value replaced]");
        }
        this.params.put(paramName, value);
    }

    protected void addParameterToMap(Map<String, String> map, String paramName) {
        String value = this.getValue(paramName);
        if (value != null && !value.equalsIgnoreCase("null")) {
            map.put(paramName, value);
        } else {
            map.put(paramName, "null");
        }
    }

    protected void checkConsistency(Config config) {
        for (Collection<? extends ConfigGroup> collection : this.getParameterSets().values()) {
            for (ConfigGroup configGroup : collection) {
                configGroup.checkConsistency(config);
            }
        }
    }

    @Deprecated
    public String getValue(String paramName) {
        return this.params.get(paramName);
    }

    public final String getName() {
        return this.name;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public Map<String, String> getComments() {
        return new HashMap<String, String>();
    }

    public final String toString() {
        StringBuilder str = new StringBuilder();
        for (Map.Entry<String, String> entry : this.getParams().entrySet()) {
            str.append('[');
            str.append(entry.getKey());
            str.append('=');
            str.append(entry.getValue());
            str.append(']');
        }
        return "[name=" + this.getName() + "]" + "[nOfParams=" + this.getParams().size() + "]" + str.toString();
    }

    public ConfigGroup createParameterSet(String type) {
        return new ConfigGroup(type);
    }

    public void addParameterSet(ConfigGroup set) {
        this.checkParameterSet(set);
        Collection<ConfigGroup> parameterSets = this.parameterSetsPerType.get(set.getName());
        if (parameterSets == null) {
            parameterSets = new ArrayList<ConfigGroup>();
            this.parameterSetsPerType.put(set.getName(), parameterSets);
        }
        parameterSets.add(set);
    }

    public boolean removeParameterSet(ConfigGroup set) {
        Collection<ConfigGroup> parameterSets = this.parameterSetsPerType.get(set.getName());
        return parameterSets != null ? parameterSets.remove(set) : false;
    }

    protected void checkParameterSet(ConfigGroup set) {
    }

    protected final Collection<? extends ConfigGroup> clearParameterSetsForType(String type) {
        return this.parameterSetsPerType.remove(type);
    }

    public final Collection<? extends ConfigGroup> getParameterSets(String type) {
        Collection<ConfigGroup> sets = this.parameterSetsPerType.get(type);
        return sets == null ? Collections.emptySet() : Collections.unmodifiableCollection(sets);
    }

    public final Map<String, ? extends Collection<? extends ConfigGroup>> getParameterSets() {
        TreeMap<String, Collection<ConfigGroup>> parameterSetsPerType2 = new TreeMap<String, Collection<ConfigGroup>>();
        for (Map.Entry<String, Collection<ConfigGroup>> entry : this.parameterSetsPerType.entrySet()) {
            parameterSetsPerType2.put(entry.getKey(), Collections.unmodifiableCollection(entry.getValue()));
        }
        return Collections.unmodifiableMap(parameterSetsPerType2);
    }

    public final boolean isLocked() {
        return this.locked;
    }

    public void setLocked() {
        this.locked = true;
        for (Collection<ConfigGroup> parameterSets : this.parameterSetsPerType.values()) {
            for (ConfigGroup parameterSet : parameterSets) {
                parameterSet.setLocked();
            }
        }
    }

    public final void testForLocked() {
        if (this.locked) {
            throw new RuntimeException("Too late to change this ...");
        }
    }

    public static URL getInputFileURL(URL context, String filename) {
        if (filename.startsWith("~" + File.separator)) {
            filename = System.getProperty("user.home") + filename.substring(1);
            return IOUtils.newUrl(null, filename);
        }
        if (filename.startsWith(File.separator)) {
            return IOUtils.newUrl(null, filename);
        }
        return IOUtils.newUrl(context, filename);
    }
}

