/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.config;

import java.util.Stack;
import org.apache.log4j.Logger;
import org.matsim.core.config.Config;
import org.matsim.core.config.ConfigReaderMatsimV1;
import org.matsim.core.config.ConfigReaderMatsimV2;
import org.matsim.core.utils.io.MatsimXmlParser;
import org.matsim.core.utils.io.UncheckedIOException;
import org.xml.sax.Attributes;

public final class ConfigReader
extends MatsimXmlParser {
    private static final Logger log = Logger.getLogger(ConfigReader.class);
    private static final String CONFIG_V1 = "config_v1.dtd";
    private static final String CONFIG_V2 = "config_v2.dtd";
    private final Config config;
    private MatsimXmlParser delegate = null;
    private String localDtd;

    public ConfigReader(Config config) {
        this.config = config;
    }

    @Override
    public void startTag(String name, Attributes atts, Stack<String> context) {
        this.delegate.startTag(name, atts, context);
    }

    @Override
    public void endTag(String name, String content, Stack<String> context) {
        this.delegate.endTag(name, content, context);
    }

    public void readFile(String filename, String dtdFilename) throws UncheckedIOException {
        log.info("trying to read config from " + filename);
        this.localDtd = dtdFilename;
        this.readFile(filename);
        this.localDtd = null;
    }

    @Override
    protected void setDoctype(String doctype) {
        super.setDoctype(doctype);
        if (CONFIG_V1.equals(doctype)) {
            this.delegate = new ConfigReaderMatsimV1(this.config);
            log.info("using config_v1-reader.");
        } else if (CONFIG_V2.equals(doctype)) {
            this.delegate = new ConfigReaderMatsimV2(this.config);
            log.info("using config_v2-reader");
        } else {
            throw new IllegalArgumentException("Doctype \"" + doctype + "\" not known.");
        }
    }
}

