/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.config;

import java.util.Stack;
import org.apache.log4j.Logger;
import org.matsim.core.config.Config;
import org.matsim.core.config.ConfigGroup;
import org.matsim.core.config.groups.ExternalMobimConfigGroup;
import org.matsim.core.utils.io.MatsimXmlParser;
import org.xml.sax.Attributes;

class ConfigReaderMatsimV1
extends MatsimXmlParser {
    private static final Logger log = Logger.getLogger(ConfigReaderMatsimV1.class);
    private static final String MODULE = "module";
    private static final String INCLUDE = "include";
    private static final String PARAM = "param";
    private static final String msg = "using deprecated config version; please switch to config v2; your output_config.xml will be in the correct version; v1 will fail eventually, since we want to reduce the workload on keeping everything between v1 and v2 consistent (look into PlanCalcScoreConfigGroup or PlanCalcRouteConfigGroup if you want to know what we mean).";
    private final Config config;
    private ConfigGroup currmodule = null;
    private String localDtd;

    public ConfigReaderMatsimV1(Config config) {
        this.config = config;
        log.warn(msg);
    }

    @Override
    public void startTag(String name, Attributes atts, Stack<String> context) {
        if (PARAM.equals(name)) {
            this.startParam(atts);
        } else if (MODULE.equals(name)) {
            this.startModule(atts);
        } else if (INCLUDE.equals(name)) {
            log.warn("<include> is currently not supported.");
        }
    }

    @Override
    public void endTag(String name, String content, Stack<String> context) {
        if (MODULE.equals(name)) {
            if ("global".equals(name) && !this.config.global().isInsistingOnDeprecatedConfigVersion()) {
                throw new RuntimeException(msg);
            }
            this.currmodule = null;
        }
    }

    private void startModule(Attributes atts) {
        String name = atts.getValue("name");
        this.currmodule = this.config.getModule(name);
        if (this.currmodule == null) {
            if (name.equals("qsim")) {
                this.currmodule = this.config.qsim();
            } else if (name.equals("externalMobsim")) {
                this.currmodule = new ExternalMobimConfigGroup();
                this.config.addModule(this.currmodule);
            } else {
                this.currmodule = this.config.createModule(atts.getValue("name"));
            }
        }
    }

    private void startParam(Attributes meta) {
        this.currmodule.addParam(meta.getValue("name"), meta.getValue("value"));
    }

    public void readFile(String filename, String dtdFilename) {
        this.localDtd = dtdFilename;
        this.readFile(filename);
        this.localDtd = null;
    }
}

