/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.config;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Stack;
import org.matsim.core.config.Config;
import org.matsim.core.config.ConfigGroup;
import org.matsim.core.config.ConfigV2XmlNames;
import org.matsim.core.utils.io.MatsimXmlParser;
import org.xml.sax.Attributes;

class ConfigReaderMatsimV2
extends MatsimXmlParser {
    private final Config config;
    private final Deque<ConfigGroup> moduleStack = new ArrayDeque<ConfigGroup>();

    ConfigReaderMatsimV2(Config config) {
        this.config = config;
    }

    @Override
    public void startTag(String name, Attributes atts, Stack<String> context) {
        if (name.equals(ConfigV2XmlNames.MODULE)) {
            this.startModule(atts);
        } else if (name.equals(ConfigV2XmlNames.PARAMETER_SET)) {
            this.startParameterSet(atts);
        } else if (name.equals(ConfigV2XmlNames.PARAMETER)) {
            this.startParameter(atts);
        } else if (!name.equals("config")) {
            throw new IllegalArgumentException("unkown tag " + name);
        }
    }

    private void startParameter(Attributes atts) {
        this.moduleStack.getFirst().addParam(atts.getValue(ConfigV2XmlNames.NAME), atts.getValue(ConfigV2XmlNames.VALUE));
    }

    private void startParameterSet(Attributes atts) {
        ConfigGroup m3 = this.moduleStack.getFirst().createParameterSet(atts.getValue(ConfigV2XmlNames.TYPE));
        this.moduleStack.addFirst(m3);
    }

    private void startModule(Attributes atts) {
        ConfigGroup m3 = this.config.getModule(atts.getValue(ConfigV2XmlNames.NAME));
        this.moduleStack.addFirst(m3 == null ? this.config.createModule(atts.getValue(ConfigV2XmlNames.NAME)) : m3);
    }

    @Override
    public void endTag(String name, String content, Stack<String> context) {
        if (name.equals(ConfigV2XmlNames.MODULE) || name.equals(ConfigV2XmlNames.PARAMETER_SET)) {
            ConfigGroup head = this.moduleStack.removeFirst();
            if (!this.moduleStack.isEmpty()) {
                this.moduleStack.getFirst().addParameterSet(head);
            }
        }
    }
}

