/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.config;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import org.matsim.api.core.v01.Id;
import org.matsim.core.api.internal.MatsimExtensionPoint;
import org.matsim.core.config.CommandLine;
import org.matsim.core.config.Config;
import org.matsim.core.config.ConfigGroup;
import org.matsim.core.config.ConfigReader;
import org.matsim.core.config.ConfigWriter;
import org.matsim.core.config.groups.PlansConfigGroup;
import org.matsim.core.config.groups.StrategyConfigGroup;
import org.matsim.core.config.groups.VspExperimentalConfigGroup;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.utils.io.IOUtils;
import org.matsim.core.utils.io.UncheckedIOException;

public abstract class ConfigUtils
implements MatsimExtensionPoint {
    public static Config createConfig(String context) {
        URL url = IOUtils.getUrlFromFileOrResource(context);
        return ConfigUtils.createConfig(url);
    }

    public static Config createConfig(URL context) {
        Config config = ConfigUtils.createConfig();
        config.setContext(context);
        return config;
    }

    public static Config createConfig() {
        Config config = new Config();
        config.addCoreModules();
        return config;
    }

    public static Config createConfig(ConfigGroup ... customModules) {
        Config config = ConfigUtils.createConfig();
        for (ConfigGroup customModule : customModules) {
            config.addModule(customModule);
        }
        return config;
    }

    public static Config loadConfig(String filename, ConfigGroup ... customModules) throws UncheckedIOException {
        return ConfigUtils.loadConfig(IOUtils.getUrlFromFileOrResource(filename), customModules);
    }

    public static Config loadConfig(String[] args, ConfigGroup ... customModules) {
        String[] typedArgs = Arrays.copyOfRange(args, 1, args.length);
        return ConfigUtils.loadConfig(IOUtils.getUrlFromFileOrResource(args[0]), typedArgs, customModules);
    }

    public static Config loadConfig(Config config, String[] args, ConfigGroup ... customModules) {
        String[] typedArgs = Arrays.copyOfRange(args, 1, args.length);
        return ConfigUtils.loadConfig(config, IOUtils.getUrlFromFileOrResource(args[0]), typedArgs, customModules);
    }

    public static Config loadConfig(URL url, String[] typedArgs, ConfigGroup ... customModules) {
        Config config = ConfigUtils.loadConfig(url, customModules);
        return ConfigUtils.applyCommandline(config, typedArgs);
    }

    public static Config loadConfig(Config config, URL url, String[] typedArgs, ConfigGroup ... customModules) {
        ConfigUtils.loadConfig(config, url, customModules);
        return ConfigUtils.applyCommandline(config, typedArgs);
    }

    public static Config applyCommandline(Config config, String[] typedArgs) {
        try {
            CommandLine.Builder bld = new CommandLine.Builder(typedArgs);
            bld.allowAnyOption(true);
            bld.allowPositionalArguments(false);
            CommandLine cmd = bld.build();
            cmd.applyConfiguration(config);
        }
        catch (CommandLine.ConfigurationException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return config;
    }

    public static Config loadConfig(URL url, ConfigGroup ... customModules) throws UncheckedIOException {
        Gbl.assertNotNull(url);
        Config config = new Config();
        config.addCoreModules();
        for (ConfigGroup customModule : customModules) {
            config.addModule(customModule);
        }
        new ConfigReader(config).parse(url);
        config.setContext(url);
        return config;
    }

    public static void loadConfig(Config config, String filename) throws UncheckedIOException {
        if (config.global() == null) {
            config.addCoreModules();
            new ConfigReader(config).readFile(filename);
        } else {
            new ConfigReader(config).readFile(filename);
        }
    }

    public static void loadConfig(Config config, URL url, ConfigGroup ... customModules) throws UncheckedIOException {
        if (config.global() == null) {
            config.addCoreModules();
        }
        for (ConfigGroup customModule : customModules) {
            config.addModule(customModule);
        }
        new ConfigReader(config).parse(url);
    }

    public static Config loadConfig(URL url) {
        Config config = new Config();
        config.addCoreModules();
        new ConfigReader(config).parse(url);
        config.setContext(url);
        return config;
    }

    public static void modifyFilePaths(Config config, String pathPrefix) {
        String prefix = pathPrefix;
        if (!prefix.endsWith("/") && !prefix.endsWith(File.separator)) {
            prefix = prefix + File.separator;
        }
        config.controler().setOutputDirectory(ConfigUtils.getAbsolutePath(prefix, config.controler().getOutputDirectory()));
        config.network().setInputFile(ConfigUtils.getAbsolutePath(prefix, config.network().getInputFile()));
        config.plans().setInputFile(ConfigUtils.getAbsolutePath(prefix, config.plans().getInputFile()));
        config.facilities().setInputFile(ConfigUtils.getAbsolutePath(prefix, config.facilities().getInputFile()));
        config.counts().setInputFile(ConfigUtils.getAbsolutePath(prefix, config.counts().getCountsFileName()));
        config.households().setInputFile(ConfigUtils.getAbsolutePath(prefix, config.households().getInputFile()));
    }

    private static String getAbsolutePath(String prefix, String path) {
        if (path == null) {
            return null;
        }
        File file = new File(path);
        if (file.exists() && path.equals(file.getAbsolutePath())) {
            return path;
        }
        String absolutePath = prefix + path;
        return absolutePath;
    }

    public static Id<StrategyConfigGroup.StrategySettings> createAvailableStrategyId(Config config) {
        long maxStrategyId = 0L;
        Iterator<StrategyConfigGroup.StrategySettings> iterator = config.strategy().getStrategySettings().iterator();
        while (iterator.hasNext()) {
            maxStrategyId = Math.max(maxStrategyId, Long.parseLong(iterator.next().getId().toString()));
        }
        return Id.create(maxStrategyId + 1L, StrategyConfigGroup.StrategySettings.class);
    }

    public static <T extends ConfigGroup> T addOrGetModule(Config config, Class<T> moduleClass) {
        String groupName;
        try {
            groupName = ((ConfigGroup)moduleClass.newInstance()).getName();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        return ConfigUtils.addOrGetModule(config, groupName, moduleClass);
    }

    public static <T extends ConfigGroup> T addOrGetModule(Config config, String groupName, Class<T> moduleClass) {
        ConfigGroup module = config.getModule(groupName);
        if (module == null || module.getClass() == ConfigGroup.class) {
            try {
                module = (ConfigGroup)moduleClass.newInstance();
                config.addModule(module);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        return (T)((ConfigGroup)moduleClass.cast(module));
    }

    public static void setVspDefaults(Config config) {
        config.timeAllocationMutator().setMutationRange(7200.0);
        config.timeAllocationMutator().setAffectingDuration(false);
        config.plans().setRemovingUnneccessaryPlanAttributes(true);
        config.plans().setActivityDurationInterpretation(PlansConfigGroup.ActivityDurationInterpretation.tryEndTimeThenDuration);
        config.vspExperimental().setVspDefaultsCheckingLevel(VspExperimentalConfigGroup.VspDefaultsCheckingLevel.warn);
    }

    public static void writeConfig(Config config, String filename) {
        new ConfigWriter(config).write(filename);
    }

    public static void writeMinimalConfig(Config config, String filename) {
        new ConfigWriter(config, ConfigWriter.Verbosity.minimal).write(filename);
    }
}

