/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.config;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import org.matsim.core.api.internal.MatsimWriter;
import org.matsim.core.config.Config;
import org.matsim.core.config.ConfigGroup;
import org.matsim.core.config.ConfigWriterHandler;
import org.matsim.core.config.ConfigWriterHandlerImplV1;
import org.matsim.core.config.ConfigWriterHandlerImplV2;
import org.matsim.core.utils.io.MatsimXmlWriter;
import org.matsim.core.utils.io.UncheckedIOException;

public final class ConfigWriter
extends MatsimXmlWriter
implements MatsimWriter {
    private final Config config;
    private ConfigWriterHandler handler = null;
    private String dtd = null;

    public ConfigWriter(Config config, Verbosity verbosity) {
        this.config = config;
        this.dtd = "http://www.matsim.org/files/dtd/config_v2.dtd";
        this.handler = new ConfigWriterHandlerImplV2(verbosity);
    }

    public ConfigWriter(Config config) {
        this(config, Verbosity.all);
    }

    public final void writeStream(Writer writer) {
        try {
            this.writer = new BufferedWriter(writer);
            this.write();
            this.writer.flush();
            this.writer = null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public final void writeStream(Writer writer, String newline) {
        try {
            String formerNewLine = this.handler.setNewline(newline);
            this.writer = new BufferedWriter(writer);
            this.write();
            this.writer.flush();
            this.writer = null;
            this.handler.setNewline(formerNewLine);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public final void write(String filename) throws UncheckedIOException {
        this.openFile(filename);
        this.write();
        this.close();
    }

    public final void writeFileV1(String filename) {
        this.dtd = "http://www.matsim.org/files/dtd/config_v1.dtd";
        this.handler = new ConfigWriterHandlerImplV1();
        this.write(filename);
    }

    public final void writeFileV2(String filename) {
        this.dtd = "http://www.matsim.org/files/dtd/config_v2.dtd";
        this.handler = new ConfigWriterHandlerImplV2(Verbosity.all);
        this.write(filename);
    }

    private void write() {
        try {
            this.writeXmlHead();
            this.writeDoctype("config", this.dtd);
            this.handler.startConfig(this.config, this.writer);
            this.handler.writeSeparator(this.writer);
            for (ConfigGroup m3 : this.config.getModules().values()) {
                this.handler.writeModule(m3, this.writer);
                this.handler.writeSeparator(this.writer);
            }
            this.handler.endConfig(this.writer);
            this.writer.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static enum Verbosity {
        all,
        minimal;

    }
}

