/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.config;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Map;
import org.matsim.core.config.Config;
import org.matsim.core.config.ConfigGroup;
import org.matsim.core.config.ConfigWriterHandler;
import org.matsim.core.utils.io.UncheckedIOException;

class ConfigWriterHandlerImplV1
extends ConfigWriterHandler {
    private String newline = "\n";

    ConfigWriterHandlerImplV1() {
    }

    @Override
    public String setNewline(String newline) {
        String former = this.newline;
        this.newline = newline;
        return former;
    }

    @Override
    void startConfig(Config config, BufferedWriter out) throws UncheckedIOException {
        try {
            out.write("<config>");
            out.write(this.newline);
            out.write(this.newline);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    void endConfig(BufferedWriter out) throws UncheckedIOException {
        try {
            out.write("</config>");
            out.write(this.newline);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    void writeModule(ConfigGroup module, BufferedWriter out) throws UncheckedIOException {
        Map<String, String> params = module.getParams();
        Map<String, String> comments = module.getComments();
        try {
            out.write("\t<module");
            out.write(" name=\"" + module.getName() + "\" >");
            out.write(this.newline);
            boolean lastHadComment = false;
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (comments.get(entry.getKey()) != null) {
                    out.write(this.newline);
                    out.write("\t\t<!-- " + comments.get(entry.getKey()) + " -->");
                    out.write(this.newline);
                    lastHadComment = true;
                } else {
                    if (lastHadComment) {
                        out.write(this.newline);
                    }
                    lastHadComment = false;
                }
                out.write("\t\t<param name=\"" + entry.getKey() + "\" value=\"" + entry.getValue() + "\" />");
                out.write(this.newline);
            }
            out.write("\t</module>");
            out.write(this.newline);
            out.write(this.newline);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    void writeSeparator(BufferedWriter out) throws UncheckedIOException {
        try {
            out.write("<!-- ====================================================================== -->");
            out.write(this.newline);
            out.write(this.newline);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

