/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.config;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.matsim.core.config.Config;
import org.matsim.core.config.ConfigGroup;
import org.matsim.core.config.ConfigUtils;
import org.matsim.core.config.ConfigV2XmlNames;
import org.matsim.core.config.ConfigWriter;
import org.matsim.core.config.ConfigWriterHandler;
import org.matsim.core.config.groups.ChangeLegModeConfigGroup;
import org.matsim.core.config.groups.PlanCalcScoreConfigGroup;
import org.matsim.core.config.groups.PlansCalcRouteConfigGroup;
import org.matsim.core.config.groups.StrategyConfigGroup;
import org.matsim.core.utils.io.UncheckedIOException;

class ConfigWriterHandlerImplV2
extends ConfigWriterHandler {
    private String newline = "\n";
    private final ConfigWriter.Verbosity verbosity;
    private final Set<String> commentsAlreadyWritten = new HashSet<String>();

    ConfigWriterHandlerImplV2(ConfigWriter.Verbosity verbosity) {
        this.verbosity = verbosity;
    }

    private void writeModule(BufferedWriter writer, String indent, String moduleTag, String moduleNameAtt, String moduleName, ConfigGroup module, ConfigGroup comparisonModule) {
        Map<String, String> params = module.getParams();
        Map<String, String> comments = module.getComments();
        try {
            boolean headerHasBeenWritten = this.writeRegularEntries(writer, indent, moduleTag, moduleNameAtt, moduleName, comparisonModule, params, comments);
            if (moduleName.equals("thisAintNoFlat")) {
                Logger.getLogger(this.getClass()).warn("here");
            }
            if (headerHasBeenWritten = this.processParameterSets(writer, indent, moduleTag, moduleNameAtt, moduleName, module, comparisonModule, headerHasBeenWritten).booleanValue()) {
                writer.write(indent);
                writer.write("\t</" + moduleTag + ">");
                writer.write(this.newline);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Boolean processParameterSets(BufferedWriter writer, String indent, String moduleTag, String moduleNameAtt, String moduleName, ConfigGroup module, ConfigGroup comparisonModule, Boolean headerHasBeenWritten) throws IOException {
        for (Map.Entry<String, ? extends Collection<? extends ConfigGroup>> entry : module.getParameterSets().entrySet()) {
            Collection<Object> comparisonSets = new ArrayList();
            if (comparisonModule != null) {
                comparisonSets = comparisonModule.getParameterSets(entry.getKey());
            }
            for (ConfigGroup configGroup : entry.getValue()) {
                ConfigGroup comparisonPSet = null;
                for (ConfigGroup configGroup2 : comparisonSets) {
                    if (!ConfigWriterHandlerImplV2.sameType(configGroup, configGroup2)) continue;
                    comparisonPSet = configGroup2;
                    break;
                }
                if (this.verbosity == ConfigWriter.Verbosity.minimal && comparisonPSet == null) {
                    if (configGroup instanceof PlanCalcScoreConfigGroup.ScoringParameterSet) {
                        comparisonPSet = ((PlanCalcScoreConfigGroup)comparisonModule).getOrCreateScoringParameters(((PlanCalcScoreConfigGroup.ScoringParameterSet)configGroup).getSubpopulation());
                    } else if (configGroup instanceof PlanCalcScoreConfigGroup.ModeParams) {
                        comparisonPSet = ((PlanCalcScoreConfigGroup.ScoringParameterSet)comparisonModule).getOrCreateModeParams(((PlanCalcScoreConfigGroup.ModeParams)configGroup).getMode());
                    } else if (configGroup instanceof PlanCalcScoreConfigGroup.ActivityParams) {
                        comparisonPSet = ((PlanCalcScoreConfigGroup.ScoringParameterSet)comparisonModule).getOrCreateActivityParams(((PlanCalcScoreConfigGroup.ActivityParams)configGroup).getActivityType());
                    } else if (configGroup instanceof PlansCalcRouteConfigGroup.ModeRoutingParams) {
                        comparisonPSet = ((PlansCalcRouteConfigGroup)comparisonModule).getOrCreateModeRoutingParams(((PlansCalcRouteConfigGroup.ModeRoutingParams)configGroup).getMode());
                    } else {
                        try {
                            comparisonPSet = (ConfigGroup)configGroup.getClass().newInstance();
                        }
                        catch (IllegalAccessException | InstantiationException e) {
                            comparisonPSet = new ConfigGroup(configGroup.getName());
                        }
                    }
                }
                if (!headerHasBeenWritten.booleanValue()) {
                    headerHasBeenWritten = true;
                    ConfigWriterHandlerImplV2.writeHeader(writer, indent, moduleTag, moduleNameAtt, moduleName, this.newline);
                }
                this.writeModule(writer, indent + "\t", ConfigV2XmlNames.PARAMETER_SET, ConfigV2XmlNames.TYPE, entry.getKey(), configGroup, comparisonPSet);
            }
        }
        return headerHasBeenWritten;
    }

    private Boolean writeRegularEntries(BufferedWriter writer, String indent, String moduleTag, String moduleNameAtt, String moduleName, ConfigGroup comparisonModule, Map<String, String> params, Map<String, String> comments) throws IOException {
        boolean headerHasBeenWritten = false;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String actual = entry.getValue();
            if (this.verbosity == ConfigWriter.Verbosity.minimal && comparisonModule != null) {
                String defaultValue = comparisonModule.getParams().get(entry.getKey());
                switch (entry.getKey()) {
                    case "typicalDuration": {
                        defaultValue = null;
                        break;
                    }
                    case "mode": {
                        defaultValue = null;
                        break;
                    }
                    case "activityType": {
                        defaultValue = null;
                    }
                }
                if (actual.equals(defaultValue)) continue;
            }
            if (!headerHasBeenWritten) {
                headerHasBeenWritten = true;
                ConfigWriterHandlerImplV2.writeHeader(writer, indent, moduleTag, moduleNameAtt, moduleName, this.newline);
            }
            String key = entry.getKey() + "." + moduleName;
            if (comments.get(entry.getKey()) != null && !this.commentsAlreadyWritten.contains(key)) {
                this.commentsAlreadyWritten.add(key);
                writer.write(indent);
                writer.write("\t\t<!-- " + comments.get(entry.getKey()) + " -->");
                writer.write(this.newline);
            }
            writer.write(indent);
            writer.write("\t\t<" + ConfigV2XmlNames.PARAMETER + " name=\"" + entry.getKey() + "\" value=\"" + actual + "\" />");
            writer.write(this.newline);
        }
        return headerHasBeenWritten;
    }

    private static void writeHeader(BufferedWriter writer, String indent, String moduleTag, String moduleNameAtt, String moduleName, String newline) throws IOException {
        writer.write(indent);
        writer.write("\t<" + moduleTag);
        writer.write(" " + moduleNameAtt + "=\"" + moduleName + "\" >");
        writer.write(newline);
    }

    private static boolean sameType(ConfigGroup pSet, ConfigGroup cg) {
        if (!pSet.getName().equals(cg.getName())) {
            return false;
        }
        if (pSet instanceof PlansCalcRouteConfigGroup.ModeRoutingParams && ((PlansCalcRouteConfigGroup.ModeRoutingParams)pSet).getMode().equals(((PlansCalcRouteConfigGroup.ModeRoutingParams)cg).getMode())) {
            return true;
        }
        if (pSet instanceof PlanCalcScoreConfigGroup.ScoringParameterSet) {
            return true;
        }
        if (pSet instanceof PlanCalcScoreConfigGroup.ModeParams && ((PlanCalcScoreConfigGroup.ModeParams)pSet).getMode().equals(((PlanCalcScoreConfigGroup.ModeParams)cg).getMode())) {
            return true;
        }
        if (pSet instanceof PlanCalcScoreConfigGroup.ActivityParams && ((PlanCalcScoreConfigGroup.ActivityParams)pSet).getActivityType().equals(((PlanCalcScoreConfigGroup.ActivityParams)cg).getActivityType())) {
            return true;
        }
        return pSet instanceof StrategyConfigGroup.StrategySettings;
    }

    @Override
    void startConfig(Config config, BufferedWriter out) {
        try {
            out.write("<" + ConfigV2XmlNames.CONFIG + ">");
            out.write(this.newline);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    void endConfig(BufferedWriter out) {
        try {
            out.write(this.newline);
            out.write("</" + ConfigV2XmlNames.CONFIG + ">");
            out.write(this.newline);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    void writeModule(ConfigGroup module, BufferedWriter out) {
        if (!(module instanceof ChangeLegModeConfigGroup)) {
            ConfigGroup comparisonConfig = null;
            if (this.verbosity == ConfigWriter.Verbosity.minimal) {
                comparisonConfig = ConfigUtils.createConfig().getModules().get(module.getName());
            }
            this.writeModule(out, "", ConfigV2XmlNames.MODULE, ConfigV2XmlNames.NAME, module.getName(), module, comparisonConfig);
        }
    }

    @Override
    void writeSeparator(BufferedWriter out) {
    }

    @Override
    String setNewline(String newline) {
        String former = this.newline;
        this.newline = newline;
        return former;
    }
}

