/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.config;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.matsim.core.api.internal.MatsimExtensionPoint;
import org.matsim.core.config.ConfigGroup;

public abstract class ReflectiveConfigGroup
extends ConfigGroup
implements MatsimExtensionPoint {
    private static final Logger log = Logger.getLogger(ReflectiveConfigGroup.class);
    private final boolean storeUnknownParameters;
    private final Map<String, Method> setters;
    private final Map<String, Method> stringGetters;

    public ReflectiveConfigGroup(String name) {
        this(name, false);
    }

    public ReflectiveConfigGroup(String name, boolean storeUnknownParametersAsStrings) {
        super(name);
        this.storeUnknownParameters = storeUnknownParametersAsStrings;
        this.setters = this.getSetters();
        this.stringGetters = this.getStringGetters();
        if (!this.setters.keySet().equals(this.stringGetters.keySet())) {
            throw new InconsistentModuleException("setters and getters inconsistent");
        }
        this.checkConvertNullAnnotations();
    }

    private void checkConvertNullAnnotations() {
        Method[] allMethods;
        Class<?> c = this.getClass();
        for (Method m3 : allMethods = c.getDeclaredMethods()) {
            StringGetter annotation = m3.getAnnotation(StringGetter.class);
            if (annotation == null) continue;
            Method g2 = this.getStringGetters().get(annotation.value());
            if (m3.isAnnotationPresent(DoNotConvertNull.class) == g2.isAnnotationPresent(DoNotConvertNull.class)) continue;
            throw new InconsistentModuleException("Inconsistent annotation of getter and setter with ConvertNull in " + this.getClass().getName());
        }
    }

    private Map<String, Method> getStringGetters() {
        Method[] allMethods;
        HashMap<String, Method> gs = new HashMap<String, Method>();
        Class<?> c = this.getClass();
        for (Method m3 : allMethods = c.getDeclaredMethods()) {
            StringGetter annotation = m3.getAnnotation(StringGetter.class);
            if (annotation == null) continue;
            ReflectiveConfigGroup.checkGetterValidity(m3);
            Method old = gs.put(annotation.value(), m3);
            if (old == null) continue;
            throw new InconsistentModuleException("several string getters for " + annotation.value());
        }
        return gs;
    }

    private static void checkGetterValidity(Method m3) {
        if (m3.getParameterTypes().length > 0) {
            throw new InconsistentModuleException("getter " + m3 + " has parameters");
        }
        if (m3.getReturnType().equals(Void.TYPE)) {
            throw new InconsistentModuleException("getter " + m3 + " has void return type");
        }
    }

    private Map<String, Method> getSetters() {
        Method[] allMethods;
        HashMap<String, Method> ss = new HashMap<String, Method>();
        Class<?> c = this.getClass();
        for (Method m3 : allMethods = c.getDeclaredMethods()) {
            StringSetter annotation = m3.getAnnotation(StringSetter.class);
            if (annotation == null) continue;
            ReflectiveConfigGroup.checkSetterValidity(m3);
            Method old = ss.put(annotation.value(), m3);
            if (old == null) continue;
            throw new InconsistentModuleException("several string setters for " + annotation.value());
        }
        return ss;
    }

    private static void checkSetterValidity(Method m3) {
        Class<?>[] params = m3.getParameterTypes();
        if (params.length != 1) {
            throw new InconsistentModuleException("setter " + m3 + " has " + params.length + " parameters instead of one");
        }
        List<Class> allowedParameterTypes = Arrays.asList(String.class, Float.class, Double.class, Integer.class, Long.class, Boolean.class, Character.class, Byte.class, Short.class, Float.TYPE, Double.TYPE, Integer.TYPE, Long.TYPE, Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE);
        if (!allowedParameterTypes.contains(params[0]) && !params[0].isEnum()) {
            throw new InconsistentModuleException("setter " + m3 + " gets a " + params[0] + ". Valid types are String, primitive types and their wrapper classes, and enumerations. " + "Other types are fine as parameters, but you will need to implement conversion strategies in the String setters.");
        }
    }

    @Override
    public final void addParam(String param_name, String value) {
        Method setter = this.setters.get(param_name);
        if (setter == null) {
            if (!this.storeUnknownParameters) {
                throw new IllegalArgumentException("Module " + this.getName() + " of type " + this.getClass().getName() + " doesn't accept unkown parameters. Parameter " + param_name + " is not part of the valid parameters: " + this.setters.keySet());
            }
            log.warn("unknown parameter " + param_name + " for group " + this.getName() + ". Here are the valid parameter names: " + this.setters.keySet());
            log.warn("Only the string value will be remembered");
            super.addParam(param_name, value);
            return;
        }
        try {
            this.invokeSetter(setter, value);
            log.trace("value " + value + " successfully set for field " + param_name + " for group " + this.getName());
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException(cause);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void invokeSetter(Method setter, String value) throws IllegalAccessException, InvocationTargetException {
        boolean accessible = setter.isAccessible();
        setter.setAccessible(true);
        Class<?>[] params = setter.getParameterTypes();
        assert (params.length == 1);
        Class<?> type = params[0];
        if (value.equals("null") && !setter.isAnnotationPresent(DoNotConvertNull.class)) {
            setter.invoke((Object)this, new Object[]{null});
        } else if (type.equals(String.class)) {
            setter.invoke((Object)this, value);
        } else if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            setter.invoke((Object)this, Float.valueOf(Float.parseFloat(value)));
        } else if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            setter.invoke((Object)this, Double.parseDouble(value));
        } else if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            setter.invoke((Object)this, Integer.parseInt(value));
        } else if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            setter.invoke((Object)this, Long.parseLong(value));
        } else if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            setter.invoke((Object)this, Boolean.parseBoolean(value));
        } else if (type.equals(Character.class) || type.equals(Character.TYPE)) {
            if (value.length() != 1) {
                throw new IllegalArgumentException(value + " is not a single char!");
            }
            setter.invoke((Object)this, Character.valueOf(value.toCharArray()[0]));
        } else if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
            setter.invoke((Object)this, Byte.parseByte(value));
        } else if (type.equals(Short.class) || type.equals(Short.TYPE)) {
            setter.invoke((Object)this, Short.parseShort(value));
        } else if (type.isEnum()) {
            try {
                setter.invoke((Object)this, Enum.valueOf(type.asSubclass(Enum.class), value));
            }
            catch (IllegalArgumentException e) {
                StringBuilder comment = new StringBuilder("Error trying to set value " + value + " for type " + type.getName() + ": possible values are ");
                ?[] consts = type.getEnumConstants();
                for (int i = 0; i < consts.length; ++i) {
                    comment.append(consts[i].toString());
                    if (i >= consts.length - 1) continue;
                    comment.append(", ");
                }
                throw new IllegalArgumentException(comment.toString(), e);
            }
        } else {
            throw new RuntimeException("no method to handle type " + type);
        }
        setter.setAccessible(accessible);
    }

    @Override
    public final String getValue(String param_name) {
        Method getter = this.stringGetters.get(param_name);
        try {
            if (getter != null) {
                boolean accessible = getter.isAccessible();
                getter.setAccessible(true);
                Object result = getter.invoke((Object)this, new Object[0]);
                getter.setAccessible(accessible);
                if (result == null) {
                    if (getter.isAnnotationPresent(DoNotConvertNull.class)) {
                        log.error("getter for parameter " + param_name + " of module " + this.getName() + " returned null.");
                        log.error("This is not allowed for this getter.");
                        throw new NullPointerException("getter for parameter " + param_name + " of module " + this.getClass().getName() + " (" + this.getName() + ") returned null.");
                    }
                    return null;
                }
                String value = "" + result;
                if (value.equals("null") && !getter.isAnnotationPresent(DoNotConvertNull.class)) {
                    throw new RuntimeException("parameter " + param_name + " understands null pointers for IO. As a consequence, the \"null\" String is not a valid value for " + getter.getName());
                }
                return value;
            }
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException(cause);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (!this.storeUnknownParameters) {
            throw new IllegalArgumentException("Module " + this.getName() + " of type " + this.getClass().getName() + " doesn't store unkown parameters. Parameter " + param_name + " is not part of the valid parameters: " + this.stringGetters.keySet());
        }
        log.warn("no getter found for param " + param_name + ": trying parent method");
        return super.getValue(param_name);
    }

    @Override
    public final Map<String, String> getParams() {
        Map<String, String> map = super.getParams();
        for (String f : this.setters.keySet()) {
            this.addParameterToMap(map, f);
        }
        return map;
    }

    @Override
    public Map<String, String> getComments() {
        Map<String, String> comments = super.getComments();
        for (Map.Entry<String, Method> entry : this.setters.entrySet()) {
            String paramName = entry.getKey();
            if (comments.containsKey(paramName)) continue;
            Method setter = entry.getValue();
            Class<?>[] params = setter.getParameterTypes();
            assert (params.length == 1);
            Class<?> type = params[0];
            if (!type.isEnum()) continue;
            StringBuilder comment = new StringBuilder("Possible values: ");
            ?[] consts = type.getEnumConstants();
            for (int i = 0; i < consts.length; ++i) {
                comment.append(consts[i].toString());
                if (i >= consts.length - 1) continue;
                comment.append(", ");
            }
            comments.put(paramName, comment.toString());
        }
        return comments;
    }

    public static class InconsistentModuleException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private InconsistentModuleException(String msg) {
            super(msg);
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface DoNotConvertNull {
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface StringGetter {
        public String value();
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface StringSetter {
        public String value();
    }
}

