/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.config.consistency;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import org.matsim.core.config.Config;
import org.matsim.core.config.ConfigGroup;
import org.matsim.core.config.consistency.ConfigConsistencyChecker;

public class BeanValidationConfigConsistencyChecker
implements ConfigConsistencyChecker {
    private static final Validator validator = Validation.buildDefaultValidatorFactory().getValidator();

    @Override
    public void checkConsistency(Config config) {
        HashSet<ConstraintViolation<ConfigGroup>> violations = new HashSet<ConstraintViolation<ConfigGroup>>();
        ArrayList<String> messages = new ArrayList<String>();
        for (ConfigGroup group : config.getModules().values()) {
            Set<ConstraintViolation<ConfigGroup>> groupViolations = validator.validate(group, new Class[0]);
            violations.addAll(groupViolations);
            for (ConstraintViolation<ConfigGroup> v : groupViolations) {
                messages.add(messages.size() + 1 + ") " + group.getClass().getName() + "(name=" + group.getName() + ")." + v.getPropertyPath() + ": " + v.getMessage());
            }
        }
        if (!violations.isEmpty()) {
            String message = messages.size() + " error(s) found in the config:\n" + messages.stream().collect(Collectors.joining("\n"));
            throw new ConstraintViolationException(message, violations);
        }
    }
}

