/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.config.consistency;

import org.apache.log4j.Logger;
import org.matsim.core.config.Config;
import org.matsim.core.config.consistency.BeanValidationConfigConsistencyChecker;
import org.matsim.core.config.consistency.ConfigConsistencyChecker;
import org.matsim.core.config.groups.ControlerConfigGroup;
import org.matsim.core.config.groups.PlanCalcScoreConfigGroup;

public final class ConfigConsistencyCheckerImpl
implements ConfigConsistencyChecker {
    private static final Logger log = Logger.getLogger(ConfigConsistencyCheckerImpl.class);

    @Override
    public void checkConsistency(Config config) {
        ConfigConsistencyCheckerImpl.checkScenarioFeaturesEnabled(config);
        ConfigConsistencyCheckerImpl.checkEventsFormatLanesSignals(config);
        ConfigConsistencyCheckerImpl.checkTravelTimeCalculationRoutingConfiguration(config);
        ConfigConsistencyCheckerImpl.checkLaneDefinitionRoutingConfiguration(config);
        ConfigConsistencyCheckerImpl.checkPlanCalcScore(config);
        ConfigConsistencyCheckerImpl.checkTransit(config);
        ConfigConsistencyCheckerImpl.checkConsistencyBetweenRouterAndTravelTimeCalculator(config);
        new BeanValidationConfigConsistencyChecker().checkConsistency(config);
    }

    static boolean checkConsistencyBetweenRouterAndTravelTimeCalculator(Config config) {
        boolean problem = false;
        return problem;
    }

    static void checkPlanCalcScore(Config c) {
        PlanCalcScoreConfigGroup.ActivityParams ptAct;
        PlanCalcScoreConfigGroup.ModeParams walkModeParams;
        PlanCalcScoreConfigGroup.ModeParams bikeModeParams;
        PlanCalcScoreConfigGroup.ModeParams carModeParams;
        PlanCalcScoreConfigGroup.ModeParams ptModeParams = c.planCalcScore().getModes().get("pt");
        if (ptModeParams != null && ptModeParams.getMarginalUtilityOfTraveling() > 0.0) {
            log.warn("planCalcScore.travelingPt is > 0. This values specifies a utility. Typically, this should be a disutility, i.e. have a negative value.");
        }
        if ((carModeParams = c.planCalcScore().getModes().get("car")) != null && carModeParams.getMarginalUtilityOfTraveling() > 0.0) {
            log.warn("planCalcScore.traveling is > 0. This values specifies a utility. Typically, this should be a disutility, i.e. have a negative value.");
        }
        if ((bikeModeParams = c.planCalcScore().getModes().get("bike")) != null && bikeModeParams.getMarginalUtilityOfTraveling() > 0.0) {
            log.warn("planCalcScore.travelingBike is > 0. This values specifies a utility. Typically, this should be a disutility, i.e. have a negative value.");
        }
        if ((walkModeParams = c.planCalcScore().getModes().get("walk")) != null && walkModeParams.getMarginalUtilityOfTraveling() > 0.0) {
            log.warn("planCalcScore.travelingWalk is > 0. This values specifies a utility. Typically, this should be a disutility, i.e. have a negative value.");
        }
        if ((ptAct = c.planCalcScore().getActivityParams("pt interaction")) != null && ptAct.isScoringThisActivityAtAll() && !c.vspExperimental().isAbleToOverwritePtInteractionParams()) {
            throw new RuntimeException("Scoring " + ptAct.getActivityType() + " is not allowed because it breaks pt scoring." + " If you need this anyway (for backwards compatibility reasons), you can allow this by a parameter in VspExperimentalConfigGroup.");
        }
    }

    private static void checkEventsFormatLanesSignals(Config c) {
        if (c.qsim().isUseLanes() && !c.controler().getEventsFileFormats().contains((Object)ControlerConfigGroup.EventsFileFormat.xml)) {
            log.error("Xml events are not enabled, but lanes and possibly signal systemsare enalbed. Events from this features will only be written to the xml format, considerto add xml events in the controler config module");
        }
    }

    private static void checkScenarioFeaturesEnabled(Config c) {
        if (!"qsim".equals(c.controler().getMobsim()) && c.qsim() == null) {
            log.warn("The signal system implementation is only supported by the org.matsim.ptproject.qsim mobility simulation that is not activated. Please make sure you are using the correctmobility simulation. This warning can be ingored if a customized mobility simulation developed outside of org.matsim is used and set correctly.");
        }
    }

    private static void checkTravelTimeCalculationRoutingConfiguration(Config config) {
        if (config.controler().isLinkToLinkRoutingEnabled() && !config.travelTimeCalculator().isCalculateLinkToLinkTravelTimes()) {
            throw new IllegalStateException("LinkToLinkRouting is activated in config and link to link traveltime calculation is not enabled but required!");
        }
        if (config.travelTimeCalculator().isCalculateLinkTravelTimes() && config.travelTimeCalculator().isCalculateLinkToLinkTravelTimes() && !config.controler().isLinkToLinkRoutingEnabled()) {
            log.warn("Config enables link travel time calculation and link to link travel time calculation. This requires at least twice as much memory as if only one method is used, however it might be necessary to enable a certain module configuration.");
        }
        if (!config.travelTimeCalculator().isCalculateLinkTravelTimes()) {
            log.warn("Link travel time calculation is switched off, be aware that this optimizationmight not work with all modules. ");
        }
        if (config.travelTimeCalculator().isCalculateLinkToLinkTravelTimes() && config.qsim().isRemoveStuckVehicles()) {
            throw new IllegalStateException("Link to link travel time calculation is notavailable if using the remove stuck vehicles option!");
        }
        if (config.controler().isLinkToLinkRoutingEnabled() && config.controler().getRoutingAlgorithmType() != ControlerConfigGroup.RoutingAlgorithmType.Dijkstra) {
            log.warn("We don't know if non-Dijkstra routing works together with LinkToLink routing.");
        }
    }

    private static void checkLaneDefinitionRoutingConfiguration(Config config) {
        if (config.qsim().isUseLanes() && !config.controler().isLinkToLinkRoutingEnabled()) {
            log.warn("Using lanes without enabling linktolinkrouting might not lead to expected simulation results");
        }
    }

    private static void checkTransit(Config config) {
    }
}

