/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.config.consistency;

import java.util.Collection;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.matsim.core.config.Config;
import org.matsim.core.config.consistency.ConfigConsistencyChecker;
import org.matsim.core.config.groups.ControlerConfigGroup;
import org.matsim.core.config.groups.PlanCalcScoreConfigGroup;
import org.matsim.core.config.groups.PlansConfigGroup;
import org.matsim.core.config.groups.QSimConfigGroup;
import org.matsim.core.config.groups.StrategyConfigGroup;
import org.matsim.core.config.groups.VspExperimentalConfigGroup;

public final class VspConfigConsistencyCheckerImpl
implements ConfigConsistencyChecker {
    private static Logger log = Logger.getLogger(VspConfigConsistencyCheckerImpl.class);

    @Override
    public void checkConsistency(Config config) {
        boolean bl;
        PlansConfigGroup.ActivityDurationInterpretation activityDurationInterpretation;
        PlanCalcScoreConfigGroup.ModeParams modeParamsPt;
        Set<ControlerConfigGroup.EventsFileFormat> formats;
        Level lvl;
        switch (config.vspExperimental().getVspDefaultsCheckingLevel()) {
            case ignore: {
                log.info("NOT running vsp config consistency check because vsp defaults checking level is set to IGNORE");
                return;
            }
            case info: {
                lvl = Level.INFO;
                break;
            }
            case warn: {
                lvl = Level.WARN;
                break;
            }
            case abort: {
                lvl = Level.WARN;
                break;
            }
            default: {
                throw new RuntimeException("not implemented");
            }
        }
        log.info("running checkConsistency ...");
        boolean problem = false;
        if (config.global().isInsistingOnDeprecatedConfigVersion()) {
            problem = true;
            System.out.flush();
            log.log(lvl, "you are insisting on config v1.  vsp default is using v2.");
        }
        if (!(formats = config.controler().getEventsFileFormats()).contains((Object)ControlerConfigGroup.EventsFileFormat.xml)) {
            problem = true;
            System.out.flush();
            log.log(lvl, "did not find xml as one of the events file formats. vsp default is using xml events.");
        }
        switch (config.controler().getRoutingAlgorithmType()) {
            case Dijkstra: 
            case AStarLandmarks: 
            case FastDijkstra: {
                log.log(lvl, "you are not using FastAStarLandmarks as routing algorithm.  vsp default is to use FastAStarLandmarks.");
                System.out.flush();
                break;
            }
        }
        boolean usingLocationChoice = false;
        if (config.getModule("locationchoice") != null) {
            usingLocationChoice = true;
        }
        if (usingLocationChoice) {
            String samplePercent = config.findParam("locationchoice", "destinationSamplePercent");
            if (samplePercent != null && !samplePercent.equals("100.")) {
                problem = true;
                System.out.flush();
                log.error("vsp will not accept location choice destination sample percent other than 100 until the corresponding warning in DestinationSampler is resolved.  kai, jan'13");
            }
            if (!config.vspExperimental().isUsingOpportunityCostOfTimeForLocationChoice()) {
                problem = true;
                System.out.flush();
                log.error("vsp will not accept location choice without including opportunity cost of time into the approximation. kai,jan'13");
            }
        }
        if (config.planCalcScore().getBrainExpBeta() != 1.0) {
            problem = true;
            System.out.flush();
            log.log(lvl, "You are using a brainExpBeta != 1; vsp default is 1.  (Different values may cause conceptual problems during paper writing.) This means you have to add the following lines to your config file: ");
            log.log(lvl, "<module name=\"planCalcScore\">");
            log.log(lvl, "\t<param name=\"BrainExpBeta\" value=\"1.0\" />");
            log.log(lvl, "</module>");
        }
        block16: for (PlanCalcScoreConfigGroup.ActivityParams activityParams : config.planCalcScore().getActivityParams()) {
            if ("pt interaction".equals(activityParams.getActivityType())) continue;
            switch (activityParams.getTypicalDurationScoreComputation()) {
                case relative: {
                    continue block16;
                }
                case uniform: {
                    log.log(lvl, "found `typicalDurationScoreComputation == uniform' for activity type " + activityParams.getActivityType() + "; vsp should use `relative'. ");
                    continue block16;
                }
            }
            throw new RuntimeException("unexpected setting; aborting ... ");
        }
        for (PlanCalcScoreConfigGroup.ModeParams modeParams : config.planCalcScore().getModes().values()) {
            if (modeParams.getMonetaryDistanceRate() > 0.0) {
                problem = true;
                System.out.flush();
                log.error("found monetary distance rate for mode " + modeParams.getMode() + " > 0.  You probably want a value < 0 here.\n");
            }
            if (!(modeParams.getMonetaryDistanceRate() < -0.01)) continue;
            System.out.flush();
            log.error("found monetary distance rate for mode " + modeParams.getMode() + " < -0.01.  -0.01 per meter means -10 per km.  You probably want to divide your value by 1000.");
        }
        if (config.planCalcScore().getModes().get("car") != null && config.planCalcScore().getModes().get("car").getMonetaryDistanceRate() > 0.0) {
            problem = true;
        }
        if ((modeParamsPt = config.planCalcScore().getModes().get("pt")) != null && modeParamsPt.getMonetaryDistanceRate() > 0.0) {
            problem = true;
            System.out.flush();
            log.error("found monetary distance cost rate pt > 0.  You probably want a value < 0 here.  This is a bug and may be changed eventually.  kai, jun'11");
        }
        if (config.planCalcScore().getMarginalUtilityOfMoney() < 0.0) {
            problem = true;
            System.out.flush();
            log.error("found marginal utility of money < 0.  You almost certainly want a value > 0 here. ");
        }
        if (config.planCalcScore().getMarginalUtlOfWaiting_utils_hr() != 0.0) {
            problem = true;
            System.out.flush();
            log.error("found marginal utility of waiting != 0.  vsp default is setting this to 0. ");
        }
        if (config.planCalcScore().getFractionOfIterationsToStartScoreMSA() == null) {
            problem = true;
            System.out.flush();
            log.log(lvl, "You are not setting fractionOfIterationsToStartScoreMSA; vsp default is to set this to something like 0.8.  This means you have to add the following lines to your config file: ");
            log.log(lvl, "<module name=\"planCalcScore\">");
            log.log(lvl, "\t<param name=\"fractionOfIterationsToStartScoreMSA\" value=\"0.8\" />");
            log.log(lvl, "</module>");
        }
        if (!config.plans().isRemovingUnneccessaryPlanAttributes()) {
            problem = true;
            System.out.flush();
            log.log(lvl, "You are not removing unnecessary plan attributes; vsp default is to do that.");
        }
        if ((activityDurationInterpretation = config.plans().getActivityDurationInterpretation()) == PlansConfigGroup.ActivityDurationInterpretation.endTimeOnly) {
            log.log(lvl, (Object)((Object)PlansConfigGroup.ActivityDurationInterpretation.endTimeOnly) + " is deprecated. Use " + (Object)((Object)PlansConfigGroup.ActivityDurationInterpretation.tryEndTimeThenDuration) + " instead.");
            problem = true;
            if (config.transit().isUseTransit()) {
                problem = true;
                System.out.flush();
                log.error("You are using " + (Object)((Object)config.plans().getActivityDurationInterpretation()) + " as activityDurationInterpretation in " + "conjunction with the matsim transit module. This is not working at all as pt interaction activities never have an end time and " + "thus will never end!");
            }
        }
        if (activityDurationInterpretation == PlansConfigGroup.ActivityDurationInterpretation.minOfDurationAndEndTime) {
            problem = true;
            System.out.flush();
            log.log(lvl, "You are using ActivityDurationInterpretation " + (Object)((Object)config.plans().getActivityDurationInterpretation()) + " ; vsp default is to use " + (Object)((Object)PlansConfigGroup.ActivityDurationInterpretation.tryEndTimeThenDuration) + "This means you have to add the following lines into the vspExperimental section of your config file: ");
            log.log(lvl, "   <param name=\"activityDurationInterpretation\" value=\"" + (Object)((Object)PlansConfigGroup.ActivityDurationInterpretation.tryEndTimeThenDuration) + "\" />");
            log.log(lvl, "Please report if this causes odd results (this will simplify many code maintenance issues, but is unfortunately not well tested).");
        }
        if (!config.plansCalcRoute().isInsertingAccessEgressWalk()) {
            log.log(lvl, "found `plansCalcRoute.insertingAccessEgressWalk==false'; vsp should use `true' or talk to Kai. ");
        }
        if (config.qsim().getUsePersonIdForMissingVehicleId()) {
            log.log(lvl, "found qsim.usePersonIdForMissingVehicleId==true; this is only for backwards compatibility and should rather be set to false");
        }
        if (!config.qsim().isUsingTravelTimeCheckInTeleportation()) {
            log.log(lvl, "found `qsim.usingTravelTimeCheckInTeleporation==false'; vsp should try out `true' and report.");
        }
        switch (config.qsim().getTrafficDynamics()) {
            case kinematicWaves: {
                break;
            }
            default: {
                log.log(lvl, " found 'qsim.trafficDynamics==" + (Object)((Object)config.qsim().getTrafficDynamics()) + "'; vsp standard is`" + (Object)((Object)QSimConfigGroup.TrafficDynamics.kinematicWaves) + "'.");
            }
        }
        if (config.qsim() != null && config.qsim().isRemoveStuckVehicles()) {
            problem = true;
            System.out.flush();
            log.log(lvl, "found that the qsim is removing stuck vehicles.  vsp default is setting this to false.");
        }
        boolean found = false;
        Collection<StrategyConfigGroup.StrategySettings> settingsColl = config.strategy().getStrategySettings();
        for (StrategyConfigGroup.StrategySettings strategySettings : settingsColl) {
            if (!strategySettings.getStrategyName().equalsIgnoreCase("ChangeExpBeta")) continue;
            found = true;
        }
        if (!found) {
            problem = true;
            System.out.flush();
            log.log(lvl, "You have no strategy configured that uses ChangeExpBeta. vsp default is to use ChangeExpBeta at least in one strategy.");
        }
        if (config.strategy().getFractionOfIterationsToDisableInnovation() == Double.POSITIVE_INFINITY) {
            problem = true;
            System.out.flush();
            log.log(lvl, "You have not set fractionOfIterationsToDisableInnovation; vsp default is to set this to 0.8 or similar.  Add the following config lines:");
            log.log(lvl, "<module name=\"strategy\">");
            log.log(lvl, "\t<param name=\"fractionOfIterationsToDisableInnovation\" value=\"0.8\" />");
            log.log(lvl, "</module>");
        }
        boolean usingTimeMutator = false;
        for (StrategyConfigGroup.StrategySettings strategySettings : config.strategy().getStrategySettings()) {
            if (!"TimeAllocationMutator".equals(strategySettings.getName())) continue;
            usingTimeMutator = true;
            break;
        }
        if (usingTimeMutator) {
            if (config.timeAllocationMutator().getMutationRange() < 7200.0) {
                problem = true;
                System.out.flush();
                log.log(lvl, "timeAllocationMutator mutationRange < 7200; vsp default is 7200.  This means you have to add the following lines to your config file: ");
                log.log(lvl, "<module name=\"TimeAllocationMutator\">");
                log.log(lvl, "\t<param name=\"mutationRange\" value=\"7200.0\" />");
                log.log(lvl, "</module>");
            }
            if (config.timeAllocationMutator().isAffectingDuration()) {
                System.out.flush();
                log.log(lvl, "timeAllocationMutator is affecting duration; vsp default is to not do that.  This will be more strictly enforced in the future. This means you have to add the following lines to your config file: ");
                log.log(lvl, "<module name=\"TimeAllocationMutator\">");
                log.log(lvl, "\t<param name=\"affectingDuration\" value=\"false\" />");
                log.log(lvl, "</module>");
            }
        }
        if (!config.travelTimeCalculator().getSeparateModes()) {
            System.out.flush();
            log.log(lvl, "travelTimeCalculator is not analyzing different modes separately; vsp default is to do that.  Otherwise, you are using the same travel times for, say, bike and car.");
        }
        boolean bl2 = false;
        for (StrategyConfigGroup.StrategySettings settings : config.strategy().getStrategySettings()) {
            if (!settings.getStrategyName().contains("Mode")) continue;
            bl = true;
        }
        if (config.qsim().getVehiclesSource() == QSimConfigGroup.VehiclesSource.fromVehiclesData && config.qsim().getUsePersonIdForMissingVehicleId() && bl && config.qsim().getMainModes().size() > 1) {
            problem = true;
            log.log(lvl, "You can't use more than one main (=vehicular) mode while using the agent ID as missing vehicle ID ... because in this case the person can only have one vehicle and thus cannot switch to a different vehicle type.");
        }
        if (problem && config.vspExperimental().getVspDefaultsCheckingLevel() == VspExperimentalConfigGroup.VspDefaultsCheckingLevel.abort) {
            String string = "found a situation that leads to vsp-abort.  aborting ...";
            System.out.flush();
            log.fatal(string);
            throw new RuntimeException(string);
        }
    }
}

