/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.config.groups;

import java.util.Arrays;
import java.util.Map;
import org.matsim.core.config.ReflectiveConfigGroup;
import org.matsim.core.utils.misc.StringUtils;

public class ChangeModeConfigGroup
extends ReflectiveConfigGroup {
    public static final String CONFIG_MODULE = "changeMode";
    public static final String CONFIG_PARAM_MODES = "modes";
    public static final String CONFIG_PARAM_IGNORECARAVAILABILITY = "ignoreCarAvailability";
    public static final String MODE_SWITCH_BEHAVIOR = "modeSwitchBehavior";
    private Behavior behavior = Behavior.fromSpecifiedModesToSpecifiedModes;
    private String[] modes = new String[]{"car", "pt"};
    private boolean ignoreCarAvailability = true;

    public ChangeModeConfigGroup() {
        super(CONFIG_MODULE);
    }

    public String[] getModes() {
        return this.modes;
    }

    @ReflectiveConfigGroup.StringGetter(value="modes")
    private String getModesString() {
        return ChangeModeConfigGroup.toString(this.modes);
    }

    @ReflectiveConfigGroup.StringSetter(value="modes")
    private void setModes(String value) {
        this.setModes(ChangeModeConfigGroup.toArray(value));
    }

    public void setModes(String[] modes) {
        this.modes = modes;
    }

    @ReflectiveConfigGroup.StringSetter(value="ignoreCarAvailability")
    public void setIgnoreCarAvailability(boolean value) {
        this.ignoreCarAvailability = value;
    }

    @ReflectiveConfigGroup.StringGetter(value="ignoreCarAvailability")
    public boolean getIgnoreCarAvailability() {
        return this.ignoreCarAvailability;
    }

    @ReflectiveConfigGroup.StringGetter(value="modeSwitchBehavior")
    public Behavior getBehavior() {
        return this.behavior;
    }

    @ReflectiveConfigGroup.StringSetter(value="modeSwitchBehavior")
    public void setBehavior(Behavior behavior) {
        this.behavior = behavior;
    }

    @Override
    public Map<String, String> getComments() {
        Map<String, String> comments = super.getComments();
        comments.put(CONFIG_PARAM_MODES, "Defines all the modes available, including chain-based modes, seperated by commas");
        comments.put(CONFIG_PARAM_IGNORECARAVAILABILITY, "Defines whether car availability is considered be considered or not. An agent has no car only if it has no license, or never access to a car. Default: true");
        comments.put(MODE_SWITCH_BEHAVIOR, "Defines the mode switch behavior. Possible values " + Arrays.toString((Object[])Behavior.values()) + " Default: fromSpecifiedModesToSpecifiedModes.");
        return comments;
    }

    private static String toString(String[] modes) {
        StringBuilder b = new StringBuilder();
        if (modes.length > 0) {
            b.append(modes[0]);
        }
        for (int i = 1; i < modes.length; ++i) {
            b.append(',');
            b.append(modes[i]);
        }
        return b.toString();
    }

    private static String[] toArray(String modes) {
        String[] parts = StringUtils.explode(modes, ',');
        int n = parts.length;
        for (int i = 0; i < n; ++i) {
            parts[i] = parts[i].trim().intern();
        }
        return parts;
    }

    public static enum Behavior {
        fromAllModesToSpecifiedModes,
        fromSpecifiedModesToSpecifiedModes;

    }
}

