/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.config.groups;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.matsim.core.config.Config;
import org.matsim.core.config.ReflectiveConfigGroup;
import org.matsim.core.controler.OutputDirectoryHierarchy;
import org.matsim.core.utils.io.IOUtils;
import org.matsim.core.utils.misc.StringUtils;

public final class ControlerConfigGroup
extends ReflectiveConfigGroup {
    private static final Logger log = Logger.getLogger(ControlerConfigGroup.class);
    public static final String GROUP_NAME = "controler";
    private static final String OUTPUT_DIRECTORY = "outputDirectory";
    private static final String FIRST_ITERATION = "firstIteration";
    private static final String LAST_ITERATION = "lastIteration";
    private static final String ROUTINGALGORITHM_TYPE = "routingAlgorithmType";
    private static final String RUNID = "runId";
    private static final String LINKTOLINK_ROUTING_ENABLED = "enableLinkToLinkRouting";
    static final String EVENTS_FILE_FORMAT = "eventsFileFormat";
    private static final String SNAPSHOT_FORMAT = "snapshotFormat";
    private static final String WRITE_EVENTS_INTERVAL = "writeEventsInterval";
    private static final String WRITE_PLANS_INTERVAL = "writePlansInterval";
    private static final String OVERWRITE_FILE = "overwriteFiles";
    private static final String CREATE_GRAPHS = "createGraphs";
    private static final String DUMP_DATA_AT_END = "dumpDataAtEnd";
    static final String MOBSIM = "mobsim";
    private static final String WRITE_SNAPSHOTS_INTERVAL = "writeSnapshotsInterval";
    private String outputDirectory = "./output";
    private int firstIteration = 0;
    private int lastIteration = 1000;
    private RoutingAlgorithmType routingAlgorithmType = RoutingAlgorithmType.AStarLandmarks;
    private boolean linkToLinkRoutingEnabled = false;
    private String runId = null;
    private Set<EventsFileFormat> eventsFileFormats = Collections.unmodifiableSet(EnumSet.of(EventsFileFormat.xml));
    private int writeEventsInterval = 10;
    private int writePlansInterval = 10;
    private Set<String> snapshotFormat = Collections.emptySet();
    private String mobsim = MobsimType.qsim.toString();
    private int writeSnapshotsInterval = 1;
    private boolean createGraphs = true;
    private boolean dumpDataAtEnd = true;
    private OutputDirectoryHierarchy.OverwriteFileSetting overwriteFileSetting = OutputDirectoryHierarchy.OverwriteFileSetting.failIfDirectoryExists;
    int writePlansUntilIteration = 1;
    int writeEventsUntilIteration = 0;

    public ControlerConfigGroup() {
        super(GROUP_NAME);
    }

    @Override
    public final Map<String, String> getComments() {
        Map<String, String> map = super.getComments();
        map.put(ROUTINGALGORITHM_TYPE, "The type of routing (least cost path) algorithm used, may have the values: " + (Object)((Object)RoutingAlgorithmType.Dijkstra) + ", " + (Object)((Object)RoutingAlgorithmType.FastDijkstra) + ", " + (Object)((Object)RoutingAlgorithmType.AStarLandmarks) + " or " + (Object)((Object)RoutingAlgorithmType.FastAStarLandmarks));
        map.put(RUNID, "An identifier for the current run which is used as prefix for output files and mentioned in output xml files etc.");
        map.put(EVENTS_FILE_FORMAT, "Default=" + (Object)((Object)EventsFileFormat.xml) + "; Specifies the file format for writing events. Currently supported: xml." + IOUtils.NATIVE_NEWLINE + "\t\t" + "Multiple values can be specified separated by commas (',').");
        map.put(WRITE_EVENTS_INTERVAL, "iterationNumber % writeEventsInterval == 0 defines in which iterations events are written to a file. `0' disables events writing completely.");
        map.put(WRITE_PLANS_INTERVAL, "iterationNumber % writePlansInterval == 0 defines (hopefully) in which iterations plans are written to a file. `0' disables plans writing completely.  Some plans in early iterations are always written");
        map.put(LINKTOLINK_ROUTING_ENABLED, "Default=false. If enabled, the router takes travel times needed for turning moves into account. Cannot be used if the (Fast)AStarLandmarks routing or TravelTimeCalculator.separateModes is enabled.");
        map.put(FIRST_ITERATION, "Default=0; ");
        map.put(LAST_ITERATION, "Default=1000; ");
        map.put(CREATE_GRAPHS, "Sets whether graphs showing some analyses should automatically be generated during the simulation. The generation of graphs usually takes a small amount of time that does not have any weight in big simulations, but add a significant overhead in smaller runs or in test cases where the graphical output is not even requested.");
        StringBuilder mobsimTypes = new StringBuilder();
        for (MobsimType mtype : MobsimType.values()) {
            mobsimTypes.append(mtype.toString());
            mobsimTypes.append(' ');
        }
        map.put(MOBSIM, "Defines which mobility simulation will be used. Currently supported: " + mobsimTypes + IOUtils.NATIVE_NEWLINE + "\t\t" + "Depending on the chosen mobsim, you'll have to add additional config modules to configure the corresponding mobsim." + IOUtils.NATIVE_NEWLINE + "\t\t" + "For 'qsim', add a module 'qsim' to the config.");
        map.put(SNAPSHOT_FORMAT, "Comma-separated list of visualizer output file formats. `transims', `googleearth', and `otfvis'.");
        map.put(WRITE_SNAPSHOTS_INTERVAL, "iterationNumber % writeSnapshotsInterval == 0 defines in which iterations snapshots are written to a file. `0' disables snapshots writing completely");
        map.put(DUMP_DATA_AT_END, "true if at the end of a run, plans, network, config etc should be dumped to a file");
        return map;
    }

    @ReflectiveConfigGroup.StringSetter(value="outputDirectory")
    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @ReflectiveConfigGroup.StringGetter(value="outputDirectory")
    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    @ReflectiveConfigGroup.StringSetter(value="firstIteration")
    public void setFirstIteration(int firstIteration) {
        this.firstIteration = firstIteration;
    }

    @ReflectiveConfigGroup.StringGetter(value="firstIteration")
    public int getFirstIteration() {
        return this.firstIteration;
    }

    @ReflectiveConfigGroup.StringSetter(value="lastIteration")
    public void setLastIteration(int lastIteration) {
        this.lastIteration = lastIteration;
    }

    @ReflectiveConfigGroup.StringGetter(value="lastIteration")
    public int getLastIteration() {
        return this.lastIteration;
    }

    @ReflectiveConfigGroup.StringGetter(value="routingAlgorithmType")
    public RoutingAlgorithmType getRoutingAlgorithmType() {
        return this.routingAlgorithmType;
    }

    @ReflectiveConfigGroup.StringSetter(value="routingAlgorithmType")
    public void setRoutingAlgorithmType(RoutingAlgorithmType type) {
        this.routingAlgorithmType = type;
    }

    @ReflectiveConfigGroup.StringGetter(value="runId")
    public String getRunId() {
        return this.runId;
    }

    @ReflectiveConfigGroup.StringSetter(value="runId")
    public void setRunId(String runid) {
        if (runid == null) {
            this.runId = null;
        } else if (runid.equals("")) {
            log.info("No run Id provided. Setting run Id to null.");
            this.runId = null;
        } else {
            this.runId = runid;
        }
    }

    @ReflectiveConfigGroup.StringGetter(value="enableLinkToLinkRouting")
    public boolean isLinkToLinkRoutingEnabled() {
        return this.linkToLinkRoutingEnabled;
    }

    @ReflectiveConfigGroup.StringSetter(value="enableLinkToLinkRouting")
    public void setLinkToLinkRoutingEnabled(boolean enabled) {
        this.linkToLinkRoutingEnabled = enabled;
    }

    @ReflectiveConfigGroup.StringGetter(value="eventsFileFormat")
    private String getEventsFileFormatAsString() {
        boolean isFirst = true;
        StringBuilder str = new StringBuilder();
        for (EventsFileFormat format : this.eventsFileFormats) {
            if (!isFirst) {
                str.append(',');
            }
            str.append(format.toString());
            isFirst = false;
        }
        return str.toString();
    }

    @ReflectiveConfigGroup.StringSetter(value="eventsFileFormat")
    private void setEventFileFormats(String value) {
        String[] parts = StringUtils.explode(value, ',');
        EnumSet<EventsFileFormat> formats = EnumSet.noneOf(EventsFileFormat.class);
        for (String part : parts) {
            String trimmed = part.trim();
            if (trimmed.length() <= 0) continue;
            formats.add(EventsFileFormat.valueOf(trimmed));
        }
        this.eventsFileFormats = formats;
    }

    public Set<EventsFileFormat> getEventsFileFormats() {
        return this.eventsFileFormats;
    }

    public void setEventsFileFormats(Set<EventsFileFormat> eventsFileFormats) {
        this.eventsFileFormats = Collections.unmodifiableSet(EnumSet.copyOf(eventsFileFormats));
    }

    @ReflectiveConfigGroup.StringSetter(value="snapshotFormat")
    private void setSnapshotFormats(String value) {
        String[] parts = StringUtils.explode(value, ',');
        HashSet<String> formats = new HashSet<String>();
        for (String part : parts) {
            String trimmed = part.trim();
            if (trimmed.length() <= 0) continue;
            formats.add(trimmed);
        }
        this.snapshotFormat = formats;
    }

    @ReflectiveConfigGroup.StringGetter(value="snapshotFormat")
    private String getSnapshotFormatAsString() {
        boolean isFirst = true;
        StringBuilder str = new StringBuilder();
        for (String format : this.snapshotFormat) {
            if (!isFirst) {
                str.append(',');
            }
            str.append(format);
            isFirst = false;
        }
        return str.toString();
    }

    public void setSnapshotFormat(Collection<String> snapshotFormat) {
        this.snapshotFormat = Collections.unmodifiableSet(new HashSet<String>(snapshotFormat));
    }

    public Collection<String> getSnapshotFormat() {
        return this.snapshotFormat;
    }

    @ReflectiveConfigGroup.StringGetter(value="writeEventsInterval")
    public int getWriteEventsInterval() {
        return this.writeEventsInterval;
    }

    @ReflectiveConfigGroup.StringSetter(value="writeEventsInterval")
    public void setWriteEventsInterval(int writeEventsInterval) {
        this.writeEventsInterval = writeEventsInterval;
    }

    @ReflectiveConfigGroup.StringGetter(value="mobsim")
    public String getMobsim() {
        return this.mobsim;
    }

    @ReflectiveConfigGroup.StringSetter(value="mobsim")
    public void setMobsim(String mobsim) {
        this.mobsim = mobsim;
    }

    @ReflectiveConfigGroup.StringGetter(value="writePlansInterval")
    public int getWritePlansInterval() {
        return this.writePlansInterval;
    }

    @ReflectiveConfigGroup.StringSetter(value="writePlansInterval")
    public void setWritePlansInterval(int writePlansInterval) {
        this.writePlansInterval = writePlansInterval;
    }

    @ReflectiveConfigGroup.StringGetter(value="writeSnapshotsInterval")
    public int getWriteSnapshotsInterval() {
        return this.writeSnapshotsInterval;
    }

    @ReflectiveConfigGroup.StringSetter(value="writeSnapshotsInterval")
    public void setWriteSnapshotsInterval(int writeSnapshotsInterval) {
        this.writeSnapshotsInterval = writeSnapshotsInterval;
    }

    @ReflectiveConfigGroup.StringGetter(value="createGraphs")
    public boolean isCreateGraphs() {
        return this.createGraphs;
    }

    @ReflectiveConfigGroup.StringSetter(value="createGraphs")
    public void setCreateGraphs(boolean createGraphs) {
        this.createGraphs = createGraphs;
    }

    @ReflectiveConfigGroup.StringGetter(value="overwriteFiles")
    public OutputDirectoryHierarchy.OverwriteFileSetting getOverwriteFileSetting() {
        return this.overwriteFileSetting;
    }

    @ReflectiveConfigGroup.StringSetter(value="overwriteFiles")
    public void setOverwriteFileSetting(OutputDirectoryHierarchy.OverwriteFileSetting overwriteFileSetting) {
        this.overwriteFileSetting = overwriteFileSetting;
    }

    @ReflectiveConfigGroup.StringGetter(value="dumpDataAtEnd")
    public boolean getDumpDataAtEnd() {
        return this.dumpDataAtEnd;
    }

    @ReflectiveConfigGroup.StringSetter(value="dumpDataAtEnd")
    public void setDumpDataAtEnd(boolean dumpDataAtEnd) {
        this.dumpDataAtEnd = dumpDataAtEnd;
    }

    public int getWritePlansUntilIteration() {
        return this.writePlansUntilIteration;
    }

    public void setWritePlansUntilIteration(int val) {
        this.writePlansUntilIteration = val;
    }

    public int getWriteEventsUntilIteration() {
        return this.writeEventsUntilIteration;
    }

    public void setWriteEventsUntilIteration(int val) {
        this.writeEventsUntilIteration = val;
    }

    @Override
    protected void checkConsistency(Config config) {
        if (config.controler().getOverwriteFileSetting() == OutputDirectoryHierarchy.OverwriteFileSetting.overwriteExistingFiles) {
            log.warn("setting overwriting behavior to " + (Object)((Object)this.overwriteFileSetting));
            log.warn("this is not recommended, as it might result in a directory containing output from several model runs");
            log.warn("prefer the options " + (Object)((Object)OutputDirectoryHierarchy.OverwriteFileSetting.deleteDirectoryIfExists) + " or " + (Object)((Object)OutputDirectoryHierarchy.OverwriteFileSetting.failIfDirectoryExists));
        }
    }

    public static enum MobsimType {
        qsim,
        JDEQSim;

    }

    public static enum EventsFileFormat {
        xml;

    }

    public static enum RoutingAlgorithmType {
        Dijkstra,
        AStarLandmarks,
        FastDijkstra,
        FastAStarLandmarks;

    }
}

