/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.config.groups;

import java.net.URL;
import java.util.Locale;
import java.util.Map;
import org.matsim.core.config.ConfigGroup;
import org.matsim.core.config.ReflectiveConfigGroup;

public final class CountsConfigGroup
extends ReflectiveConfigGroup {
    public static final String GROUP_NAME = "counts";
    private static final String OUTPUTFORMAT = "outputformat";
    private static final String DISTANCEFILTER = "distanceFilter";
    private static final String DISTANCEFILTERCENTERNODE = "distanceFilterCenterNode";
    private static final String COUNTSINPUTFILENAME = "inputCountsFile";
    private static final String COUNTSSCALEFACTOR = "countsScaleFactor";
    private static final String WRITECOUNTSINTERVAL = "writeCountsInterval";
    private static final String AVERAGECOUNTSOVERITERATIONS = "averageCountsOverIterations";
    private static final String ANALYZEDMODES = "analyzedModes";
    private static final String FILTERMODES = "filterModes";
    private static final String INPUT_CRS = "inputCRS";
    private String outputFormat = "txt";
    private Double distanceFilter;
    private String distanceFilterCenterNode;
    private String inputFile = null;
    private double countsScaleFactor = 1.0;
    private int writeCountsInterval = 10;
    private int averageCountsOverIterations = 5;
    private String analyzedModes = "car";
    private boolean filterModes = false;
    private String inputCRS = null;
    public static final String COUNTS_OUTPUTFORMAT_COMMENT = "possible values: `html', `kml', `txt', `all'";
    public static final String COUNTS_DISTANCEFILTER_COMMENT = "distance to distanceFilterCenterNode to include counting stations. The unit of distance is the Euclidean distance implied by the coordinate system";
    public static final String COUNTS_DISTANCEFILTERCENTERNODE_COMMENT = "node id for center node of distance filter";
    public static final String COUNTSINPUTFILENAME_COMMENT = "input file name to counts package";
    public static final String COUNTSSCALEFACTOR_COMMENT = "factor by which to re-scale the simulated values.  necessary when simulation runs with something different from 100%.  needs to be adapted manually";

    public CountsConfigGroup() {
        super(GROUP_NAME);
    }

    @Override
    public Map<String, String> getComments() {
        Map<String, String> comments = super.getComments();
        comments.put(OUTPUTFORMAT, COUNTS_OUTPUTFORMAT_COMMENT);
        comments.put(DISTANCEFILTER, COUNTS_DISTANCEFILTER_COMMENT);
        comments.put(DISTANCEFILTERCENTERNODE, COUNTS_DISTANCEFILTERCENTERNODE_COMMENT);
        comments.put(COUNTSINPUTFILENAME, COUNTSINPUTFILENAME_COMMENT);
        comments.put(COUNTSSCALEFACTOR, COUNTSSCALEFACTOR_COMMENT);
        comments.put(WRITECOUNTSINTERVAL, "Specifies how often the counts comparison should be calculated and written.");
        comments.put(AVERAGECOUNTSOVERITERATIONS, "Specifies over how many iterations the link volumes should be averaged that are used for the counts comparison. Use 1 or 0 to only use the link volumes of a single iteration. This values cannot be larger than the value specified for writeCountsInterval");
        comments.put(ANALYZEDMODES, "Transport modes that will be respected for the counts comparison. 'car' is default, which includes also bussed from the pt simulation module. Use this parameter in combination with 'filterModes' = true!");
        comments.put(FILTERMODES, "If true, link counts from legs performed on modes not included in the 'analyzedModes' parameter are ignored.");
        comments.put(INPUT_CRS, "The Coordinates Reference System in which the coordinates are expressed in the input file. At import, the coordinates will be converted to the coordinate system defined in \"global\", and willbe converted back at export. If not specified, no conversion happens.");
        return comments;
    }

    @ReflectiveConfigGroup.StringGetter(value="outputformat")
    public String getOutputFormat() {
        return this.outputFormat;
    }

    @ReflectiveConfigGroup.StringSetter(value="outputformat")
    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    @ReflectiveConfigGroup.StringGetter(value="distanceFilter")
    public Double getDistanceFilter() {
        return this.distanceFilter;
    }

    @ReflectiveConfigGroup.StringSetter(value="distanceFilter")
    public void setDistanceFilter(Double distanceFilter) {
        this.distanceFilter = distanceFilter;
    }

    @ReflectiveConfigGroup.StringGetter(value="distanceFilterCenterNode")
    public String getDistanceFilterCenterNode() {
        return this.distanceFilterCenterNode;
    }

    @ReflectiveConfigGroup.StringSetter(value="distanceFilterCenterNode")
    public void setDistanceFilterCenterNode(String distanceFilterCenterNode) {
        this.distanceFilterCenterNode = distanceFilterCenterNode;
    }

    @ReflectiveConfigGroup.StringGetter(value="inputCountsFile")
    public String getCountsFileName() {
        return this.inputFile;
    }

    @ReflectiveConfigGroup.StringSetter(value="inputCountsFile")
    public void setInputFile(String countsFileName) {
        this.inputFile = countsFileName;
    }

    public URL getCountsFileURL(URL context) {
        return ConfigGroup.getInputFileURL(context, this.inputFile);
    }

    @ReflectiveConfigGroup.StringGetter(value="countsScaleFactor")
    public double getCountsScaleFactor() {
        return this.countsScaleFactor;
    }

    @ReflectiveConfigGroup.StringSetter(value="countsScaleFactor")
    public void setCountsScaleFactor(double countsScaleFactor) {
        this.countsScaleFactor = countsScaleFactor;
    }

    @ReflectiveConfigGroup.StringGetter(value="writeCountsInterval")
    public int getWriteCountsInterval() {
        return this.writeCountsInterval;
    }

    @ReflectiveConfigGroup.StringSetter(value="writeCountsInterval")
    public void setWriteCountsInterval(int writeCountsInterval) {
        this.writeCountsInterval = writeCountsInterval;
    }

    @ReflectiveConfigGroup.StringGetter(value="averageCountsOverIterations")
    public int getAverageCountsOverIterations() {
        return this.averageCountsOverIterations;
    }

    @ReflectiveConfigGroup.StringSetter(value="averageCountsOverIterations")
    public void setAverageCountsOverIterations(int averageCountsOverIterations) {
        this.averageCountsOverIterations = averageCountsOverIterations;
    }

    @ReflectiveConfigGroup.StringGetter(value="filterModes")
    public boolean isFilterModes() {
        return this.filterModes;
    }

    @ReflectiveConfigGroup.StringSetter(value="filterModes")
    public void setFilterModes(boolean filterModes) {
        this.filterModes = filterModes;
    }

    @ReflectiveConfigGroup.StringGetter(value="analyzedModes")
    public String getAnalyzedModes() {
        return this.analyzedModes;
    }

    @ReflectiveConfigGroup.StringSetter(value="analyzedModes")
    public void setAnalyzedModes(String analyzedModes) {
        this.analyzedModes = analyzedModes.toLowerCase(Locale.ROOT);
    }

    @ReflectiveConfigGroup.StringGetter(value="inputCRS")
    public String getInputCRS() {
        return this.inputCRS;
    }

    @ReflectiveConfigGroup.StringSetter(value="inputCRS")
    public void setInputCRS(String inputCRS) {
        this.inputCRS = inputCRS;
    }
}

