/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.config.groups;

import java.util.Map;
import org.apache.log4j.Logger;
import org.matsim.core.config.ReflectiveConfigGroup;
import org.matsim.core.utils.misc.Time;

public final class ExternalMobimConfigGroup
extends ReflectiveConfigGroup {
    private static final Logger log = Logger.getLogger(ExternalMobimConfigGroup.class);
    public static final String GROUP_NAME = "externalMobsim";
    private static final String START_TIME = "startTime";
    private static final String END_TIME = "endTime";
    private static final String EXTERNAL_EXE = "externalExe";
    private static final String TIMEOUT = "timeout";
    private double startTime = Time.getUndefinedTime();
    private double endTime = Time.getUndefinedTime();
    private String externalExe = null;
    private int timeOut = 3600;

    public ExternalMobimConfigGroup() {
        super(GROUP_NAME);
    }

    @Override
    public final Map<String, String> getComments() {
        Map<String, String> map = super.getComments();
        return map;
    }

    @ReflectiveConfigGroup.StringSetter(value="startTime")
    public void setStartTime(String startTime) {
        this.setStartTime(Time.parseTime(startTime));
    }

    public void setStartTime(double startTime) {
        this.startTime = startTime;
    }

    @ReflectiveConfigGroup.StringGetter(value="startTime")
    String getStartTimeAsString() {
        return Time.writeTime(this.startTime);
    }

    public double getStartTime() {
        return this.startTime;
    }

    @ReflectiveConfigGroup.StringSetter(value="endTime")
    public void setEndTime(String startTime) {
        this.setEndTime(Time.parseTime(startTime));
    }

    public void setEndTime(double endTime) {
        this.endTime = endTime;
    }

    @ReflectiveConfigGroup.StringGetter(value="endTime")
    String getEndTimeAsString() {
        return Time.writeTime(this.endTime);
    }

    public double getEndTime() {
        return this.endTime;
    }

    @ReflectiveConfigGroup.StringSetter(value="externalExe")
    public void setExternalExe(String externalExe) {
        this.externalExe = externalExe;
    }

    @ReflectiveConfigGroup.StringGetter(value="externalExe")
    public String getExternalExe() {
        return this.externalExe;
    }

    @ReflectiveConfigGroup.StringSetter(value="timeout")
    public void setExternalTimeOut(int timeOut) {
        this.timeOut = timeOut;
    }

    @ReflectiveConfigGroup.StringGetter(value="timeout")
    public int getExternalTimeOut() {
        return this.timeOut;
    }
}

