/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.config.groups;

import java.net.URL;
import java.util.Map;
import org.matsim.core.config.ConfigGroup;
import org.matsim.core.config.ReflectiveConfigGroup;

public final class FacilitiesConfigGroup
extends ReflectiveConfigGroup {
    public static final String GROUP_NAME = "facilities";
    private static final String INPUT_FILE = "inputFacilitiesFile";
    private static final String INPUT_FACILITY_ATTRIBUTES_FILE = "inputFacilityAttributesFile";
    private static final String INPUT_CRS = "inputCRS";
    private String inputFile = null;
    private String inputFacilitiesAttributesFile = null;
    private String inputCRS = null;
    private String idPrefix = "autogen_";
    private static final String FACILITIES_SOURCE = "facilitiesSource";
    private FacilitiesSource facilitiesSource = FacilitiesSource.none;
    private static final String ID_PREFIX = "idPrefix";

    public FacilitiesConfigGroup() {
        super(GROUP_NAME);
    }

    @Override
    public Map<String, String> getComments() {
        Map<String, String> comments = super.getComments();
        comments.put(INPUT_CRS, "The Coordinates Reference System in which the coordinates are expressed in the input file. At import, the coordinates will be converted to the coordinate system defined in \"global\", and willbe converted back at export. If not specified, no conversion happens.");
        StringBuilder options = new StringBuilder();
        for (FacilitiesSource source : FacilitiesSource.values()) {
            options.append((Object)source);
            options.append(' ');
        }
        comments.put(FACILITIES_SOURCE, "This defines how facilities should be created. Possible values: " + options.toString());
        comments.put(ID_PREFIX, "A prefix to be used for auto-generated IDs.");
        return comments;
    }

    @ReflectiveConfigGroup.StringGetter(value="inputFacilitiesFile")
    public String getInputFile() {
        return this.inputFile;
    }

    @ReflectiveConfigGroup.StringSetter(value="inputFacilitiesFile")
    public void setInputFile(String inputFile) {
        this.inputFile = inputFile;
    }

    public URL getInputFileURL(URL context) {
        return ConfigGroup.getInputFileURL(context, this.inputFile);
    }

    @ReflectiveConfigGroup.StringGetter(value="inputFacilityAttributesFile")
    @Deprecated
    public String getInputFacilitiesAttributesFile() {
        return this.inputFacilitiesAttributesFile;
    }

    @ReflectiveConfigGroup.StringSetter(value="inputFacilityAttributesFile")
    @Deprecated
    public void setInputFacilitiesAttributesFile(String inputFacilitiesAttributesFile) {
        this.inputFacilitiesAttributesFile = inputFacilitiesAttributesFile;
    }

    @ReflectiveConfigGroup.StringGetter(value="inputCRS")
    public String getInputCRS() {
        return this.inputCRS;
    }

    @ReflectiveConfigGroup.StringSetter(value="inputCRS")
    public void setInputCRS(String inputCRS) {
        this.inputCRS = inputCRS;
    }

    @ReflectiveConfigGroup.StringGetter(value="idPrefix")
    public String getIdPrefix() {
        return this.idPrefix;
    }

    @ReflectiveConfigGroup.StringSetter(value="idPrefix")
    public void setIdPrefix(String idPrefix) {
        this.idPrefix = idPrefix;
    }

    @ReflectiveConfigGroup.StringGetter(value="facilitiesSource")
    public FacilitiesSource getFacilitiesSource() {
        return this.facilitiesSource;
    }

    @ReflectiveConfigGroup.StringSetter(value="facilitiesSource")
    public void setFacilitiesSource(FacilitiesSource facilitiesSource) {
        this.facilitiesSource = facilitiesSource;
    }

    public static enum FacilitiesSource {
        none,
        fromFile,
        setInScenario,
        onePerActivityLinkInPlansFile,
        onePerActivityLocationInPlansFile;

    }
}

