/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.config.groups;

import java.util.Map;
import javax.validation.constraints.PositiveOrZero;
import org.apache.log4j.Logger;
import org.matsim.core.config.ReflectiveConfigGroup;

public final class GlobalConfigGroup
extends ReflectiveConfigGroup {
    private static final Logger log = Logger.getLogger(GlobalConfigGroup.class);
    public static final String GROUP_NAME = "global";
    private boolean insistingOnDeprecatedConfigVersion = true;
    private static final String RANDOM_SEED = "randomSeed";
    private static final String NUMBER_OF_THREADS = "numberOfThreads";
    private static final String COORDINATE_SYSTEM = "coordinateSystem";
    private long randomSeed = 4711L;
    @PositiveOrZero
    private int numberOfThreads = 2;
    private String coordinateSystem = "Atlantis";
    private static final String INSITING_ON_DEPRECATED_CONFIG_VERSION = "insistingOnDeprecatedConfigVersion";

    public GlobalConfigGroup() {
        super(GROUP_NAME);
    }

    @Override
    public Map<String, String> getComments() {
        Map<String, String> map = super.getComments();
        map.put(NUMBER_OF_THREADS, "\"global\" number of threads.  This number is used, e.g., for replanning, but NOT in the mobsim.  This can typically be set to as many cores as you have available, or possibly even slightly more.");
        return map;
    }

    @ReflectiveConfigGroup.StringGetter(value="randomSeed")
    public long getRandomSeed() {
        return this.randomSeed;
    }

    @ReflectiveConfigGroup.StringSetter(value="randomSeed")
    public void setRandomSeed(long randomSeed) {
        this.randomSeed = randomSeed;
    }

    @ReflectiveConfigGroup.StringGetter(value="numberOfThreads")
    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    @ReflectiveConfigGroup.StringSetter(value="numberOfThreads")
    public void setNumberOfThreads(int numberOfThreads) {
        log.info("setting number of threads to: " + numberOfThreads);
        this.numberOfThreads = numberOfThreads;
    }

    @ReflectiveConfigGroup.StringGetter(value="coordinateSystem")
    public String getCoordinateSystem() {
        return this.coordinateSystem;
    }

    @ReflectiveConfigGroup.StringSetter(value="coordinateSystem")
    public void setCoordinateSystem(String coordinateSystem) {
        this.coordinateSystem = coordinateSystem;
    }

    @ReflectiveConfigGroup.StringGetter(value="insistingOnDeprecatedConfigVersion")
    public final boolean isInsistingOnDeprecatedConfigVersion() {
        return this.insistingOnDeprecatedConfigVersion;
    }

    @ReflectiveConfigGroup.StringSetter(value="insistingOnDeprecatedConfigVersion")
    public final void setInsistingOnDeprecatedConfigVersion(boolean val) {
        this.insistingOnDeprecatedConfigVersion = val;
    }
}

