/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.config.groups;

import java.net.URL;
import java.util.Map;
import org.matsim.core.config.ConfigGroup;
import org.matsim.core.config.ReflectiveConfigGroup;

public final class NetworkConfigGroup
extends ReflectiveConfigGroup {
    public static final String GROUP_NAME = "network";
    private static final String INPUT_FILE = "inputNetworkFile";
    private static final String TIME_VARIANT_NETWORK = "timeVariantNetwork";
    private static final String CHANGE_EVENTS_INPUT_FILE = "inputChangeEventsFile";
    private static final String LANEDEFINITIONSINPUTFILE = "laneDefinitionsFile";
    private static final String INPUT_CRS = "inputCRS";
    private String inputFile = null;
    private String inputCRS = null;
    private String changeEventsInputFile = null;
    private boolean timeVariantNetwork = false;
    private String laneDefinitionsFile = null;

    public NetworkConfigGroup() {
        super(GROUP_NAME);
    }

    @Override
    public Map<String, String> getComments() {
        Map<String, String> comments = super.getComments();
        comments.put(INPUT_CRS, "The Coordinates Reference System in which the coordinates are expressed in the input file. At import, the coordinates will be converted to the coordinate system defined in \"global\", and willbe converted back at export. If not specified, no conversion happens.");
        return comments;
    }

    @ReflectiveConfigGroup.StringGetter(value="inputNetworkFile")
    public String getInputFile() {
        return this.inputFile;
    }

    @ReflectiveConfigGroup.StringSetter(value="inputNetworkFile")
    public void setInputFile(String inputFile) {
        this.inputFile = inputFile;
    }

    public URL getInputFileURL(URL context) {
        return ConfigGroup.getInputFileURL(context, this.inputFile);
    }

    @ReflectiveConfigGroup.StringSetter(value="inputChangeEventsFile")
    public void setChangeEventsInputFile(String changeEventsInputFile) {
        this.changeEventsInputFile = changeEventsInputFile;
    }

    @ReflectiveConfigGroup.StringGetter(value="inputChangeEventsFile")
    public String getChangeEventsInputFile() {
        return this.changeEventsInputFile;
    }

    public URL getChangeEventsInputFileUrl(URL context) {
        return ConfigGroup.getInputFileURL(context, this.changeEventsInputFile);
    }

    @ReflectiveConfigGroup.StringSetter(value="timeVariantNetwork")
    public void setTimeVariantNetwork(boolean timeVariantNetwork) {
        this.testForLocked();
        this.timeVariantNetwork = timeVariantNetwork;
    }

    @ReflectiveConfigGroup.StringGetter(value="timeVariantNetwork")
    public boolean isTimeVariantNetwork() {
        return this.timeVariantNetwork;
    }

    @ReflectiveConfigGroup.StringSetter(value="laneDefinitionsFile")
    public void setLaneDefinitionsFile(String laneDefinitions) {
        this.laneDefinitionsFile = laneDefinitions;
    }

    @ReflectiveConfigGroup.StringGetter(value="laneDefinitionsFile")
    public String getLaneDefinitionsFile() {
        return this.laneDefinitionsFile;
    }

    @ReflectiveConfigGroup.StringGetter(value="inputCRS")
    public String getInputCRS() {
        return this.inputCRS;
    }

    @ReflectiveConfigGroup.StringSetter(value="inputCRS")
    public void setInputCRS(String inputCRS) {
        this.inputCRS = inputCRS;
    }
}

