/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.config.groups;

import java.util.Map;
import org.matsim.core.config.ReflectiveConfigGroup;

public final class ParallelEventHandlingConfigGroup
extends ReflectiveConfigGroup {
    public static final String GROUP_NAME = "parallelEventHandling";
    private static final String NUMBER_OF_THREADS = "numberOfThreads";
    private Integer numberOfThreads = null;
    public static final String NUMBER_OF_THREADS_COMMENT = "Number of threads for parallel events handler. _null_ means the framework decides by itself. 0 is currently not possible.";
    private static final String ESTIMATED_NUMBER_OF_EVENTS = "estimatedNumberOfEvents";
    private Long estimatedNumberOfEvents = null;
    private static final String SYNCHRONIZE_ON_SIMSTEPS = "synchronizeOnSimSteps";
    private Boolean synchronizeOnSimSteps = true;
    private static final String ONE_THREAD_PER_HANDLER = "oneThreadPerHandler";
    private Boolean oneThreadPerHandler = false;
    private boolean locked = false;

    public ParallelEventHandlingConfigGroup() {
        super(GROUP_NAME);
    }

    @Override
    public Map<String, String> getComments() {
        Map<String, String> comments = super.getComments();
        comments.put(NUMBER_OF_THREADS, NUMBER_OF_THREADS_COMMENT);
        comments.put(ESTIMATED_NUMBER_OF_EVENTS, "Estimated number of events during mobsim run. An optional optimization hint for the framework.");
        comments.put(SYNCHRONIZE_ON_SIMSTEPS, "If enabled, it is ensured that all events that are created during a time step of the mobility simulation are processed before the next time step is simulated. E.g. neccessary when within-day replanning is used.");
        comments.put(ONE_THREAD_PER_HANDLER, "If enabled, each event handler is assigned to its own thread. Note that enabling this feature disabled the numberOfThreads option! This feature is still experimental!");
        return comments;
    }

    @ReflectiveConfigGroup.StringGetter(value="numberOfThreads")
    public Integer getNumberOfThreads() {
        return this.numberOfThreads;
    }

    @ReflectiveConfigGroup.StringSetter(value="numberOfThreads")
    public void setNumberOfThreads(Integer numberOfThreads) {
        if (this.locked) {
            throw new RuntimeException("it is too late in the control flow to modify this parameter");
        }
        this.numberOfThreads = numberOfThreads;
    }

    @ReflectiveConfigGroup.StringGetter(value="estimatedNumberOfEvents")
    public Long getEstimatedNumberOfEvents() {
        return this.estimatedNumberOfEvents;
    }

    @ReflectiveConfigGroup.StringSetter(value="estimatedNumberOfEvents")
    public void setEstimatedNumberOfEvents(Long estimatedNumberOfEvents) {
        if (this.locked) {
            throw new RuntimeException("it is too late in the control flow to modify this parameter");
        }
        this.estimatedNumberOfEvents = estimatedNumberOfEvents;
    }

    @ReflectiveConfigGroup.StringGetter(value="synchronizeOnSimSteps")
    public Boolean getSynchronizeOnSimSteps() {
        return this.synchronizeOnSimSteps;
    }

    @ReflectiveConfigGroup.StringSetter(value="synchronizeOnSimSteps")
    public void setSynchronizeOnSimSteps(Boolean synchronizeOnSimSteps) {
        if (this.locked) {
            throw new RuntimeException("it is too late in the control flow to modify this parameter");
        }
        this.synchronizeOnSimSteps = synchronizeOnSimSteps;
    }

    @ReflectiveConfigGroup.StringGetter(value="oneThreadPerHandler")
    public Boolean getOneThreadPerHandler() {
        return this.oneThreadPerHandler;
    }

    @ReflectiveConfigGroup.StringSetter(value="oneThreadPerHandler")
    public void setOneThreadPerHandler(Boolean oneThreadPerHandler) {
        if (this.locked) {
            throw new RuntimeException("it is too late in the control flow to modify this parameter");
        }
        this.oneThreadPerHandler = oneThreadPerHandler;
    }

    public void makeLocked() {
        this.locked = true;
    }
}

