/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.config.groups;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.matsim.core.api.internal.MatsimParameters;
import org.matsim.core.config.Config;
import org.matsim.core.config.ConfigGroup;
import org.matsim.core.config.ReflectiveConfigGroup;
import org.matsim.core.utils.misc.Time;

public final class PlanCalcScoreConfigGroup
extends ConfigGroup {
    private static final Logger log = Logger.getLogger(PlanCalcScoreConfigGroup.class);
    public static final String GROUP_NAME = "planCalcScore";
    private static final String LEARNING_RATE = "learningRate";
    private static final String BRAIN_EXP_BETA = "BrainExpBeta";
    private static final String PATH_SIZE_LOGIT_BETA = "PathSizeLogitBeta";
    private static final String LATE_ARRIVAL = "lateArrival";
    private static final String EARLY_DEPARTURE = "earlyDeparture";
    private static final String PERFORMING = "performing";
    private static final String WAITING = "waiting";
    private static final String WAITING_PT = "waitingPt";
    private static final String WRITE_EXPERIENCED_PLANS = "writeExperiencedPlans";
    private static final String MARGINAL_UTL_OF_MONEY = "marginalUtilityOfMoney";
    private static final String UTL_OF_LINE_SWITCH = "utilityOfLineSwitch";
    private final ReflectiveDelegate delegate = new ReflectiveDelegate();
    private boolean usesDeprecatedSyntax = false;
    private static final String USING_OLD_SCORING_BELOW_ZERO_UTILITY_DURATION = "usingOldScoringBelowZeroUtilityDuration";
    private boolean memorizingExperiencedPlans = false;
    public static final String EXPERIENCED_PLAN_KEY = "experiencedPlan";
    public static final String DEFAULT_SUBPOPULATION = "default";
    private static final String FRACTION_OF_ITERATIONS_TO_START_SCORE_MSA = "fractionOfIterationsToStartScoreMSA";
    private static final String msg = " is deprecated config syntax; please use the more modern hierarchical format; your output_config.xml will be in the correct version; the old version will fail eventually, since we want to reduce the workload on this backwards compatibility (look into PlanCalcScoreConfigGroup or PlanCalcRouteConfigGroup if you want to know what we mean).";
    private final Map<String, ActivityParams> activityTypesByNumber = new HashMap<String, ActivityParams>();

    public PlanCalcScoreConfigGroup() {
        super(GROUP_NAME);
        this.addScoringParameters(new ScoringParameterSet());
        this.addModeParams(new ModeParams("car"));
        this.addModeParams(new ModeParams("pt"));
        this.addModeParams(new ModeParams("walk"));
        this.addModeParams(new ModeParams("bike"));
        this.addModeParams(new ModeParams("ride"));
        this.addModeParams(new ModeParams("other"));
        ActivityParams params = new ActivityParams("dummy");
        params.setTypicalDuration(7200.0);
        this.addActivityParams(params);
        params = new ActivityParams(PlanCalcScoreConfigGroup.createStageActivityType("car"));
        params.setScoringThisActivityAtAll(false);
        this.addActivityParams(params);
        params = new ActivityParams(PlanCalcScoreConfigGroup.createStageActivityType("pt"));
        params.setScoringThisActivityAtAll(false);
        this.addActivityParams(params);
        params = new ActivityParams(PlanCalcScoreConfigGroup.createStageActivityType("bike"));
        params.setScoringThisActivityAtAll(false);
        this.addActivityParams(params);
        params = new ActivityParams(PlanCalcScoreConfigGroup.createStageActivityType("drt"));
        params.setScoringThisActivityAtAll(false);
        this.addActivityParams(params);
        params = new ActivityParams(PlanCalcScoreConfigGroup.createStageActivityType("taxi"));
        params.setScoringThisActivityAtAll(false);
        this.addActivityParams(params);
        params = new ActivityParams(PlanCalcScoreConfigGroup.createStageActivityType("other"));
        params.setScoringThisActivityAtAll(false);
        this.addActivityParams(params);
        params = new ActivityParams(PlanCalcScoreConfigGroup.createStageActivityType("walk"));
        params.setScoringThisActivityAtAll(false);
        this.addActivityParams(params);
    }

    public static String createStageActivityType(String mode) {
        return mode + " interaction";
    }

    @Override
    public String getValue(String key) {
        throw new IllegalArgumentException(key + ": getValue access disabled; use direct getter");
    }

    @Override
    public void addParam(String key, String value) {
        if (key.startsWith("monetaryDistanceCostRate")) {
            throw new RuntimeException("Please use monetaryDistanceRate (without `cost').  Even better, use config v2, mode-parameters (see output of any recent run), and mode-specific monetary distance rate.");
        }
        if (WAITING_PT.equals(key)) {
            this.setMarginalUtlOfWaitingPt_utils_hr(Double.parseDouble(value));
        } else if (key.startsWith("activityType_")) {
            log.warn(key + msg);
            this.usesDeprecatedSyntax = true;
            ActivityParams actParams = this.getActivityTypeByNumber(key.substring("activityType_".length()));
            actParams.setActivityType(value);
            this.getScoringParameters(null).removeParameterSet(actParams);
            this.addActivityParams(actParams);
        } else if (key.startsWith("activityPriority_")) {
            log.warn(key + msg);
            this.usesDeprecatedSyntax = true;
            ActivityParams actParams = this.getActivityTypeByNumber(key.substring("activityPriority_".length()));
            actParams.setPriority(Double.parseDouble(value));
        } else if (key.startsWith("activityTypicalDuration_")) {
            log.warn(key + msg);
            this.usesDeprecatedSyntax = true;
            ActivityParams actParams = this.getActivityTypeByNumber(key.substring("activityTypicalDuration_".length()));
            actParams.setTypicalDuration(Time.parseTime(value));
        } else if (key.startsWith("activityMinimalDuration_")) {
            log.warn(key + msg);
            this.usesDeprecatedSyntax = true;
            ActivityParams actParams = this.getActivityTypeByNumber(key.substring("activityMinimalDuration_".length()));
            actParams.setMinimalDuration(Time.parseTime(value));
        } else if (key.startsWith("activityOpeningTime_")) {
            log.warn(key + msg);
            this.usesDeprecatedSyntax = true;
            ActivityParams actParams = this.getActivityTypeByNumber(key.substring("activityOpeningTime_".length()));
            actParams.setOpeningTime(Time.parseTime(value));
        } else if (key.startsWith("activityLatestStartTime_")) {
            log.warn(key + msg);
            this.usesDeprecatedSyntax = true;
            ActivityParams actParams = this.getActivityTypeByNumber(key.substring("activityLatestStartTime_".length()));
            actParams.setLatestStartTime(Time.parseTime(value));
        } else if (key.startsWith("activityEarliestEndTime_")) {
            log.warn(key + msg);
            this.usesDeprecatedSyntax = true;
            ActivityParams actParams = this.getActivityTypeByNumber(key.substring("activityEarliestEndTime_".length()));
            actParams.setEarliestEndTime(Time.parseTime(value));
        } else if (key.startsWith("activityClosingTime_")) {
            log.warn(key + msg);
            this.usesDeprecatedSyntax = true;
            ActivityParams actParams = this.getActivityTypeByNumber(key.substring("activityClosingTime_".length()));
            actParams.setClosingTime(Time.parseTime(value));
        } else if (key.startsWith("scoringThisActivityAtAll_")) {
            log.warn(key + msg);
            this.usesDeprecatedSyntax = true;
            ActivityParams actParams = this.getActivityTypeByNumber(key.substring("scoringThisActivityAtAll_".length()));
            actParams.setScoringThisActivityAtAll(Boolean.parseBoolean(value));
        } else if (key.startsWith("traveling_")) {
            log.warn(key + msg);
            this.usesDeprecatedSyntax = true;
            ModeParams modeParams = this.getOrCreateModeParams(key.substring("traveling_".length()));
            modeParams.setMarginalUtilityOfTraveling(Double.parseDouble(value));
        } else if (key.startsWith("marginalUtlOfDistance_")) {
            log.warn(key + msg);
            this.usesDeprecatedSyntax = true;
            ModeParams modeParams = this.getOrCreateModeParams(key.substring("marginalUtlOfDistance_".length()));
            modeParams.setMarginalUtilityOfDistance(Double.parseDouble(value));
        } else if (key.startsWith("monetaryDistanceRate_")) {
            log.warn(key + msg);
            this.usesDeprecatedSyntax = true;
            ModeParams modeParams = this.getOrCreateModeParams(key.substring("monetaryDistanceRate_".length()));
            modeParams.setMonetaryDistanceRate(Double.parseDouble(value));
        } else if ("monetaryDistanceRateCar".equals(key)) {
            log.warn(key + msg);
            this.usesDeprecatedSyntax = true;
            ModeParams modeParams = this.getOrCreateModeParams("car");
            modeParams.setMonetaryDistanceRate(Double.parseDouble(value));
        } else if ("monetaryDistanceRatePt".equals(key)) {
            log.warn(key + msg);
            this.usesDeprecatedSyntax = true;
            ModeParams modeParams = this.getOrCreateModeParams("pt");
            modeParams.setMonetaryDistanceRate(Double.parseDouble(value));
        } else if (key.startsWith("constant_")) {
            log.warn(key + msg);
            this.usesDeprecatedSyntax = true;
            ModeParams modeParams = this.getOrCreateModeParams(key.substring("constant_".length()));
            modeParams.setConstant(Double.parseDouble(value));
        } else if ("traveling".equals(key)) {
            log.warn(key + msg);
            this.usesDeprecatedSyntax = true;
            this.getModes().get("car").setMarginalUtilityOfTraveling(Double.parseDouble(value));
        } else if ("travelingPt".equals(key)) {
            log.warn(key + msg);
            this.usesDeprecatedSyntax = true;
            this.getModes().get("pt").setMarginalUtilityOfTraveling(Double.parseDouble(value));
        } else if ("travelingWalk".equals(key)) {
            log.warn(key + msg);
            this.usesDeprecatedSyntax = true;
            this.getModes().get("walk").setMarginalUtilityOfTraveling(Double.parseDouble(value));
        } else if ("travelingOther".equals(key)) {
            log.warn(key + msg);
            this.usesDeprecatedSyntax = true;
            this.getModes().get("other").setMarginalUtilityOfTraveling(Double.parseDouble(value));
        } else if ("travelingBike".equals(key)) {
            log.warn(key + msg);
            this.usesDeprecatedSyntax = true;
            this.getModes().get("bike").setMarginalUtilityOfTraveling(Double.parseDouble(value));
        } else if ("marginalUtlOfDistanceCar".equals(key)) {
            log.warn(key + msg);
            this.usesDeprecatedSyntax = true;
            this.getModes().get("car").setMarginalUtilityOfDistance(Double.parseDouble(value));
        } else if ("marginalUtlOfDistancePt".equals(key)) {
            log.warn(key + msg);
            this.usesDeprecatedSyntax = true;
            this.getModes().get("pt").setMarginalUtilityOfDistance(Double.parseDouble(value));
        } else if ("marginalUtlOfDistanceWalk".equals(key)) {
            log.warn(key + msg);
            this.usesDeprecatedSyntax = true;
            this.getModes().get("walk").setMarginalUtilityOfDistance(Double.parseDouble(value));
        } else if ("marginalUtlOfDistanceOther".equals(key)) {
            log.warn(key + msg);
            this.usesDeprecatedSyntax = true;
            this.getModes().get("other").setMarginalUtilityOfDistance(Double.parseDouble(value));
        } else if ("constantCar".equals(key)) {
            log.warn(key + msg);
            this.usesDeprecatedSyntax = true;
            this.getModes().get("car").setConstant(Double.parseDouble(value));
        } else if ("constantWalk".equals(key)) {
            log.warn(key + msg);
            this.usesDeprecatedSyntax = true;
            this.getModes().get("walk").setConstant(Double.parseDouble(value));
        } else if ("constantOther".equals(key)) {
            log.warn(key + msg);
            this.usesDeprecatedSyntax = true;
            this.getModes().get("other").setConstant(Double.parseDouble(value));
        } else if ("constantPt".equals(key)) {
            log.warn(key + msg);
            this.usesDeprecatedSyntax = true;
            this.getModes().get("pt").setConstant(Double.parseDouble(value));
        } else if ("constantBike".equals(key)) {
            log.warn(key + msg);
            this.usesDeprecatedSyntax = true;
            this.getModes().get("bike").setConstant(Double.parseDouble(value));
        } else if (Arrays.asList(LATE_ARRIVAL, EARLY_DEPARTURE, PERFORMING, MARGINAL_UTL_OF_MONEY, UTL_OF_LINE_SWITCH, WAITING).contains(key)) {
            this.getScoringParameters(null).addParam(key, value);
        } else {
            this.delegate.addParam(key, value);
        }
    }

    private ActivityParams getActivityTypeByNumber(String number) {
        ActivityParams actType = this.activityTypesByNumber.get(number);
        if (actType == null) {
            actType = new ActivityParams(number);
            this.activityTypesByNumber.put(number, actType);
            this.addParameterSet(actType);
        }
        return actType;
    }

    public ModeParams getOrCreateModeParams(String modeName) {
        return this.getScoringParameters(null).getOrCreateModeParams(modeName);
    }

    @Override
    public Map<String, String> getParams() {
        return this.delegate.getParams();
    }

    @Override
    public final Map<String, String> getComments() {
        Map<String, String> map = super.getComments();
        map.put(FRACTION_OF_ITERATIONS_TO_START_SCORE_MSA, "fraction of iterations at which MSA score averaging is started. The matsim theory department suggests to use this together with switching off choice set innovation (where a similar switch exists), but it has not been tested yet.");
        map.put(USING_OLD_SCORING_BELOW_ZERO_UTILITY_DURATION, "There used to be a plateau between duration=0 and duration=zeroUtilityDuration. This caused durations to evolve to zero once they were below zeroUtilityDuration, causing problems.  Only use this switch if you need to be backwards compatible with some old results.  (changed nov'13)");
        map.put(PERFORMING, "[utils/hr] marginal utility of doing an activity.  normally positive.  also the opportunity cost of time if agent is doing nothing.  MATSim separates the resource value of time from the direct (dis)utility of travel time, see, e.g., Boerjesson and Eliasson, TR-A 59 (2014) 144-158.");
        map.put(LATE_ARRIVAL, "[utils/hr] utility for arriving late (i.e. after the latest start time).  normally negative");
        map.put(EARLY_DEPARTURE, "[utils/hr] utility for departing early (i.e. before the earliest end time).  Normally negative.  Probably implemented correctly, but not tested.");
        map.put(WAITING, "[utils/hr] additional marginal utility for waiting. normally negative. this comes on top of the opportunity cost of time.  Probably implemented correctly, but not tested.");
        map.put(WAITING_PT, "[utils/hr] additional marginal utility for waiting for a pt vehicle. normally negative. this comes on top of the opportunity cost of time. Default: if not set explicitly, it is equal to traveling_pt!!!");
        map.put(BRAIN_EXP_BETA, "logit model scale parameter. default: 1.  Has name and default value for historical reasons (see Bryan Raney's phd thesis).");
        map.put(LEARNING_RATE, "new_score = (1-learningRate)*old_score + learningRate * score_from_mobsim.  learning rates close to zero emulate score averaging, but slow down initial convergence");
        map.put(UTL_OF_LINE_SWITCH, "[utils] utility of switching a line (= transfer penalty).  Normally negative");
        map.put(MARGINAL_UTL_OF_MONEY, "[utils/unit_of_money] conversion of money (e.g. toll, distance cost) into utils. Normall positive (i.e. toll/cost/fare are processed as negative amounts of money).");
        map.put(WRITE_EXPERIENCED_PLANS, "write a plans file in each iteration directory which contains what each agent actually did, and the score it received.");
        return map;
    }

    public Collection<String> getActivityTypes() {
        if (this.getScoringParameters(null) != null) {
            return this.getScoringParameters(null).getActivityParamsPerType().keySet();
        }
        HashSet<String> activities = new HashSet<String>();
        this.getScoringParametersPerSubpopulation().values().forEach(item -> activities.addAll(item.getActivityParamsPerType().keySet()));
        return activities;
    }

    public Collection<String> getAllModes() {
        if (this.getScoringParameters(null) != null) {
            return this.getScoringParameters(null).getModes().keySet();
        }
        HashSet<String> modes = new HashSet<String>();
        this.getScoringParametersPerSubpopulation().values().forEach(item -> modes.addAll(item.getModes().keySet()));
        return modes;
    }

    public Collection<ActivityParams> getActivityParams() {
        if (this.getScoringParameters(null) != null) {
            return this.getScoringParameters(null).getActivityParams();
        }
        if (this.getScoringParameters(DEFAULT_SUBPOPULATION) != null) {
            return this.getScoringParameters(DEFAULT_SUBPOPULATION).getActivityParams();
        }
        throw new RuntimeException("Default subpopulation is not defined");
    }

    public Map<String, ModeParams> getModes() {
        if (this.getScoringParameters(null) != null) {
            return this.getScoringParameters(null).getModes();
        }
        if (this.getScoringParameters(DEFAULT_SUBPOPULATION) != null) {
            return this.getScoringParameters(DEFAULT_SUBPOPULATION).getModes();
        }
        throw new RuntimeException("Default subpopulation is not defined");
    }

    public Map<String, ScoringParameterSet> getScoringParametersPerSubpopulation() {
        Collection<? extends ConfigGroup> parameters = this.getParameterSets("scoringParameters");
        LinkedHashMap<String, ScoringParameterSet> map = new LinkedHashMap<String, ScoringParameterSet>();
        for (ScoringParameterSet scoringParameterSet : parameters) {
            if (this.isLocked()) {
                scoringParameterSet.setLocked();
            }
            map.put(scoringParameterSet.getSubpopulation(), scoringParameterSet);
        }
        return map;
    }

    public double getMarginalUtlOfWaitingPt_utils_hr() {
        if (this.getScoringParameters(null) != null) {
            return this.getScoringParameters(null).getMarginalUtlOfWaitingPt_utils_hr();
        }
        if (this.getScoringParameters(DEFAULT_SUBPOPULATION) != null) {
            return this.getScoringParameters(DEFAULT_SUBPOPULATION).getMarginalUtlOfWaitingPt_utils_hr();
        }
        throw new RuntimeException("Default subpopulation is not defined");
    }

    public void setMarginalUtlOfWaitingPt_utils_hr(double val) {
        this.getScoringParameters(null).setMarginalUtlOfWaitingPt_utils_hr(val);
    }

    public ActivityParams getActivityParams(String actType) {
        if (this.getScoringParameters(null) != null) {
            return this.getScoringParameters(null).getActivityParams(actType);
        }
        if (this.getScoringParameters(DEFAULT_SUBPOPULATION) != null) {
            return this.getScoringParameters(DEFAULT_SUBPOPULATION).getActivityParams(actType);
        }
        throw new RuntimeException("Default subpopulation is not defined");
    }

    public ScoringParameterSet getScoringParameters(String subpopulation) {
        ScoringParameterSet params = this.getScoringParametersPerSubpopulation().get(subpopulation);
        return params != null ? params : this.getScoringParametersPerSubpopulation().get(null);
    }

    public ScoringParameterSet getOrCreateScoringParameters(String subpopulation) {
        ScoringParameterSet params = this.getScoringParametersPerSubpopulation().get(subpopulation);
        if (params == null) {
            params = new ScoringParameterSet(subpopulation);
            this.addScoringParameters(params);
        }
        return params;
    }

    @Override
    public void addParameterSet(ConfigGroup set) {
        switch (set.getName()) {
            case "activityParams": {
                this.addActivityParams((ActivityParams)set);
                break;
            }
            case "modeParams": {
                this.addModeParams((ModeParams)set);
                break;
            }
            case "scoringParameters": {
                this.addScoringParameters((ScoringParameterSet)set);
                break;
            }
            default: {
                throw new IllegalArgumentException(set.getName());
            }
        }
    }

    private void addScoringParameters(ScoringParameterSet params) {
        ScoringParameterSet previous = this.getScoringParameters(params.getSubpopulation());
        if (previous != null) {
            log.info("scoring parameters for subpopulation " + previous.getSubpopulation() + " were just replaced.");
            boolean removed = this.removeParameterSet(previous);
            if (!removed) {
                throw new RuntimeException("problem replacing scoring params ");
            }
        }
        super.addParameterSet(params);
    }

    public void addModeParams(ModeParams params) {
        this.getScoringParameters(null).addModeParams(params);
    }

    public void addActivityParams(ActivityParams params) {
        this.getScoringParameters(null).addActivityParams(params);
    }

    @Override
    public ConfigGroup createParameterSet(String type) {
        switch (type) {
            case "activityParams": {
                return new ActivityParams();
            }
            case "modeParams": {
                return new ModeParams();
            }
            case "scoringParameters": {
                return new ScoringParameterSet();
            }
        }
        throw new IllegalArgumentException(type);
    }

    @Override
    protected void checkParameterSet(ConfigGroup module) {
        switch (module.getName()) {
            case "scoringParameters": {
                if (!(module instanceof ScoringParameterSet)) {
                    throw new RuntimeException("wrong class for " + module);
                }
                String s2 = ((ScoringParameterSet)module).getSubpopulation();
                if (this.getScoringParameters(s2) == null) break;
                throw new IllegalStateException("already a parameter set for subpopulation " + s2);
            }
            default: {
                throw new IllegalArgumentException(module.getName());
            }
        }
    }

    @Override
    protected final void checkConsistency(Config config) {
        super.checkConsistency(config);
        if (this.usesDeprecatedSyntax && !config.global().isInsistingOnDeprecatedConfigVersion()) {
            throw new RuntimeException(msg);
        }
        if (this.getScoringParametersPerSubpopulation().size() > 1 && !this.getScoringParametersPerSubpopulation().containsKey(DEFAULT_SUBPOPULATION)) {
            throw new RuntimeException("Using several subpopulations in planCalcScore requires defining a \"default \" subpopulation. Otherwise, crashes can be expected.");
        }
        if (config.plansCalcRoute().isInsertingAccessEgressWalk()) {
            for (ScoringParameterSet scoringParameterSet : this.getScoringParametersPerSubpopulation().values()) {
                for (String mode : config.plansCalcRoute().getNetworkModes()) {
                    String interactionActivityType = mode + " interaction";
                    ActivityParams set = scoringParameterSet.getActivityParamsPerType().get(interactionActivityType);
                    if (set != null) continue;
                    ActivityParams params = new ActivityParams();
                    params.setActivityType(interactionActivityType);
                    params.setScoringThisActivityAtAll(false);
                    scoringParameterSet.addActivityParams(params);
                }
            }
        }
        for (ActivityParams params : this.getActivityParams()) {
            if (!params.isScoringThisActivityAtAll() || !Time.isUndefinedTime(params.getTypicalDuration())) continue;
            throw new RuntimeException("In activity type=" + params.getActivityType() + ", the typical duration is undefined.  This will lead to errors that are difficult to debug, " + "so rather aborting here.");
        }
    }

    public boolean isMemorizingExperiencedPlans() {
        return this.memorizingExperiencedPlans;
    }

    public void setMemorizingExperiencedPlans(boolean memorizingExperiencedPlans) {
        this.memorizingExperiencedPlans = memorizingExperiencedPlans;
    }

    public double getLearningRate() {
        return this.delegate.getLearningRate();
    }

    public void setLearningRate(double learningRate) {
        this.delegate.setLearningRate(learningRate);
    }

    public double getBrainExpBeta() {
        return this.delegate.getBrainExpBeta();
    }

    public void setBrainExpBeta(double brainExpBeta) {
        this.delegate.setBrainExpBeta(brainExpBeta);
    }

    public double getPathSizeLogitBeta() {
        return this.delegate.getPathSizeLogitBeta();
    }

    public void setPathSizeLogitBeta(double beta) {
        this.delegate.setPathSizeLogitBeta(beta);
    }

    public double getLateArrival_utils_hr() {
        if (this.getScoringParameters(null) != null) {
            return this.getScoringParameters(null).getLateArrival_utils_hr();
        }
        if (this.getScoringParameters(DEFAULT_SUBPOPULATION) != null) {
            return this.getScoringParameters(DEFAULT_SUBPOPULATION).getLateArrival_utils_hr();
        }
        throw new RuntimeException("Default subpopulation is not defined");
    }

    public void setLateArrival_utils_hr(double lateArrival) {
        this.getScoringParameters(null).setLateArrival_utils_hr(lateArrival);
    }

    public double getEarlyDeparture_utils_hr() {
        if (this.getScoringParameters(null) != null) {
            return this.getScoringParameters(null).getEarlyDeparture_utils_hr();
        }
        if (this.getScoringParameters(DEFAULT_SUBPOPULATION) != null) {
            return this.getScoringParameters(DEFAULT_SUBPOPULATION).getEarlyDeparture_utils_hr();
        }
        throw new RuntimeException("Default subpopulation is not defined");
    }

    public void setEarlyDeparture_utils_hr(double earlyDeparture) {
        this.getScoringParameters(null).setEarlyDeparture_utils_hr(earlyDeparture);
    }

    public double getPerforming_utils_hr() {
        if (this.getScoringParameters(null) != null) {
            return this.getScoringParameters(null).getPerforming_utils_hr();
        }
        if (this.getScoringParameters(DEFAULT_SUBPOPULATION) != null) {
            return this.getScoringParameters(DEFAULT_SUBPOPULATION).getPerforming_utils_hr();
        }
        throw new RuntimeException("Default subpopulation is not defined");
    }

    public void setPerforming_utils_hr(double performing) {
        this.getScoringParameters(null).setPerforming_utils_hr(performing);
    }

    public double getMarginalUtilityOfMoney() {
        if (this.getScoringParameters(null) != null) {
            return this.getScoringParameters(null).getMarginalUtilityOfMoney();
        }
        if (this.getScoringParameters(DEFAULT_SUBPOPULATION) != null) {
            return this.getScoringParameters(DEFAULT_SUBPOPULATION).getMarginalUtilityOfMoney();
        }
        throw new RuntimeException("Default subpopulation is not defined");
    }

    public void setMarginalUtilityOfMoney(double marginalUtilityOfMoney) {
        this.getScoringParameters(null).setMarginalUtilityOfMoney(marginalUtilityOfMoney);
    }

    public double getUtilityOfLineSwitch() {
        if (this.getScoringParameters(null) != null) {
            return this.getScoringParameters(null).getUtilityOfLineSwitch();
        }
        if (this.getScoringParameters(DEFAULT_SUBPOPULATION) != null) {
            return this.getScoringParameters(DEFAULT_SUBPOPULATION).getUtilityOfLineSwitch();
        }
        throw new RuntimeException("Default subpopulation is not defined");
    }

    public void setUtilityOfLineSwitch(double utilityOfLineSwitch) {
        this.getScoringParameters(null).setUtilityOfLineSwitch(utilityOfLineSwitch);
    }

    public boolean isUsingOldScoringBelowZeroUtilityDuration() {
        return this.delegate.isUsingOldScoringBelowZeroUtilityDuration();
    }

    public void setUsingOldScoringBelowZeroUtilityDuration(boolean usingOldScoringBelowZeroUtilityDuration) {
        this.delegate.setUsingOldScoringBelowZeroUtilityDuration(usingOldScoringBelowZeroUtilityDuration);
    }

    public boolean isWriteExperiencedPlans() {
        return this.delegate.isWriteExperiencedPlans();
    }

    public void setWriteExperiencedPlans(boolean writeExperiencedPlans) {
        this.delegate.setWriteExperiencedPlans(writeExperiencedPlans);
    }

    public double getMarginalUtlOfWaiting_utils_hr() {
        if (this.getScoringParameters(null) != null) {
            return this.getScoringParameters(null).getMarginalUtlOfWaiting_utils_hr();
        }
        if (this.getScoringParameters(DEFAULT_SUBPOPULATION) != null) {
            return this.getScoringParameters(DEFAULT_SUBPOPULATION).getMarginalUtlOfWaiting_utils_hr();
        }
        throw new RuntimeException("Default subpopulation is not defined");
    }

    public void setMarginalUtlOfWaiting_utils_hr(double waiting) {
        this.getScoringParameters(null).setMarginalUtlOfWaiting_utils_hr(waiting);
    }

    public void setFractionOfIterationsToStartScoreMSA(Double val) {
        this.delegate.setFractionOfIterationsToStartScoreMSA(val);
    }

    public Double getFractionOfIterationsToStartScoreMSA() {
        return this.delegate.getFractionOfIterationsToStartScoreMSA();
    }

    @Override
    public final void setLocked() {
        super.setLocked();
        this.delegate.setLocked();
    }

    private static class ReflectiveDelegate
    extends ReflectiveConfigGroup {
        private double learningRate = 1.0;
        private double brainExpBeta = 1.0;
        private double pathSizeLogitBeta = 1.0;
        private boolean writeExperiencedPlans = false;
        private Double fractionOfIterationsToStartScoreMSA = null;
        private boolean usingOldScoringBelowZeroUtilityDuration = false;

        private ReflectiveDelegate() {
            super(PlanCalcScoreConfigGroup.GROUP_NAME);
        }

        @ReflectiveConfigGroup.StringGetter(value="fractionOfIterationsToStartScoreMSA")
        public Double getFractionOfIterationsToStartScoreMSA() {
            return this.fractionOfIterationsToStartScoreMSA;
        }

        @ReflectiveConfigGroup.StringSetter(value="fractionOfIterationsToStartScoreMSA")
        public void setFractionOfIterationsToStartScoreMSA(Double fractionOfIterationsToStartScoreMSA) {
            this.testForLocked();
            this.fractionOfIterationsToStartScoreMSA = fractionOfIterationsToStartScoreMSA;
        }

        @ReflectiveConfigGroup.StringGetter(value="learningRate")
        public double getLearningRate() {
            return this.learningRate;
        }

        @ReflectiveConfigGroup.StringSetter(value="learningRate")
        public void setLearningRate(double learningRate) {
            this.testForLocked();
            this.learningRate = learningRate;
        }

        @ReflectiveConfigGroup.StringGetter(value="BrainExpBeta")
        public double getBrainExpBeta() {
            return this.brainExpBeta;
        }

        @ReflectiveConfigGroup.StringSetter(value="BrainExpBeta")
        public void setBrainExpBeta(double brainExpBeta) {
            this.testForLocked();
            this.brainExpBeta = brainExpBeta;
        }

        @ReflectiveConfigGroup.StringGetter(value="PathSizeLogitBeta")
        public double getPathSizeLogitBeta() {
            return this.pathSizeLogitBeta;
        }

        @ReflectiveConfigGroup.StringSetter(value="PathSizeLogitBeta")
        public void setPathSizeLogitBeta(double beta) {
            this.testForLocked();
            if (beta != 0.0) {
                log.warn("Setting pathSizeLogitBeta different from zero is experimental.  KN, Sep'08");
            }
            this.pathSizeLogitBeta = beta;
        }

        @ReflectiveConfigGroup.StringGetter(value="usingOldScoringBelowZeroUtilityDuration")
        public boolean isUsingOldScoringBelowZeroUtilityDuration() {
            return this.usingOldScoringBelowZeroUtilityDuration;
        }

        @ReflectiveConfigGroup.StringSetter(value="usingOldScoringBelowZeroUtilityDuration")
        public void setUsingOldScoringBelowZeroUtilityDuration(boolean usingOldScoringBelowZeroUtilityDuration) {
            this.testForLocked();
            this.usingOldScoringBelowZeroUtilityDuration = usingOldScoringBelowZeroUtilityDuration;
        }

        @ReflectiveConfigGroup.StringGetter(value="writeExperiencedPlans")
        public boolean isWriteExperiencedPlans() {
            return this.writeExperiencedPlans;
        }

        @ReflectiveConfigGroup.StringSetter(value="writeExperiencedPlans")
        public void setWriteExperiencedPlans(boolean writeExperiencedPlans) {
            this.testForLocked();
            this.writeExperiencedPlans = writeExperiencedPlans;
        }
    }

    public static class ScoringParameterSet
    extends ReflectiveConfigGroup {
        public static final String SET_TYPE = "scoringParameters";
        private String subpopulation = null;
        private double lateArrival = -18.0;
        private double earlyDeparture = -0.0;
        private double performing = 6.0;
        private double waiting = -0.0;
        private double marginalUtilityOfMoney = 1.0;
        private double utilityOfLineSwitch = -1.0;
        private Double waitingPt = null;
        private static int setWaitingCnt = 0;

        private ScoringParameterSet(String subpopulation) {
            this();
            this.subpopulation = subpopulation;
        }

        private ScoringParameterSet() {
            super(SET_TYPE);
        }

        @ReflectiveConfigGroup.StringGetter(value="lateArrival")
        public double getLateArrival_utils_hr() {
            return this.lateArrival;
        }

        @ReflectiveConfigGroup.StringSetter(value="lateArrival")
        public void setLateArrival_utils_hr(double lateArrival) {
            this.testForLocked();
            this.lateArrival = lateArrival;
        }

        @ReflectiveConfigGroup.StringGetter(value="earlyDeparture")
        public double getEarlyDeparture_utils_hr() {
            return this.earlyDeparture;
        }

        @ReflectiveConfigGroup.StringSetter(value="earlyDeparture")
        public void setEarlyDeparture_utils_hr(double earlyDeparture) {
            this.testForLocked();
            this.earlyDeparture = earlyDeparture;
        }

        @ReflectiveConfigGroup.StringGetter(value="performing")
        public double getPerforming_utils_hr() {
            return this.performing;
        }

        @ReflectiveConfigGroup.StringSetter(value="performing")
        public void setPerforming_utils_hr(double performing) {
            this.performing = performing;
        }

        @ReflectiveConfigGroup.StringGetter(value="marginalUtilityOfMoney")
        public double getMarginalUtilityOfMoney() {
            return this.marginalUtilityOfMoney;
        }

        @ReflectiveConfigGroup.StringSetter(value="marginalUtilityOfMoney")
        public void setMarginalUtilityOfMoney(double marginalUtilityOfMoney) {
            this.testForLocked();
            this.marginalUtilityOfMoney = marginalUtilityOfMoney;
        }

        @ReflectiveConfigGroup.StringGetter(value="utilityOfLineSwitch")
        public double getUtilityOfLineSwitch() {
            return this.utilityOfLineSwitch;
        }

        @ReflectiveConfigGroup.StringSetter(value="utilityOfLineSwitch")
        public void setUtilityOfLineSwitch(double utilityOfLineSwitch) {
            this.testForLocked();
            this.utilityOfLineSwitch = utilityOfLineSwitch;
        }

        @ReflectiveConfigGroup.StringGetter(value="waiting")
        public double getMarginalUtlOfWaiting_utils_hr() {
            return this.waiting;
        }

        @ReflectiveConfigGroup.StringSetter(value="waiting")
        public void setMarginalUtlOfWaiting_utils_hr(double waiting) {
            this.testForLocked();
            this.waiting = waiting;
        }

        @ReflectiveConfigGroup.StringGetter(value="subpopulation")
        public String getSubpopulation() {
            return this.subpopulation;
        }

        @ReflectiveConfigGroup.StringSetter(value="subpopulation")
        public void setSubpopulation(String subpopulation) {
            if (this.subpopulation != null) {
                throw new IllegalStateException("cannot change subpopulation in a scoring parameter set, as it is used for indexing.");
            }
            this.subpopulation = subpopulation;
        }

        @ReflectiveConfigGroup.StringGetter(value="waitingPt")
        public double getMarginalUtlOfWaitingPt_utils_hr() {
            return this.waitingPt != null ? this.waitingPt.doubleValue() : this.getModes().get("pt").getMarginalUtilityOfTraveling();
        }

        @ReflectiveConfigGroup.StringSetter(value="waitingPt")
        public void setMarginalUtlOfWaitingPt_utils_hr(Double waitingPt) {
            this.waitingPt = waitingPt;
        }

        @Override
        public ConfigGroup createParameterSet(String type) {
            switch (type) {
                case "activityParams": {
                    return new ActivityParams();
                }
                case "modeParams": {
                    return new ModeParams();
                }
            }
            throw new IllegalArgumentException(type);
        }

        @Override
        protected void checkParameterSet(ConfigGroup module) {
            switch (module.getName()) {
                case "activityParams": {
                    if (!(module instanceof ActivityParams)) {
                        throw new RuntimeException("wrong class for " + module);
                    }
                    String t = ((ActivityParams)module).getActivityType();
                    if (this.getActivityParams(t) == null) break;
                    throw new IllegalStateException("already a parameter set for activity type " + t);
                }
                case "modeParams": {
                    if (!(module instanceof ModeParams)) {
                        throw new RuntimeException("wrong class for " + module);
                    }
                    String m3 = ((ModeParams)module).getMode();
                    if (this.getModes().get(m3) == null) break;
                    throw new IllegalStateException("already a parameter set for mode " + m3);
                }
                default: {
                    throw new IllegalArgumentException(module.getName());
                }
            }
        }

        public Collection<String> getActivityTypes() {
            return this.getActivityParamsPerType().keySet();
        }

        public Collection<ActivityParams> getActivityParams() {
            Collection<? extends ConfigGroup> collection = this.getParameterSets("activityParams");
            for (ActivityParams activityParams : collection) {
                if (!this.isLocked()) continue;
                activityParams.setLocked();
            }
            return collection;
        }

        public Map<String, ActivityParams> getActivityParamsPerType() {
            LinkedHashMap<String, ActivityParams> map = new LinkedHashMap<String, ActivityParams>();
            for (ActivityParams pars : this.getActivityParams()) {
                map.put(pars.getActivityType(), pars);
            }
            return map;
        }

        public ActivityParams getActivityParams(String actType) {
            return this.getActivityParamsPerType().get(actType);
        }

        public ActivityParams getOrCreateActivityParams(String actType) {
            ActivityParams params = this.getActivityParamsPerType().get(actType);
            if (params == null) {
                params = new ActivityParams(actType);
                this.addActivityParams(params);
            }
            return params;
        }

        public Map<String, ModeParams> getModes() {
            Collection<? extends ConfigGroup> modes = this.getParameterSets("modeParams");
            LinkedHashMap<String, ModeParams> map = new LinkedHashMap<String, ModeParams>();
            for (ModeParams modeParams : modes) {
                if (this.isLocked()) {
                    modeParams.setLocked();
                }
                map.put(modeParams.getMode(), modeParams);
            }
            if (this.isLocked()) {
                return Collections.unmodifiableMap(map);
            }
            return map;
        }

        public ModeParams getOrCreateModeParams(String modeName) {
            ModeParams modeParams = this.getModes().get(modeName);
            if (modeParams == null) {
                modeParams = new ModeParams(modeName);
                this.addParameterSet(modeParams);
            }
            return modeParams;
        }

        public void addModeParams(ModeParams params) {
            ModeParams previous = this.getModes().get(params.getMode());
            if (previous != null) {
                boolean removed = this.removeParameterSet(previous);
                if (!removed) {
                    throw new RuntimeException("problem replacing mode params ");
                }
                log.info("mode parameters for mode " + previous.getMode() + " were just overwritten.");
            }
            super.addParameterSet(params);
        }

        public void addActivityParams(ActivityParams params) {
            ActivityParams previous = this.getActivityParams(params.getActivityType());
            if (previous != null) {
                if (previous.getActivityType().equals("pt interaction")) {
                    log.error("ERROR: Activity parameters for activity type " + previous.getActivityType() + " were just overwritten. This happens most " + "likely because you defined them in the config file and the Controler overwrites them.  Or the other way " + "round.  pt interaction has problems, but doing what you are doing here will just cause " + "other (less visible) problem. Please take the effort to discuss with the core team " + "what needs to be done.  kai, nov'12");
                } else {
                    log.info("activity parameters for activity type " + previous.getActivityType() + " were just overwritten.");
                }
                boolean removed = this.removeParameterSet(previous);
                if (!removed) {
                    throw new RuntimeException("problem replacing activity params ");
                }
            }
            super.addParameterSet(params);
        }

        @Override
        public void checkConsistency(Config config) {
            super.checkConsistency(config);
            boolean hasOpeningAndClosingTime = false;
            boolean hasOpeningTimeAndLatePenalty = false;
            for (ActivityParams actType : this.getActivityParams()) {
                if (!actType.isScoringThisActivityAtAll()) continue;
                if (!Time.isUndefinedTime(actType.getOpeningTime()) && !Time.isUndefinedTime(actType.getClosingTime())) {
                    hasOpeningAndClosingTime = true;
                }
                if (!Time.isUndefinedTime(actType.getOpeningTime()) && this.getLateArrival_utils_hr() < -0.001) {
                    hasOpeningTimeAndLatePenalty = true;
                }
                if (actType.getOpeningTime() != 0.0 || !(actType.getClosingTime() > 86399.0)) continue;
                log.error("it looks like you have an activity type with opening time set to 0:00 and closing time set to 24:00. This is most probably not the same as not setting them at all.  In particular, activities which extend past midnight may not accumulate scores.");
            }
            if (!hasOpeningAndClosingTime && !hasOpeningTimeAndLatePenalty) {
                log.info("NO OPENING OR CLOSING TIMES DEFINED!\n\nThere is no activity type that has an opening *and* closing time (or opening time and late penalty) defined.\nThis usually means that the activity chains can be shifted by an arbitrary\nnumber of hours without having an effect on the score of the plans, and thus\nresulting in wrong results / traffic patterns.\nIf you are using MATSim without time adaptation, you can ignore this warning.\n\n");
            }
            if (this.getMarginalUtlOfWaiting_utils_hr() != 0.0) {
                log.warn("marginal utl of wait set to: " + this.getMarginalUtlOfWaiting_utils_hr() + ". Setting this different from zero is " + "discouraged since there is already the marginal utility of time as a resource. The parameter was also used " + "in the past for pt routing; if you did that, consider setting the new " + "parameter waitingPt instead.");
            }
        }
    }

    public static class ModeParams
    extends ReflectiveConfigGroup
    implements MatsimParameters {
        static final String SET_TYPE = "modeParams";
        private static final String MONETARY_DISTANCE_RATE = "monetaryDistanceRate";
        private static final String MONETARY_DISTANCE_RATE_CMT = "[unit_of_money/m] conversion of distance into money. Normally negative.";
        private static final String MARGINAL_UTILITY_OF_TRAVELING = "marginalUtilityOfTraveling_util_hr";
        private static final String CONSTANT = "constant";
        private static final String CONSTANT_CMT = "[utils] alternative-specific constant.  Normally per trip, but that is probably buggy for multi-leg trips.";
        public static final String MODE = "mode";
        static final String DAILY_MONETARY_CONSTANT = "dailyMonetaryConstant";
        static final String DAILY_UTILITY_CONSTANT = "dailyUtilityConstant";
        private String mode = null;
        private double traveling = -6.0;
        private double distance = 0.0;
        private double monetaryDistanceRate = 0.0;
        private double constant = 0.0;
        private double dailyMonetaryConstant = 0.0;
        private double dailyUtilityConstant = 0.0;

        public ModeParams(String mode) {
            super(SET_TYPE);
            this.setMode(mode);
        }

        ModeParams() {
            super(SET_TYPE);
        }

        @Override
        public Map<String, String> getComments() {
            Map<String, String> map = super.getComments();
            map.put(MARGINAL_UTILITY_OF_TRAVELING, "[utils/hr] additional marginal utility of traveling.  normally negative.  this comes on top of the opportunity cost of time");
            map.put("marginalUtilityOfDistance_util_m", "[utils/m] utility of traveling (e.g. walking or driving) per m, normally negative.  this is on top of the time (dis)utility.");
            map.put(MONETARY_DISTANCE_RATE, MONETARY_DISTANCE_RATE_CMT);
            map.put(CONSTANT, CONSTANT_CMT);
            map.put(DAILY_UTILITY_CONSTANT, "[utils] daily utility constant. default=0 to be backwards compatible");
            map.put(DAILY_MONETARY_CONSTANT, "[money] daily monetary constant. default=0 to be backwards compatible");
            return map;
        }

        @ReflectiveConfigGroup.StringSetter(value="mode")
        public ModeParams setMode(String mode) {
            this.testForLocked();
            this.mode = mode;
            return this;
        }

        @ReflectiveConfigGroup.StringGetter(value="mode")
        public String getMode() {
            return this.mode;
        }

        @ReflectiveConfigGroup.StringSetter(value="marginalUtilityOfTraveling_util_hr")
        public ModeParams setMarginalUtilityOfTraveling(double traveling) {
            this.testForLocked();
            this.traveling = traveling;
            return this;
        }

        @ReflectiveConfigGroup.StringGetter(value="marginalUtilityOfTraveling_util_hr")
        public double getMarginalUtilityOfTraveling() {
            return this.traveling;
        }

        @ReflectiveConfigGroup.StringGetter(value="marginalUtilityOfDistance_util_m")
        public double getMarginalUtilityOfDistance() {
            return this.distance;
        }

        @ReflectiveConfigGroup.StringSetter(value="marginalUtilityOfDistance_util_m")
        public ModeParams setMarginalUtilityOfDistance(double distance) {
            this.testForLocked();
            this.distance = distance;
            return this;
        }

        @ReflectiveConfigGroup.StringGetter(value="constant")
        public double getConstant() {
            return this.constant;
        }

        @ReflectiveConfigGroup.StringSetter(value="constant")
        public ModeParams setConstant(double constant) {
            this.testForLocked();
            this.constant = constant;
            return this;
        }

        @ReflectiveConfigGroup.StringGetter(value="monetaryDistanceRate")
        public double getMonetaryDistanceRate() {
            return this.monetaryDistanceRate;
        }

        @ReflectiveConfigGroup.StringSetter(value="monetaryDistanceRate")
        public ModeParams setMonetaryDistanceRate(double monetaryDistanceRate) {
            this.testForLocked();
            this.monetaryDistanceRate = monetaryDistanceRate;
            return this;
        }

        @ReflectiveConfigGroup.StringGetter(value="dailyMonetaryConstant")
        public double getDailyMonetaryConstant() {
            return this.dailyMonetaryConstant;
        }

        @ReflectiveConfigGroup.StringSetter(value="dailyMonetaryConstant")
        public ModeParams setDailyMonetaryConstant(double dailyMonetaryConstant) {
            this.dailyMonetaryConstant = dailyMonetaryConstant;
            return this;
        }

        @ReflectiveConfigGroup.StringGetter(value="dailyUtilityConstant")
        public double getDailyUtilityConstant() {
            return this.dailyUtilityConstant;
        }

        @ReflectiveConfigGroup.StringSetter(value="dailyUtilityConstant")
        public ModeParams setDailyUtilityConstant(double dailyUtilityConstant) {
            this.dailyUtilityConstant = dailyUtilityConstant;
            return this;
        }
    }

    public static class ActivityParams
    extends ReflectiveConfigGroup
    implements MatsimParameters {
        public static final String SET_TYPE = "activityParams";
        private static final String TYPICAL_DURATION_SCORE_COMPUTATION = "typicalDurationScoreComputation";
        private TypicalDurationScoreComputation typicalDurationScoreComputation = TypicalDurationScoreComputation.relative;
        public static final String TYPICAL_DURATION = "typicalDuration";
        public static final String TYPICAL_DURATION_CMT = "typical duration of activity.  needs to be defined and non-zero.  in sec.";
        public static final String ACTIVITY_TYPE = "activityType";
        private String type;
        public static final String ACVITITY_TYPE_CMT = "all activity types that occur in the plans file need to be defined by their own sections here";
        private double priority = 1.0;
        private double typicalDuration = Time.getUndefinedTime();
        private double minimalDuration = Time.getUndefinedTime();
        private double openingTime = Time.getUndefinedTime();
        private double latestStartTime = Time.getUndefinedTime();
        private double earliestEndTime = Time.getUndefinedTime();
        private double closingTime = Time.getUndefinedTime();
        private static int minDurCnt = 0;
        static final String SCORING_THIS_ACTIVITY_AT_ALL = "scoringThisActivityAtAll";
        private boolean scoringThisActivityAtAll = true;

        @ReflectiveConfigGroup.StringGetter(value="typicalDuration")
        private String getTypicalDurationString() {
            return Time.writeTime(this.getTypicalDuration());
        }

        public double getTypicalDuration() {
            return this.typicalDuration;
        }

        @ReflectiveConfigGroup.StringSetter(value="typicalDuration")
        private ActivityParams setTypicalDuration(String typicalDuration) {
            this.testForLocked();
            return this.setTypicalDuration(Time.parseTime(typicalDuration));
        }

        public ActivityParams setTypicalDuration(double typicalDuration) {
            this.testForLocked();
            this.typicalDuration = typicalDuration;
            return this;
        }

        @ReflectiveConfigGroup.StringGetter(value="activityType")
        public String getActivityType() {
            return this.type;
        }

        @ReflectiveConfigGroup.StringSetter(value="activityType")
        public void setActivityType(String type) {
            this.testForLocked();
            this.type = type;
        }

        public ActivityParams() {
            super(SET_TYPE);
        }

        public ActivityParams(String type) {
            super(SET_TYPE);
            this.type = type;
        }

        @Override
        public Map<String, String> getComments() {
            Map<String, String> map = super.getComments();
            StringBuilder str = new StringBuilder();
            str.append("method to compute score at typical duration.  Options: | ");
            for (TypicalDurationScoreComputation value : TypicalDurationScoreComputation.values()) {
                str.append(value.name());
                str.append(" | ");
            }
            str.append("Use ");
            str.append(TypicalDurationScoreComputation.uniform.name());
            str.append(" for backwards compatibility (all activities same score; higher proba to drop long acts).");
            map.put(TYPICAL_DURATION_SCORE_COMPUTATION, str.toString());
            map.put(TYPICAL_DURATION, TYPICAL_DURATION_CMT);
            return map;
        }

        @ReflectiveConfigGroup.StringGetter(value="typicalDurationScoreComputation")
        public TypicalDurationScoreComputation getTypicalDurationScoreComputation() {
            return this.typicalDurationScoreComputation;
        }

        @ReflectiveConfigGroup.StringSetter(value="typicalDurationScoreComputation")
        public ActivityParams setTypicalDurationScoreComputation(TypicalDurationScoreComputation str) {
            this.testForLocked();
            this.typicalDurationScoreComputation = str;
            return this;
        }

        @ReflectiveConfigGroup.StringGetter(value="priority")
        public double getPriority() {
            return this.priority;
        }

        @ReflectiveConfigGroup.StringSetter(value="priority")
        public ActivityParams setPriority(double priority) {
            this.testForLocked();
            this.priority = priority;
            return this;
        }

        @ReflectiveConfigGroup.StringGetter(value="minimalDuration")
        private String getMinimalDurationString() {
            return Time.writeTime(this.getMinimalDuration());
        }

        public double getMinimalDuration() {
            return this.minimalDuration;
        }

        @ReflectiveConfigGroup.StringSetter(value="minimalDuration")
        private ActivityParams setMinimalDuration(String minimalDuration) {
            this.testForLocked();
            return this.setMinimalDuration(Time.parseTime(minimalDuration));
        }

        public ActivityParams setMinimalDuration(double minimalDuration) {
            this.testForLocked();
            if (!Time.isUndefinedTime(minimalDuration) && minDurCnt < 1) {
                ++minDurCnt;
                log.warn("Setting minimalDuration different from zero is discouraged.  It is probably implemented correctly, but there is as of now no indication that it makes the results more realistic.  KN, Sep'08 This message given only once.");
            }
            this.minimalDuration = minimalDuration;
            return this;
        }

        @ReflectiveConfigGroup.StringGetter(value="openingTime")
        private String getOpeningTimeString() {
            return Time.writeTime(this.getOpeningTime());
        }

        public double getOpeningTime() {
            return this.openingTime;
        }

        @ReflectiveConfigGroup.StringSetter(value="openingTime")
        private ActivityParams setOpeningTime(String openingTime) {
            this.testForLocked();
            this.setOpeningTime(Time.parseTime(openingTime));
            return this;
        }

        public ActivityParams setOpeningTime(double openingTime) {
            this.testForLocked();
            this.openingTime = openingTime;
            return this;
        }

        @ReflectiveConfigGroup.StringGetter(value="latestStartTime")
        private String getLatestStartTimeString() {
            return Time.writeTime(this.getLatestStartTime());
        }

        public double getLatestStartTime() {
            return this.latestStartTime;
        }

        @ReflectiveConfigGroup.StringSetter(value="latestStartTime")
        private ActivityParams setLatestStartTime(String latestStartTime) {
            this.testForLocked();
            this.setLatestStartTime(Time.parseTime(latestStartTime));
            return this;
        }

        public ActivityParams setLatestStartTime(double latestStartTime) {
            this.testForLocked();
            this.latestStartTime = latestStartTime;
            return this;
        }

        @ReflectiveConfigGroup.StringGetter(value="earliestEndTime")
        private String getEarliestEndTimeString() {
            return Time.writeTime(this.getEarliestEndTime());
        }

        public double getEarliestEndTime() {
            return this.earliestEndTime;
        }

        @ReflectiveConfigGroup.StringSetter(value="earliestEndTime")
        private ActivityParams setEarliestEndTime(String earliestEndTime) {
            this.testForLocked();
            this.setEarliestEndTime(Time.parseTime(earliestEndTime));
            return this;
        }

        public ActivityParams setEarliestEndTime(double earliestEndTime) {
            this.testForLocked();
            this.earliestEndTime = earliestEndTime;
            return this;
        }

        @ReflectiveConfigGroup.StringGetter(value="closingTime")
        private String getClosingTimeString() {
            return Time.writeTime(this.getClosingTime());
        }

        public double getClosingTime() {
            return this.closingTime;
        }

        @ReflectiveConfigGroup.StringSetter(value="closingTime")
        private ActivityParams setClosingTime(String closingTime) {
            this.testForLocked();
            this.setClosingTime(Time.parseTime(closingTime));
            return this;
        }

        public ActivityParams setClosingTime(double closingTime) {
            this.testForLocked();
            this.closingTime = closingTime;
            return this;
        }

        @ReflectiveConfigGroup.StringGetter(value="scoringThisActivityAtAll")
        public boolean isScoringThisActivityAtAll() {
            return this.scoringThisActivityAtAll;
        }

        @ReflectiveConfigGroup.StringSetter(value="scoringThisActivityAtAll")
        public ActivityParams setScoringThisActivityAtAll(boolean scoringThisActivityAtAll) {
            this.testForLocked();
            this.scoringThisActivityAtAll = scoringThisActivityAtAll;
            return this;
        }
    }

    public static enum TypicalDurationScoreComputation {
        uniform,
        relative;

    }
}

