/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.config.groups;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.matsim.core.api.internal.MatsimParameters;
import org.matsim.core.config.Config;
import org.matsim.core.config.ConfigGroup;
import org.matsim.core.config.ReflectiveConfigGroup;
import org.matsim.core.utils.collections.CollectionUtils;

public final class PlansCalcRouteConfigGroup
extends ConfigGroup {
    public static final String GROUP_NAME = "planscalcroute";
    private static final String BEELINE_DISTANCE_FACTOR = "beelineDistanceFactor";
    private static final String NETWORK_MODES = "networkModes";
    private static final String TELEPORTED_MODE_SPEEDS = "teleportedModeSpeed_";
    private static final String TELEPORTED_MODE_FREESPEED_FACTORS = "teleportedModeFreespeedFactor_";
    public static final String UNDEFINED = "undefined";
    private static final String PT_SPEED_FACTOR = "ptSpeedFactor";
    private static final String PT_SPEED = "ptSpeed";
    private static final String WALK_SPEED = "walkSpeed";
    private static final String BIKE_SPEED = "bikeSpeed";
    private static final String UNDEFINED_MODE_SPEED = "undefinedModeSpeed";
    private static final Logger log = Logger.getLogger(PlansCalcRouteConfigGroup.class);
    private Collection<String> networkModes = Collections.singletonList("car");
    private boolean acceptModeParamsWithoutClearing = true;
    private Double beelineDistanceFactor = 1.3;
    private boolean insertingAccessEgressWalk = false;
    private static final String RANDOMNESS = "routingRandomness";
    private double routingRandomness = 3.0;

    public PlansCalcRouteConfigGroup() {
        super(GROUP_NAME);
        ModeRoutingParams bike = new ModeRoutingParams("bike");
        bike.setTeleportedModeSpeed(4.166666666666667);
        this.addParameterSet(bike);
        ModeRoutingParams walk = new ModeRoutingParams("walk");
        walk.setTeleportedModeSpeed(0.8333333333333333);
        this.addParameterSet(walk);
        walk = new ModeRoutingParams("non_network_walk");
        walk.setTeleportedModeSpeed(0.8333333333333333);
        this.addParameterSet(walk);
        walk = new ModeRoutingParams("non_network_walk");
        walk.setTeleportedModeSpeed(0.8333333333333333);
        this.addParameterSet(walk);
        ModeRoutingParams undefined = new ModeRoutingParams(UNDEFINED);
        undefined.setTeleportedModeSpeed(13.88888888888889);
        this.addParameterSet(undefined);
        ModeRoutingParams ride = new ModeRoutingParams("ride");
        ride.setTeleportedModeFreespeedFactor(1.0);
        this.addParameterSet(ride);
        ModeRoutingParams pt = new ModeRoutingParams("pt");
        pt.setTeleportedModeFreespeedFactor(2.0);
        this.addParameterSet(pt);
        this.acceptModeParamsWithoutClearing = false;
    }

    @Override
    public ConfigGroup createParameterSet(String type) {
        switch (type) {
            case "teleportedModeParameters": {
                return new ModeRoutingParams();
            }
        }
        throw new IllegalArgumentException(type);
    }

    @Override
    protected void checkParameterSet(ConfigGroup module) {
        switch (module.getName()) {
            case "teleportedModeParameters": {
                if (module instanceof ModeRoutingParams) break;
                throw new RuntimeException("unexpected class for module " + module);
            }
            default: {
                throw new IllegalArgumentException(module.getName());
            }
        }
    }

    public void clearModeRoutingParams() {
        this.clearParameterSetsForType("teleportedModeParameters");
    }

    @Override
    public void addParameterSet(ConfigGroup set) {
        if (set.getName().equals("teleportedModeParameters")) {
            if (!this.acceptModeParamsWithoutClearing) {
                log.warn("It used to be the case that manually setting one mode routing here would first clear all the default values.  I have now removed this clearing, i.e. default values will remain.  If they are in the way, removeModeRoutingParams(...) can be used to individually remove them.  kai, apr'19");
                this.acceptModeParamsWithoutClearing = true;
            }
            ModeRoutingParams pars = (ModeRoutingParams)set;
            ModeRoutingParams result = this.getModeRoutingParams().get(pars.getMode());
            if (result != null) {
                log.info("Replacing mode routing params for mode=" + pars.getMode() + ".");
                this.removeModeRoutingParams(pars.getMode());
            }
            if (pars.getBeelineDistanceFactor() == null) {
                pars.setBeelineDistanceFactor(this.beelineDistanceFactor);
            }
        }
        super.addParameterSet(set);
    }

    public void addModeRoutingParams(ModeRoutingParams pars) {
        this.testForLocked();
        this.addParameterSet(pars);
    }

    public void removeModeRoutingParams(String key) {
        this.testForLocked();
        for (ConfigGroup configGroup : this.getParameterSets("teleportedModeParameters")) {
            String mode = ((ModeRoutingParams)configGroup).getMode();
            if (!key.equals(mode)) continue;
            this.removeParameterSet(configGroup);
            break;
        }
    }

    public Map<String, ModeRoutingParams> getModeRoutingParams() {
        LinkedHashMap<String, ModeRoutingParams> map = new LinkedHashMap<String, ModeRoutingParams>();
        for (ConfigGroup configGroup : this.getParameterSets("teleportedModeParameters")) {
            String mode;
            ModeRoutingParams old;
            if (this.isLocked()) {
                configGroup.setLocked();
            }
            if ((old = map.put(mode = ((ModeRoutingParams)configGroup).getMode(), (ModeRoutingParams)configGroup)) == null) continue;
            throw new IllegalStateException("several parameter sets for mode " + mode);
        }
        return map;
    }

    public ModeRoutingParams getOrCreateModeRoutingParams(String mode) {
        ModeRoutingParams pars = this.getModeRoutingParams().get(mode);
        if (pars == null) {
            pars = (ModeRoutingParams)this.createParameterSet("teleportedModeParameters");
            pars.setMode(mode);
            this.addParameterSet(pars);
        }
        if (this.isLocked()) {
            pars.setLocked();
        }
        return pars;
    }

    @Override
    public String getValue(String key) {
        throw new IllegalArgumentException(key + ": getValue access disabled; use direct getter");
    }

    @Override
    public void addParam(String key, String value) {
        if (value.equals("null")) {
            return;
        }
        if (PT_SPEED_FACTOR.equals(key)) {
            this.setTeleportedModeFreespeedFactor("pt", Double.parseDouble(value));
        } else if (BEELINE_DISTANCE_FACTOR.equals(key)) {
            this.setBeelineDistanceFactor(Double.parseDouble(value));
        } else if (PT_SPEED.equals(key)) {
            this.setTeleportedModeSpeed("pt", Double.parseDouble(value));
        } else if (WALK_SPEED.equals(key)) {
            this.setTeleportedModeSpeed("walk", Double.parseDouble(value));
        } else if (BIKE_SPEED.equals(key)) {
            this.setTeleportedModeSpeed("bike", Double.parseDouble(value));
        } else if (UNDEFINED_MODE_SPEED.equals(key)) {
            this.setTeleportedModeSpeed(UNDEFINED, Double.parseDouble(value));
        } else if (NETWORK_MODES.equals(key)) {
            this.setNetworkModes(Arrays.asList(CollectionUtils.stringToArray(value)));
        } else if (key.startsWith(TELEPORTED_MODE_SPEEDS)) {
            this.setTeleportedModeSpeed(key.substring(TELEPORTED_MODE_SPEEDS.length()), Double.parseDouble(value));
        } else if (key.startsWith(TELEPORTED_MODE_FREESPEED_FACTORS)) {
            this.setTeleportedModeFreespeedFactor(key.substring(TELEPORTED_MODE_FREESPEED_FACTORS.length()), Double.parseDouble(value));
        } else {
            throw new IllegalArgumentException(key);
        }
    }

    @Override
    public final Map<String, String> getParams() {
        Map<String, String> map = super.getParams();
        map.put(NETWORK_MODES, CollectionUtils.arrayToString(this.networkModes.toArray(new String[this.networkModes.size()])));
        return map;
    }

    @Override
    public final Map<String, String> getComments() {
        Map<String, String> map = super.getComments();
        map.put(BEELINE_DISTANCE_FACTOR, "factor with which beeline distances (and therefore times) are multiplied in order to obtain an estimate of the network distances/times.  Default is something like 1.3");
        map.put(NETWORK_MODES, "All the modes for which the router is supposed to generate network routes (like car)");
        map.put(RANDOMNESS, "strength of the randomness for the utility of money in routing under toll.  Leads to Pareto-optimal route with randomly drawn money-vs-other-attributes tradeoff. Technically the width parameter of a log-normal distribution. 3.0 seems to be a good value. ");
        return map;
    }

    public Collection<String> getNetworkModes() {
        return this.networkModes;
    }

    public void setNetworkModes(Collection<String> networkModes) {
        this.networkModes = networkModes;
    }

    public Map<String, Double> getTeleportedModeSpeeds() {
        LinkedHashMap<String, Double> map = new LinkedHashMap<String, Double>();
        for (ModeRoutingParams pars : this.getModeRoutingParams().values()) {
            Double speed;
            if (this.isLocked()) {
                pars.setLocked();
            }
            if ((speed = pars.getTeleportedModeSpeed()) == null) continue;
            map.put(pars.getMode(), speed);
        }
        return map;
    }

    public Map<String, Double> getTeleportedModeFreespeedFactors() {
        LinkedHashMap<String, Double> map = new LinkedHashMap<String, Double>();
        for (ModeRoutingParams pars : this.getModeRoutingParams().values()) {
            Double speed;
            if (this.isLocked()) {
                pars.setLocked();
            }
            if ((speed = pars.getTeleportedModeFreespeedFactor()) == null) continue;
            map.put(pars.getMode(), speed);
        }
        return map;
    }

    public Map<String, Double> getBeelineDistanceFactors() {
        LinkedHashMap<String, Double> map = new LinkedHashMap<String, Double>();
        for (ModeRoutingParams pars : this.getModeRoutingParams().values()) {
            Double val;
            if (this.isLocked()) {
                pars.setLocked();
            }
            if ((val = pars.getBeelineDistanceFactor()) == null) continue;
            map.put(pars.getMode(), val);
        }
        return map;
    }

    public void setTeleportedModeFreespeedFactor(String mode, double freespeedFactor) {
        this.testForLocked();
        ModeRoutingParams pars = new ModeRoutingParams(mode);
        pars.setTeleportedModeFreespeedFactor(freespeedFactor);
        this.addParameterSet(pars);
    }

    public void setTeleportedModeSpeed(String mode, double speed) {
        this.testForLocked();
        ModeRoutingParams pars = new ModeRoutingParams(mode);
        pars.setTeleportedModeSpeed(speed);
        this.addParameterSet(pars);
    }

    @Deprecated
    public void setBeelineDistanceFactor(double val) {
        this.testForLocked();
        this.beelineDistanceFactor = val;
        for (ModeRoutingParams params : this.getModeRoutingParams().values()) {
            params.setBeelineDistanceFactor(val);
        }
    }

    public boolean isInsertingAccessEgressWalk() {
        return this.insertingAccessEgressWalk;
    }

    public void setInsertingAccessEgressWalk(boolean val) {
        this.insertingAccessEgressWalk = val;
    }

    @ReflectiveConfigGroup.StringGetter(value="routingRandomness")
    public double getRoutingRandomness() {
        return this.routingRandomness;
    }

    @ReflectiveConfigGroup.StringSetter(value="routingRandomness")
    public void setRoutingRandomness(double routingRandomness) {
        this.routingRandomness = routingRandomness;
    }

    @Override
    protected void checkConsistency(Config config) {
        super.checkConsistency(config);
        Set<String> modesRoutedAsTeleportation = this.getModeRoutingParams().keySet();
        Collection<String> modesRoutedAsNetworkModes = this.getNetworkModes();
        for (String mode : modesRoutedAsTeleportation) {
            if (!modesRoutedAsNetworkModes.contains(mode)) continue;
            throw new RuntimeException("mode \"" + mode + "\" is defined both as teleportation (mode routing param) and for network routing.  You need to remove " + "one or the other.");
        }
    }

    public void printModeRoutingParams() {
        for (Map.Entry<String, ModeRoutingParams> entry : this.getModeRoutingParams().entrySet()) {
            log.warn("key=" + entry.getKey() + "; value=" + entry.getValue());
        }
    }

    public static class ModeRoutingParams
    extends ReflectiveConfigGroup
    implements MatsimParameters {
        public static final String SET_TYPE = "teleportedModeParameters";
        public static final String MODE = "mode";
        public static final String TELEPORTED_MODE_FREESPEED_FACTOR = "teleportedModeFreespeedFactor";
        private String mode = null;
        private Double teleportedModeSpeed = null;
        private Double beelineDistanceFactorForMode = null;
        private Double teleportedModeFreespeedFactor = null;
        private Double teleportedModeFreespeedLimit = Double.POSITIVE_INFINITY;
        private static final String TELEPORTED_MODE_FREESPEED_FACTOR_CMT = "Free-speed factor for a teleported mode. Travel time = teleportedModeFreespeedFactor * <freespeed car travel time>. Insert a line like this for every such mode. Please do not set teleportedModeFreespeedFactor as well as teleportedModeSpeed for the same mode, but if you do, +teleportedModeFreespeedFactor wins over teleportedModeSpeed.";
        static final String TELEPORTED_MODE_FREESPEED_LIMIT_CMT = "When using freespeed factor, a speed limit on the free speed. Link travel time will be $= factor * [ min( link_freespeed, freespeed_limit) ]";

        public ModeRoutingParams(String mode) {
            super(SET_TYPE);
            this.setMode(mode);
        }

        public ModeRoutingParams() {
            super(SET_TYPE);
        }

        @Override
        public void checkConsistency(Config config) {
            if (this.mode == null) {
                throw new RuntimeException("mode for parameter set " + this + " is null!");
            }
            if (this.teleportedModeSpeed == null && this.teleportedModeFreespeedFactor == null) {
                throw new RuntimeException("no teleported mode speed nor freespeed factor defined for mode " + this.mode);
            }
            if (this.teleportedModeSpeed != null && this.teleportedModeFreespeedFactor != null) {
                throw new RuntimeException("both teleported mode speed or freespeed factor are set for mode " + this.mode);
            }
        }

        @Override
        public Map<String, String> getComments() {
            Map<String, String> map = super.getComments();
            map.put("teleportedModeSpeed", "Speed for a teleported mode. Travel time = (<beeline distance> * beelineDistanceFactor) / teleportedModeSpeed. Insert a line like this for every such mode.");
            map.put(TELEPORTED_MODE_FREESPEED_FACTOR, TELEPORTED_MODE_FREESPEED_FACTOR_CMT);
            return map;
        }

        public final Double getTeleportedModeFreespeedLimit() {
            return this.teleportedModeFreespeedLimit;
        }

        public final ModeRoutingParams setTeleportedModeFreespeedLimit(Double teleportedModeFreespeedLimit) {
            this.teleportedModeFreespeedLimit = teleportedModeFreespeedLimit;
            return this;
        }

        @ReflectiveConfigGroup.StringGetter(value="mode")
        public String getMode() {
            return this.mode;
        }

        @ReflectiveConfigGroup.StringSetter(value="mode")
        public ModeRoutingParams setMode(String mode) {
            this.testForLocked();
            this.mode = mode;
            return this;
        }

        @ReflectiveConfigGroup.StringGetter(value="teleportedModeSpeed")
        public Double getTeleportedModeSpeed() {
            return this.teleportedModeSpeed;
        }

        @ReflectiveConfigGroup.StringSetter(value="teleportedModeSpeed")
        public ModeRoutingParams setTeleportedModeSpeed(Double teleportedModeSpeed) {
            this.testForLocked();
            if (this.getTeleportedModeFreespeedFactor() != null && teleportedModeSpeed != null) {
                throw new IllegalStateException("cannot set both speed and freespeed factor for " + this.getMode());
            }
            this.teleportedModeSpeed = teleportedModeSpeed;
            return this;
        }

        @ReflectiveConfigGroup.StringGetter(value="teleportedModeFreespeedFactor")
        public Double getTeleportedModeFreespeedFactor() {
            return this.teleportedModeFreespeedFactor;
        }

        @ReflectiveConfigGroup.StringSetter(value="teleportedModeFreespeedFactor")
        public ModeRoutingParams setTeleportedModeFreespeedFactor(Double teleportedModeFreespeedFactor) {
            this.testForLocked();
            if (this.getTeleportedModeSpeed() != null && teleportedModeFreespeedFactor != null) {
                throw new IllegalStateException("cannot set both speed and freespeed factor for " + this.getMode());
            }
            this.teleportedModeFreespeedFactor = teleportedModeFreespeedFactor;
            return this;
        }

        @ReflectiveConfigGroup.StringSetter(value="beelineDistanceFactor")
        public ModeRoutingParams setBeelineDistanceFactor(Double val) {
            this.testForLocked();
            this.beelineDistanceFactorForMode = val;
            return this;
        }

        @ReflectiveConfigGroup.StringGetter(value="beelineDistanceFactor")
        public Double getBeelineDistanceFactor() {
            return this.beelineDistanceFactorForMode;
        }
    }
}

