/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.config.groups;

import java.net.URL;
import java.util.Map;
import org.apache.log4j.Logger;
import org.matsim.core.config.ConfigGroup;
import org.matsim.core.config.ReflectiveConfigGroup;

public final class PlansConfigGroup
extends ReflectiveConfigGroup {
    public static final String GROUP_NAME = "plans";
    private static final String INPUT_FILE = "inputPlansFile";
    private static final String INPUT_PERSON_ATTRIBUTES_FILE = "inputPersonAttributesFile";
    private static final String NETWORK_ROUTE_TYPE = "networkRouteType";
    private static final String SUBPOPULATION_ATTRIBUTE = "subpopulationAttributeName";
    private static final String INPUT_CRS = "inputCRS";
    private String inputFile = null;
    private String networkRouteType = "LinkNetworkRoute";
    private String inputPersonAttributeFile = null;
    private String subpopulationAttributeName = "subpopulation";
    private String inputCRS = null;
    private static final String ACTIVITY_DURATION_INTERPRETATION = "activityDurationInterpretation";
    private ActivityDurationInterpretation activityDurationInterpretation = ActivityDurationInterpretation.tryEndTimeThenDuration;
    private boolean insistingOnUsingDeprecatedPersonAttributeFile = false;
    private static final String INSISTING_ON_USING_DEPRECATED_PERSON_ATTRIBUTE_FILE = "insistingOnUsingDeprecatedPersonAttributeFile";
    public static final String MESSAGE = "using the separate person attribute file is deprecated.  Add the information directly into each person, using the Attributable feature.  If you insist on continuing to use the separate person attribute file, set insistingOnUsingDeprecatedPersonAttributeFile to true.  The file will then be read, but the values will be entered into each person using Attributable, and written as such to output_plans.  kai, may'19";
    private static final String REMOVING_UNNECESSARY_PLAN_ATTRIBUTES = "removingUnnecessaryPlanAttributes";
    private boolean removingUnneccessaryPlanAttributes = false;

    public PlansConfigGroup() {
        super(GROUP_NAME);
    }

    @Override
    public Map<String, String> getComments() {
        Map<String, String> comments = super.getComments();
        comments.put(NETWORK_ROUTE_TYPE, "Defines how routes are stored in memory. Currently supported: LinkNetworkRoute, CompressedNetworkRoute.");
        comments.put(SUBPOPULATION_ATTRIBUTE, "Name of the (Object)Attribute defining the subpopulation to which pertains a Person (as freight, through traffic, etc.). The attribute must be of String type.  Change away from default only in desperate situations.");
        StringBuilder str = new StringBuilder();
        for (ActivityDurationInterpretation itp : ActivityDurationInterpretation.values()) {
            str.append(" ").append(itp.toString());
        }
        comments.put(ACTIVITY_DURATION_INTERPRETATION, "String:" + str + ". Anything besides " + (Object)((Object)ActivityDurationInterpretation.minOfDurationAndEndTime) + " will internally use a different " + "(simpler) version of the TimeAllocationMutator.");
        comments.put(REMOVING_UNNECESSARY_PLAN_ATTRIBUTES, "(not tested) will remove plan attributes that are presumably not used, such as activityStartTime. default=false. Use with Caution!");
        comments.put(INPUT_CRS, "The Coordinates Reference System in which the coordinates are expressed in the input file. At import, the coordinates will be converted to the coordinate system defined in \"global\", and willbe converted back at export. If not specified, no conversion happens.");
        return comments;
    }

    @ReflectiveConfigGroup.StringGetter(value="inputPlansFile")
    public String getInputFile() {
        return this.inputFile;
    }

    @ReflectiveConfigGroup.StringSetter(value="inputPlansFile")
    public void setInputFile(String inputFile) {
        this.inputFile = inputFile;
    }

    public URL getInputFileURL(URL context) {
        return ConfigGroup.getInputFileURL(context, this.inputFile);
    }

    @ReflectiveConfigGroup.StringSetter(value="insistingOnUsingDeprecatedPersonAttributeFile")
    public final void setInsistingOnUsingDeprecatedPersonAttributeFile(boolean val) {
        this.insistingOnUsingDeprecatedPersonAttributeFile = val;
    }

    @ReflectiveConfigGroup.StringGetter(value="insistingOnUsingDeprecatedPersonAttributeFile")
    public final boolean isInsistingOnUsingDeprecatedPersonAttributeFile() {
        return this.insistingOnUsingDeprecatedPersonAttributeFile;
    }

    @ReflectiveConfigGroup.StringGetter(value="inputPersonAttributesFile")
    @Deprecated
    public String getInputPersonAttributeFile() {
        return this.inputPersonAttributeFile;
    }

    @ReflectiveConfigGroup.StringSetter(value="inputPersonAttributesFile")
    @Deprecated
    public void setInputPersonAttributeFile(String inputPersonAttributeFile) {
        this.inputPersonAttributeFile = inputPersonAttributeFile;
    }

    @Deprecated
    public URL getInputPersonAttributeFileURL(URL context) {
        return ConfigGroup.getInputFileURL(context, this.inputPersonAttributeFile);
    }

    @ReflectiveConfigGroup.StringGetter(value="networkRouteType")
    public String getNetworkRouteType() {
        return this.networkRouteType;
    }

    @ReflectiveConfigGroup.StringSetter(value="networkRouteType")
    public void setNetworkRouteType(String routeType) {
        this.networkRouteType = routeType;
    }

    @ReflectiveConfigGroup.StringGetter(value="subpopulationAttributeName")
    public String getSubpopulationAttributeName() {
        return this.subpopulationAttributeName;
    }

    @ReflectiveConfigGroup.StringSetter(value="subpopulationAttributeName")
    public void setSubpopulationAttributeName(String subpopulationAttributeName) {
        this.subpopulationAttributeName = subpopulationAttributeName;
    }

    @ReflectiveConfigGroup.StringGetter(value="activityDurationInterpretation")
    public ActivityDurationInterpretation getActivityDurationInterpretation() {
        return this.activityDurationInterpretation;
    }

    @ReflectiveConfigGroup.StringSetter(value="activityDurationInterpretation")
    public void setActivityDurationInterpretation(ActivityDurationInterpretation actDurInterpret) {
        if (ActivityDurationInterpretation.endTimeOnly.equals((Object)actDurInterpret)) {
            Logger.getLogger(this.getClass()).warn("You are using " + (Object)((Object)actDurInterpret) + " as activityDurationInterpretation. " + "This is not working in conjunction with the pt module as pt interaction activities then will never end!");
            Logger.getLogger(this.getClass()).warn("ActivityDurationInterpreation " + (Object)((Object)actDurInterpret) + " is deprecated; use " + (Object)((Object)ActivityDurationInterpretation.minOfDurationAndEndTime) + " instead. kai, jan'13");
        }
        this.activityDurationInterpretation = actDurInterpret;
    }

    @ReflectiveConfigGroup.StringGetter(value="removingUnnecessaryPlanAttributes")
    public boolean isRemovingUnneccessaryPlanAttributes() {
        return this.removingUnneccessaryPlanAttributes;
    }

    @ReflectiveConfigGroup.StringSetter(value="removingUnnecessaryPlanAttributes")
    public void setRemovingUnneccessaryPlanAttributes(boolean removingUnneccessaryPlanAttributes) {
        this.removingUnneccessaryPlanAttributes = removingUnneccessaryPlanAttributes;
    }

    @ReflectiveConfigGroup.StringGetter(value="inputCRS")
    public String getInputCRS() {
        return this.inputCRS;
    }

    @ReflectiveConfigGroup.StringSetter(value="inputCRS")
    public void setInputCRS(String inputCRS) {
        this.inputCRS = inputCRS;
    }

    public static enum ActivityDurationInterpretation {
        minOfDurationAndEndTime,
        tryEndTimeThenDuration,
        endTimeOnly;

    }

    public static abstract class NetworkRouteType {
        public static final String LinkNetworkRoute = "LinkNetworkRoute";
        public static final String CompressedNetworkRoute = "CompressedNetworkRoute";
    }
}

