/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.config.groups;

import java.util.Map;
import org.matsim.core.config.ReflectiveConfigGroup;

public final class PtCountsConfigGroup
extends ReflectiveConfigGroup {
    public static final String GROUP_NAME = "ptCounts";
    private static final String OUTPUTFORMAT = "outputformat";
    private static final String DISTANCEFILTER = "distanceFilter";
    private static final String DISTANCEFILTERCENTERNODE = "distanceFilterCenterNode";
    private static final String OCCUPANCY_COUNTS_INPUT_FILENAME = "inputOccupancyCountsFile";
    private static final String BOARD_COUNTS_INPUT_FILENAME = "inputBoardCountsFile";
    private static final String ALIGHT_COUNTS_INPUT_FILENAME = "inputAlightCountsFile";
    private static final String COUNTSSCALEFACTOR = "countsScaleFactor";
    private static final String PT_COUNTS_INTERVAL = "ptCountsInterval";
    private String outputFormat;
    private Double distanceFilter;
    private String distanceFilterCenterNode;
    private String occupancyCountsFileName = null;
    private String boardCountsFileName = null;
    private String alightCountsFileName = null;
    private double countsScaleFactor = 1.0;
    private int ptCountsInterval = 10;

    public PtCountsConfigGroup() {
        super(GROUP_NAME);
    }

    @Override
    public Map<String, String> getComments() {
        Map<String, String> comments = super.getComments();
        comments.put(OUTPUTFORMAT, "possible values: `html', `kml', `txt', `all'");
        comments.put(DISTANCEFILTER, "distance to distanceFilterCenterNode to include counting stations. The unit of distance is the Euclidean distance implied by the coordinate system");
        comments.put(DISTANCEFILTERCENTERNODE, "node id for center node of distance filter");
        comments.put(OCCUPANCY_COUNTS_INPUT_FILENAME, "input file containing the occupancy counts for pt");
        comments.put(ALIGHT_COUNTS_INPUT_FILENAME, "input file containing the alighting (getting off) counts for pt");
        comments.put(BOARD_COUNTS_INPUT_FILENAME, "input file containing the boarding (getting on) counts for pt");
        comments.put(COUNTSSCALEFACTOR, "factor by which to re-scale the simulated values.  necessary when simulation runs with something different from 100%.  needs to be adapted manually");
        comments.put(PT_COUNTS_INTERVAL, "every how many iterations (starting with 0) counts comparisons are generated");
        return comments;
    }

    @ReflectiveConfigGroup.StringGetter(value="outputformat")
    public String getOutputFormat() {
        return this.outputFormat;
    }

    @ReflectiveConfigGroup.StringSetter(value="outputformat")
    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    @ReflectiveConfigGroup.StringGetter(value="distanceFilter")
    public Double getDistanceFilter() {
        return this.distanceFilter;
    }

    @ReflectiveConfigGroup.StringSetter(value="distanceFilter")
    public void setDistanceFilter(Double distanceFilter) {
        this.distanceFilter = distanceFilter;
    }

    @ReflectiveConfigGroup.StringGetter(value="distanceFilterCenterNode")
    public String getDistanceFilterCenterNode() {
        return this.distanceFilterCenterNode;
    }

    @ReflectiveConfigGroup.StringSetter(value="distanceFilterCenterNode")
    public void setDistanceFilterCenterNode(String distanceFilterCenterNode) {
        this.distanceFilterCenterNode = distanceFilterCenterNode;
    }

    @ReflectiveConfigGroup.StringGetter(value="inputOccupancyCountsFile")
    public String getOccupancyCountsFileName() {
        return this.occupancyCountsFileName;
    }

    @ReflectiveConfigGroup.StringSetter(value="inputOccupancyCountsFile")
    public void setOccupancyCountsFileName(String occupancyCountsFileName) {
        this.occupancyCountsFileName = occupancyCountsFileName;
    }

    @ReflectiveConfigGroup.StringGetter(value="inputBoardCountsFile")
    public String getBoardCountsFileName() {
        return this.boardCountsFileName;
    }

    @ReflectiveConfigGroup.StringSetter(value="inputBoardCountsFile")
    public void setBoardCountsFileName(String boardCountsFileName) {
        this.boardCountsFileName = boardCountsFileName;
    }

    @ReflectiveConfigGroup.StringGetter(value="inputAlightCountsFile")
    public String getAlightCountsFileName() {
        return this.alightCountsFileName;
    }

    @ReflectiveConfigGroup.StringSetter(value="inputAlightCountsFile")
    public void setAlightCountsFileName(String alightCountsFileName) {
        this.alightCountsFileName = alightCountsFileName;
    }

    @ReflectiveConfigGroup.StringGetter(value="countsScaleFactor")
    public double getCountsScaleFactor() {
        return this.countsScaleFactor;
    }

    @ReflectiveConfigGroup.StringSetter(value="countsScaleFactor")
    public void setCountsScaleFactor(double countsScaleFactor) {
        this.countsScaleFactor = countsScaleFactor;
    }

    @ReflectiveConfigGroup.StringGetter(value="ptCountsInterval")
    public int getPtCountsInterval() {
        return this.ptCountsInterval;
    }

    @ReflectiveConfigGroup.StringSetter(value="ptCountsInterval")
    public void setPtCountsInterval(int ptCountsInterval) {
        this.ptCountsInterval = ptCountsInterval;
    }
}

