/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.config.groups;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.validation.constraints.Positive;
import javax.validation.constraints.PositiveOrZero;
import org.apache.log4j.Logger;
import org.matsim.core.config.ReflectiveConfigGroup;
import org.matsim.core.utils.collections.CollectionUtils;
import org.matsim.core.utils.misc.Time;

public final class QSimConfigGroup
extends ReflectiveConfigGroup {
    private static final Logger log = Logger.getLogger(QSimConfigGroup.class);
    public static final String GROUP_NAME = "qsim";
    private static final String START_TIME = "startTime";
    private static final String END_TIME = "endTime";
    private static final String TIME_STEP_SIZE = "timeStepSize";
    private static final String SNAPSHOT_PERIOD = "snapshotperiod";
    private static final String FLOW_CAPACITY_FACTOR = "flowCapacityFactor";
    private static final String STORAGE_CAPACITY_FACTOR = "storageCapacityFactor";
    private static final String STUCK_TIME = "stuckTime";
    private static final String REMOVE_STUCK_VEHICLES = "removeStuckVehicles";
    private static final String NUMBER_OF_THREADS = "numberOfThreads";
    private static final String TRAFFIC_DYNAMICS = "trafficDynamics";
    private static final String SIM_STARTTIME_INTERPRETATION = "simStarttimeInterpretation";
    private static final String USE_PERSON_ID_FOR_MISSING_VEHICLE_ID = "usePersonIdForMissingVehicleId";
    private static final String SIM_ENDTIME_INTERPRETATION = "simEndtimeInterpretation";
    private static final String NODE_OFFSET = "nodeOffset";
    private double startTime = Time.getUndefinedTime();
    private double endTime = Time.getUndefinedTime();
    @Positive
    private double timeStepSize = 1.0;
    @PositiveOrZero
    private double snapshotPeriod = 0.0;
    @Positive
    private double flowCapFactor = 1.0;
    @Positive
    private double storageCapFactor = 1.0;
    @Positive
    private double stuckTime = 10.0;
    private boolean removeStuckVehicles = false;
    private boolean usePersonIdForMissingVehicleId = true;
    @Positive
    private int numberOfThreads = 1;
    private TrafficDynamics trafficDynamics = TrafficDynamics.queue;
    private StarttimeInterpretation simStarttimeInterpretation = StarttimeInterpretation.maxOfStarttimeAndEarliestActivityEnd;
    private double pcuThresholdForFlowCapacityEasing = 0.0;
    private static final String VEHICLE_BEHAVIOR = "vehicleBehavior";
    private VehicleBehavior vehicleBehavior = VehicleBehavior.teleport;
    private static final String SNAPSHOT_STYLE = "snapshotStyle";
    private SnapshotStyle snapshotStyle = SnapshotStyle.equiDist;
    private static final String MAIN_MODE = "mainMode";
    private Collection<String> mainModes = Arrays.asList("car");
    private LinkDynamics linkDynamics = LinkDynamics.FIFO;
    private static final String LINK_DYNAMICS = "linkDynamics";
    private double nodeOffset = 0.0;
    private float linkWidth = 30.0f;
    private boolean usingThreadpool = true;
    public static final String LINK_WIDTH = "linkWidth";
    private static final String FAST_CAPACITY_UPDATE = "usingFastCapacityUpdate";
    private boolean usingFastCapacityUpdate = true;
    private static final String VEHICLES_SOURCE = "vehiclesSource";
    private VehiclesSource vehiclesSource = VehiclesSource.defaultVehicle;
    private static final String IS_SEEP_MODE_STORAGE_FREE = "isSeepModeStorageFree";
    private boolean isSeepModeStorageFree = false;
    private EndtimeInterpretation simEndtimeInterpretation;
    static final String REMOVE_STUCK_VEHICLES_STRING = "Boolean. `true': stuck vehicles are removed, aborting the plan; `false': stuck vehicles are forced into the next link. `false' is probably the better choice.";
    static final String STUCK_TIME_STRING = "time in seconds.  Time after which the frontmost vehicle on a link is called `stuck' if it does not move.";
    private static final String INSERTING_WAITING_VEHICLES_BEFORE_DRIVING_VEHICLES = "insertingWaitingVehiclesBeforeDrivingVehicles";
    private static final String INSERTING_WAITING_VEHICLES_BEFORE_DRIVING_VEHICLES_CMT = "decides if waiting vehicles enter the network after or before the already driving vehicles were moved. Default: false";
    private boolean insertingWaitingVehiclesBeforeDrivingVehicles = true;
    private static final String USING_THREADPOOL = "usingThreadpool";
    private static final String USE_LANES = "useLanes";
    private boolean useLanes = false;
    private static final String SEEP_MODE = "seepMode";
    private Collection<String> seepModes = Arrays.asList("bike");
    private static final String IS_RESTRICTING_SEEPAGE = "isRestrictingSeepage";
    private boolean isRestrictingSeepage = true;
    private boolean usingTravelTimeCheckInTeleportation = false;
    static final String PCU_THRESHOLD_FOR_FLOW_CAPACITY_EASING = "Flow capacity easing is activated for vehicles of size equal or smaller than the specified threshold. Introduced to minimise the chances of buses being severely delayed in downsampled scenarios";

    public QSimConfigGroup() {
        super(GROUP_NAME);
    }

    @ReflectiveConfigGroup.StringSetter(value="mainMode")
    private void setMainModes(String value) {
        this.setMainModes(Arrays.asList(value.split(",")));
    }

    @ReflectiveConfigGroup.StringSetter(value="snapshotperiod")
    private void setSnapshotPeriod(String value) {
        this.setSnapshotPeriod(Time.parseTime(value));
    }

    @ReflectiveConfigGroup.StringSetter(value="timeStepSize")
    private void setTimeStepSize(String value) {
        this.setTimeStepSize(Time.parseTime(value));
    }

    @ReflectiveConfigGroup.StringSetter(value="endTime")
    private void setEndTime(String value) {
        this.setEndTime(Time.parseTime(value));
    }

    @ReflectiveConfigGroup.StringSetter(value="startTime")
    private void setStartTime(String value) {
        this.setStartTime(Time.parseTime(value));
    }

    @ReflectiveConfigGroup.StringGetter(value="mainMode")
    private String getMainModesAsString() {
        return CollectionUtils.setToString(new HashSet<String>(this.getMainModes()));
    }

    @ReflectiveConfigGroup.StringGetter(value="snapshotperiod")
    private String getSnapshotPeriodAsString() {
        return Time.writeTime(this.getSnapshotPeriod());
    }

    @ReflectiveConfigGroup.StringGetter(value="timeStepSize")
    private String getTimeStepSizeAsString() {
        return Time.writeTime(this.getTimeStepSize());
    }

    @ReflectiveConfigGroup.StringGetter(value="endTime")
    private String getEndTimeAsString() {
        return Time.writeTime(this.getEndTime());
    }

    @ReflectiveConfigGroup.StringGetter(value="startTime")
    private String getStartTimeAsString() {
        return Time.writeTime(this.getStartTime());
    }

    @Override
    public final Map<String, String> getComments() {
        Map<String, String> map = super.getComments();
        StringBuilder options = new StringBuilder();
        for (SnapshotStyle snapshotStyle : SnapshotStyle.values()) {
            options.append(snapshotStyle.toString());
            options.append(' ');
        }
        map.put(SNAPSHOT_STYLE, "snapshotStyle. One of: " + options.toString());
        map.put(NUMBER_OF_THREADS, "Number of threads used for the QSim.  Note that this setting is independent from the \"global\" threads setting.  In contrast to earlier versions, the non-parallel special version is no longer there.");
        map.put(REMOVE_STUCK_VEHICLES, REMOVE_STUCK_VEHICLES_STRING);
        map.put(STUCK_TIME, STUCK_TIME_STRING);
        options = new StringBuilder(60);
        for (Enum enum_ : TrafficDynamics.values()) {
            options.append(enum_).append(' ');
        }
        map.put(TRAFFIC_DYNAMICS, "options: " + options.toString());
        options = new StringBuilder(60);
        for (Enum enum_ : StarttimeInterpretation.values()) {
            options.append(enum_).append(' ');
        }
        map.put(SIM_STARTTIME_INTERPRETATION, "Options: " + options);
        options = new StringBuilder(60);
        for (Enum enum_ : VehicleBehavior.values()) {
            options.append(enum_).append(' ');
        }
        map.put(VEHICLE_BEHAVIOR, "Defines what happens if an agent wants to depart, but the specified vehicle is not available. One of: " + options);
        map.put(MAIN_MODE, "[comma-separated list] Defines which modes are congested modes. Technically, these are the modes that the departure handler of the netsimengine handles.  Effective cell size, effective lane width, flow capacity factor, and storage capacity factor need to be set with diligence.  Need to be vehicular modes to make sense.");
        map.put(INSERTING_WAITING_VEHICLES_BEFORE_DRIVING_VEHICLES, INSERTING_WAITING_VEHICLES_BEFORE_DRIVING_VEHICLES_CMT);
        map.put(NODE_OFFSET, "Shortens a link in the visualization, i.e. its start and end point are moved into towards the center. Does not affect traffic flow. ");
        map.put(LINK_WIDTH, "The (initial) width of the links of the network. Use positive floating point values. This is used only for visualisation.");
        StringBuilder stb = new StringBuilder();
        for (Enum enum_ : LinkDynamics.values()) {
            stb.append(" ").append(enum_.toString());
        }
        map.put(LINK_DYNAMICS, "default: FIFO; options:" + stb);
        map.put(USE_PERSON_ID_FOR_MISSING_VEHICLE_ID, "If a route does not reference a vehicle, agents will use the vehicle with the same id as their own.");
        map.put(USING_THREADPOOL, "if the qsim should use as many runners as there are threads (Christoph's dissertation version) or more of them, together with a thread pool (seems to be faster in some situations, but is not tested).");
        map.put(FAST_CAPACITY_UPDATE, "If false, the qsim accumulates fractional flows up to one flow unit in every time step.  If true, flows are updated only if an agent wants to enter the link or an agent is added to buffer. Default is true.");
        map.put(USE_LANES, "Set this parameter to true if lanes should be used, false if not.");
        stb = new StringBuilder();
        for (Enum enum_ : VehiclesSource.values()) {
            stb.append(" ").append(enum_.toString());
        }
        map.put(VEHICLES_SOURCE, "If vehicles should all be the same default vehicle, or come from the vehicles file, or something else.  Possible values: " + stb);
        map.put(SEEP_MODE, "If link dynamics is set as " + (Object)((Object)LinkDynamics.SeepageQ) + ", set a seep mode. Default is bike.");
        map.put(IS_SEEP_MODE_STORAGE_FREE, "If link dynamics is set as " + (Object)((Object)LinkDynamics.SeepageQ) + ", set to true if seep mode do not consumes any space on the link. Default is false.");
        map.put(IS_RESTRICTING_SEEPAGE, "If link dynamics is set as " + (Object)((Object)LinkDynamics.SeepageQ) + ", set to false if all seep modes should perform seepage. Default is true (better option).");
        return map;
    }

    @ReflectiveConfigGroup.StringSetter(value="usingFastCapacityUpdate")
    public final void setUsingFastCapacityUpdate(boolean val) {
        this.usingFastCapacityUpdate = val;
    }

    @ReflectiveConfigGroup.StringGetter(value="usingFastCapacityUpdate")
    public final boolean isUsingFastCapacityUpdate() {
        return this.usingFastCapacityUpdate;
    }

    public void setStartTime(double startTime) {
        this.startTime = startTime;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public void setEndTime(double endTime) {
        this.endTime = endTime;
    }

    public double getEndTime() {
        return this.endTime;
    }

    public void setTimeStepSize(double seconds) {
        if (seconds != 1.0) {
            Logger.getLogger(this.getClass()).warn("there are nearly no tests for time step size != 1.0.  Please write such tests and remove this warning. ");
        }
        this.timeStepSize = seconds;
    }

    public double getTimeStepSize() {
        return this.timeStepSize;
    }

    public void setSnapshotPeriod(double snapshotPeriod) {
        this.snapshotPeriod = snapshotPeriod;
    }

    public double getSnapshotPeriod() {
        return this.snapshotPeriod;
    }

    @ReflectiveConfigGroup.StringSetter(value="flowCapacityFactor")
    public void setFlowCapFactor(double flowCapFactor) {
        this.flowCapFactor = flowCapFactor;
    }

    @ReflectiveConfigGroup.StringGetter(value="flowCapacityFactor")
    public double getFlowCapFactor() {
        return this.flowCapFactor;
    }

    @ReflectiveConfigGroup.StringSetter(value="storageCapacityFactor")
    public void setStorageCapFactor(double val) {
        this.storageCapFactor = val;
    }

    @ReflectiveConfigGroup.StringGetter(value="storageCapacityFactor")
    public double getStorageCapFactor() {
        return this.storageCapFactor;
    }

    @ReflectiveConfigGroup.StringSetter(value="stuckTime")
    public void setStuckTime(double stuckTime) {
        this.stuckTime = stuckTime;
    }

    @ReflectiveConfigGroup.StringGetter(value="stuckTime")
    public double getStuckTime() {
        return this.stuckTime;
    }

    @ReflectiveConfigGroup.StringSetter(value="removeStuckVehicles")
    public void setRemoveStuckVehicles(boolean removeStuckVehicles) {
        this.removeStuckVehicles = removeStuckVehicles;
    }

    @ReflectiveConfigGroup.StringGetter(value="removeStuckVehicles")
    public boolean isRemoveStuckVehicles() {
        return this.removeStuckVehicles;
    }

    @ReflectiveConfigGroup.StringSetter(value="snapshotStyle")
    public void setSnapshotStyle(SnapshotStyle style) {
        this.snapshotStyle = style;
    }

    @ReflectiveConfigGroup.StringGetter(value="snapshotStyle")
    public SnapshotStyle getSnapshotStyle() {
        return this.snapshotStyle;
    }

    @ReflectiveConfigGroup.StringSetter(value="trafficDynamics")
    public void setTrafficDynamics(TrafficDynamics str) {
        this.trafficDynamics = str;
    }

    @ReflectiveConfigGroup.StringGetter(value="trafficDynamics")
    public TrafficDynamics getTrafficDynamics() {
        return this.trafficDynamics;
    }

    @ReflectiveConfigGroup.StringGetter(value="numberOfThreads")
    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    @ReflectiveConfigGroup.StringSetter(value="numberOfThreads")
    public void setNumberOfThreads(int numberOfThreads) {
        if (numberOfThreads < 1) {
            throw new IllegalArgumentException("Number of threads must be strictly positive, got " + numberOfThreads);
        }
        this.numberOfThreads = numberOfThreads;
    }

    @ReflectiveConfigGroup.StringGetter(value="simStarttimeInterpretation")
    public StarttimeInterpretation getSimStarttimeInterpretation() {
        return this.simStarttimeInterpretation;
    }

    @ReflectiveConfigGroup.StringSetter(value="simStarttimeInterpretation")
    public void setSimStarttimeInterpretation(StarttimeInterpretation str) {
        this.simStarttimeInterpretation = str;
    }

    @ReflectiveConfigGroup.StringGetter(value="simEndtimeInterpretation")
    public EndtimeInterpretation getSimEndtimeInterpretation() {
        return this.simEndtimeInterpretation;
    }

    @ReflectiveConfigGroup.StringSetter(value="simEndtimeInterpretation")
    public void setSimEndtimeInterpretation(EndtimeInterpretation str) {
        this.simEndtimeInterpretation = str;
    }

    @ReflectiveConfigGroup.StringSetter(value="vehicleBehavior")
    public void setVehicleBehavior(VehicleBehavior value) {
        this.vehicleBehavior = value;
    }

    @ReflectiveConfigGroup.StringGetter(value="vehicleBehavior")
    public VehicleBehavior getVehicleBehavior() {
        return this.vehicleBehavior;
    }

    public void setMainModes(Collection<String> mainModes) {
        this.mainModes = mainModes;
    }

    public Collection<String> getMainModes() {
        return this.mainModes;
    }

    @ReflectiveConfigGroup.StringGetter(value="insertingWaitingVehiclesBeforeDrivingVehicles")
    public boolean isInsertingWaitingVehiclesBeforeDrivingVehicles() {
        return this.insertingWaitingVehiclesBeforeDrivingVehicles;
    }

    @ReflectiveConfigGroup.StringSetter(value="insertingWaitingVehiclesBeforeDrivingVehicles")
    public void setInsertingWaitingVehiclesBeforeDrivingVehicles(boolean val) {
        this.insertingWaitingVehiclesBeforeDrivingVehicles = val;
    }

    @ReflectiveConfigGroup.StringGetter(value="nodeOffset")
    public double getNodeOffset() {
        return this.nodeOffset;
    }

    @ReflectiveConfigGroup.StringSetter(value="nodeOffset")
    public void setNodeOffset(double nodeOffset) {
        this.nodeOffset = nodeOffset;
    }

    @ReflectiveConfigGroup.StringGetter(value="linkWidth")
    public float getLinkWidthForVis() {
        return this.linkWidth;
    }

    @ReflectiveConfigGroup.StringSetter(value="linkWidth")
    public void setLinkWidthForVis(float linkWidth) {
        this.linkWidth = linkWidth;
    }

    @ReflectiveConfigGroup.StringGetter(value="linkDynamics")
    public LinkDynamics getLinkDynamics() {
        return this.linkDynamics;
    }

    @ReflectiveConfigGroup.StringSetter(value="linkDynamics")
    public void setLinkDynamics(LinkDynamics linkDynamics) {
        this.linkDynamics = linkDynamics;
    }

    @ReflectiveConfigGroup.StringGetter(value="usePersonIdForMissingVehicleId")
    public boolean getUsePersonIdForMissingVehicleId() {
        return this.usePersonIdForMissingVehicleId;
    }

    @ReflectiveConfigGroup.StringSetter(value="usePersonIdForMissingVehicleId")
    public void setUsePersonIdForMissingVehicleId(boolean value) {
        this.usePersonIdForMissingVehicleId = value;
    }

    @ReflectiveConfigGroup.StringSetter(value="vehiclesSource")
    public final void setVehiclesSource(VehiclesSource source) {
        this.testForLocked();
        this.vehiclesSource = source;
    }

    @ReflectiveConfigGroup.StringGetter(value="vehiclesSource")
    public final VehiclesSource getVehiclesSource() {
        return this.vehiclesSource;
    }

    @ReflectiveConfigGroup.StringGetter(value="usingThreadpool")
    public boolean isUsingThreadpool() {
        return this.usingThreadpool;
    }

    @ReflectiveConfigGroup.StringSetter(value="usingThreadpool")
    public void setUsingThreadpool(boolean val) {
        this.usingThreadpool = val;
    }

    @ReflectiveConfigGroup.StringGetter(value="useLanes")
    public boolean isUseLanes() {
        return this.useLanes;
    }

    @ReflectiveConfigGroup.StringSetter(value="useLanes")
    public void setUseLanes(boolean useLanes) {
        this.useLanes = useLanes;
    }

    @ReflectiveConfigGroup.StringGetter(value="seepMode")
    private String getSeepModesAsString() {
        return CollectionUtils.setToString(new HashSet<String>(this.getSeepModes()));
    }

    @ReflectiveConfigGroup.StringSetter(value="seepMode")
    private void setSeepModes(String value) {
        this.setSeepModes(Arrays.asList(value.split(",")));
    }

    public Collection<String> getSeepModes() {
        return this.seepModes;
    }

    public void setSeepModes(Collection<String> seepModes) {
        this.seepModes = seepModes;
    }

    @ReflectiveConfigGroup.StringGetter(value="isSeepModeStorageFree")
    public boolean isSeepModeStorageFree() {
        return this.isSeepModeStorageFree;
    }

    @ReflectiveConfigGroup.StringSetter(value="isSeepModeStorageFree")
    public void setSeepModeStorageFree(boolean isSeepModeStorageFree) {
        this.isSeepModeStorageFree = isSeepModeStorageFree;
    }

    @ReflectiveConfigGroup.StringGetter(value="isRestrictingSeepage")
    public boolean isRestrictingSeepage() {
        return this.isRestrictingSeepage;
    }

    @ReflectiveConfigGroup.StringSetter(value="isRestrictingSeepage")
    public void setRestrictingSeepage(boolean isRestrictingSeepage) {
        this.isRestrictingSeepage = isRestrictingSeepage;
    }

    public boolean isUsingTravelTimeCheckInTeleportation() {
        return this.usingTravelTimeCheckInTeleportation;
    }

    public boolean setUsingTravelTimeCheckInTeleportation(boolean val) {
        this.usingTravelTimeCheckInTeleportation = val;
        return this.usingTravelTimeCheckInTeleportation;
    }

    public double getPcuThresholdForFlowCapacityEasing() {
        return this.pcuThresholdForFlowCapacityEasing;
    }

    public void setPcuThresholdForFlowCapacityEasing(double pcuThresholdForFlowCapacityEasing) {
        this.pcuThresholdForFlowCapacityEasing = pcuThresholdForFlowCapacityEasing;
    }

    public static enum VehiclesSource {
        defaultVehicle,
        modeVehicleTypesFromVehiclesData,
        fromVehiclesData;

    }

    public static enum LinkDynamics {
        FIFO,
        PassingQ,
        SeepageQ;

    }

    public static enum SnapshotStyle {
        equiDist,
        queue,
        withHoles,
        withHolesAndShowHoles,
        kinematicWaves;

    }

    public static enum VehicleBehavior {
        teleport,
        wait,
        exception;

    }

    public static enum EndtimeInterpretation {
        minOfEndtimeAndMobsimFinished,
        onlyUseEndtime;

    }

    public static enum StarttimeInterpretation {
        maxOfStarttimeAndEarliestActivityEnd,
        onlyUseStarttime;

    }

    public static enum TrafficDynamics {
        queue,
        withHoles,
        kinematicWaves;

    }
}

