/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.config.groups;

import java.util.Map;
import org.apache.log4j.Logger;
import org.matsim.core.config.ConfigGroup;
import org.matsim.core.config.ReflectiveConfigGroup;

public final class ScenarioConfigGroup
extends ConfigGroup {
    public static final String GROUP_NAME = "scenario";
    private static final String USE_LANES = "useLanes";
    private static final String USE_HOUSEHOLDS = "useHouseholds";
    private static final String USE_TRANSIT = "useTransit";
    private static final String USE_VEHICLES = "useVehicles";
    private static final String SIMULATION_PERIOD_DAYS = "simulationPeriodInDays";
    private static final Logger log = Logger.getLogger(ScenarioConfigGroup.class);
    private double simulationPeriodInDays = 1.0;

    public ScenarioConfigGroup() {
        super(GROUP_NAME);
    }

    @Override
    public Map<String, String> getComments() {
        Map<String, String> map = super.getComments();
        String message = "Deprecated, do not use.  The file is loaded when the filename is given.  Functionality needs to be switched on elsewhere.";
        map.put(USE_LANES, "Deprecated, do not use.  The file is loaded when the filename is given.  Functionality needs to be switched on elsewhere.");
        map.put(USE_HOUSEHOLDS, "Deprecated, do not use.  The file is loaded when the filename is given.  Functionality needs to be switched on elsewhere.");
        map.put(USE_VEHICLES, "Deprecated, do not use.  The file is loaded when the filename is given.  Functionality needs to be switched on elsewhere.");
        map.put(USE_TRANSIT, "Deprecated, do not use.  See transit section of config file.");
        return map;
    }

    @Override
    public final void addParam(String paramName, String value) {
        if ("null".equalsIgnoreCase(value)) {
            return;
        }
        if (USE_LANES.equals(paramName)) {
            this.setUseLanes(Boolean.parseBoolean(value));
        } else if (USE_HOUSEHOLDS.equals(paramName)) {
            this.setUseHouseholds(Boolean.parseBoolean(value));
        } else if (USE_VEHICLES.equals(paramName)) {
            this.setUseVehicles(Boolean.parseBoolean(value));
        } else if (USE_TRANSIT.equals(paramName)) {
            this.setUseTransit(Boolean.parseBoolean(value));
        } else {
            throw new IllegalArgumentException("Parameter '" + paramName + "' is not supported by config group '" + GROUP_NAME + "'.");
        }
    }

    @Override
    public final String getValue(String param_name) {
        throw new UnsupportedOperationException("Use getters for accessing values!");
    }

    @Override
    public final Map<String, String> getParams() {
        Map<String, String> params = super.getParams();
        return params;
    }

    @Deprecated
    void setUseLanes(boolean useLanes) {
        throw new RuntimeException(ScenarioConfigGroup.getMessage(USE_LANES));
    }

    @Deprecated
    public void setUseHouseholds(boolean b) {
        throw new RuntimeException(ScenarioConfigGroup.getMessage(USE_HOUSEHOLDS));
    }

    @Deprecated
    public void setUseVehicles(Boolean b) {
        throw new RuntimeException(ScenarioConfigGroup.getMessage(USE_VEHICLES));
    }

    @Deprecated
    public void setUseTransit(Boolean b) {
        throw new RuntimeException("The useTransit switch has moved to the transit section of the config file.");
    }

    @ReflectiveConfigGroup.StringSetter(value="simulationPeriodInDays")
    public void setSimulationPeriodInDays(double simulationPeriodInDays) {
        this.simulationPeriodInDays = simulationPeriodInDays;
    }

    @ReflectiveConfigGroup.StringGetter(value="simulationPeriodInDays")
    public double getSimulationPeriodInDays() {
        return this.simulationPeriodInDays;
    }

    private static String getMessage(String module) {
        return "The " + module + " switch is no longer operational.  The file is loaded if the file name" + " is different from null.  If you needed this for the creation of the container, use the ScenarioBuilder in " + "ScenarioUtils.  Note that loading the file does not mean that it is used anywhere; such functionality needs to be " + "switched on elsewhere (e.g. in qsim, in transit, ...).  If this does not work for you, please let us know. kai, jun'15";
    }
}

