/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.config.groups;

import java.util.Collection;
import java.util.Map;
import org.matsim.api.core.v01.Id;
import org.matsim.core.api.internal.MatsimParameters;
import org.matsim.core.config.Config;
import org.matsim.core.config.ConfigGroup;
import org.matsim.core.config.ReflectiveConfigGroup;
import org.matsim.core.gbl.MatsimRandom;
import org.matsim.core.replanning.strategies.DefaultPlanStrategiesModule;

public final class StrategyConfigGroup
extends ConfigGroup {
    public static final String GROUP_NAME = "strategy";
    private static final String MODULE = "Module_";
    private static final String MODULE_PROBABILITY = "ModuleProbability_";
    private static final String MODULE_DISABLE_AFTER_ITERATION = "ModuleDisableAfterIteration_";
    private static final String MODULE_EXE_PATH = "ModuleExePath_";
    private static final String MODULE_SUBPOPULATION = "ModuleSubpopulation_";
    private final ReflectiveDelegate delegate = new ReflectiveDelegate();

    public StrategyConfigGroup() {
        super(GROUP_NAME);
    }

    @Override
    public String getValue(String key) {
        if (key.startsWith(MODULE) || key.startsWith(MODULE_PROBABILITY) || key.startsWith(MODULE_DISABLE_AFTER_ITERATION) || key.startsWith(MODULE_EXE_PATH) || key.startsWith(MODULE_SUBPOPULATION)) {
            throw new IllegalArgumentException("getting underscored parameter " + key + " is not allowed anymore. The supported way to get those parameters is via parameter sets.");
        }
        return this.delegate.getValue(key);
    }

    @Override
    public void addParam(String key, String value) {
        if (key != null && key.startsWith(MODULE)) {
            StrategySettings settings = this.getStrategySettings(Id.create(key.substring(MODULE.length()), StrategySettings.class), true);
            settings.addParam("strategyName", value);
        } else if (key != null && key.startsWith(MODULE_PROBABILITY)) {
            StrategySettings settings = this.getStrategySettings(Id.create(key.substring(MODULE_PROBABILITY.length()), StrategySettings.class), true);
            settings.addParam("weight", value);
        } else if (key != null && key.startsWith(MODULE_DISABLE_AFTER_ITERATION)) {
            StrategySettings settings = this.getStrategySettings(Id.create(key.substring(MODULE_DISABLE_AFTER_ITERATION.length()), StrategySettings.class), true);
            settings.setDisableAfter(Integer.parseInt(value));
            settings.addParam("disableAfterIteration", value);
        } else if (key != null && key.startsWith(MODULE_EXE_PATH)) {
            StrategySettings settings = this.getStrategySettings(Id.create(key.substring(MODULE_EXE_PATH.length()), StrategySettings.class), true);
            settings.addParam("executionPath", value);
        } else if (key != null && key.startsWith(MODULE_SUBPOPULATION)) {
            StrategySettings settings = this.getStrategySettings(Id.create(key.substring(MODULE_SUBPOPULATION.length()), StrategySettings.class), true);
            settings.addParam("subpopulation", value);
        } else {
            this.delegate.addParam(key, value);
        }
    }

    private StrategySettings getStrategySettings(Id<StrategySettings> index, boolean createIfMissing) {
        StrategySettings settings = null;
        for (StrategySettings s2 : this.getStrategySettings()) {
            if (!s2.getId().equals(index)) continue;
            if (settings != null) {
                throw new IllegalStateException("several settings with id " + index);
            }
            settings = s2;
        }
        if (settings == null && createIfMissing) {
            settings = new StrategySettings(index);
            this.addStrategySettings(settings);
        }
        return settings;
    }

    @Override
    public final Map<String, String> getComments() {
        Map<String, String> map = super.getComments();
        map.put("fractionOfIterationsToDisableInnovation", "fraction of iterations where innovative strategies are switched off.  Something like 0.8 should be good.  E.g. if you run from iteration 400 to iteration 500, innovation is switched off at iteration 480");
        map.put("maxAgentPlanMemorySize", "maximum number of plans per agent.  ``0'' means ``infinity''.  Currently (2010), ``5'' is a good number");
        StringBuilder strb = new StringBuilder();
        for (DefaultPlanStrategiesModule.DefaultPlansRemover name : DefaultPlanStrategiesModule.DefaultPlansRemover.values()) {
            strb.append(name.toString() + " ");
        }
        map.put("planSelectorForRemoval", "strategyName of PlanSelector for plans removal.  Possible defaults: " + strb.toString() + ". The current default, WorstPlanSelector is not a good " + "choice from a discrete choice theoretical perspective. Alternatives, however, have not been systematically " + "tested. kai, feb'12");
        map.put("ExternalExeConfigTemplate", "the external executable will be called with a config file as argument.  This is the pathname to a possible skeleton config, to which additional information will be added.  Can be null.");
        map.put("ExternalExeTmpFileRootDir", "root directory for temporary files generated by the external executable. Provided as a service; I don't think this is used by MATSim.");
        map.put("ExternalExeTimeOut", "time out value (in seconds) after which matsim will consider the external strategy as failed");
        return map;
    }

    @Override
    protected void checkParameterSet(ConfigGroup set) {
        switch (set.getName()) {
            case "strategysettings": {
                if (set instanceof StrategySettings) break;
                throw new RuntimeException(set + " is not an instance of StrategySettings");
            }
            default: {
                throw new IllegalArgumentException("unknown set type " + set.getName());
            }
        }
    }

    @Override
    public ConfigGroup createParameterSet(String type) {
        switch (type) {
            case "strategysettings": {
                return new StrategySettings();
            }
        }
        throw new IllegalArgumentException("unknown set type " + type);
    }

    public void addStrategySettings(StrategySettings stratSets) {
        this.addParameterSet(stratSets);
    }

    public final void clearStrategySettings() {
        this.clearParameterSetsForType("strategysettings");
    }

    public Collection<StrategySettings> getStrategySettings() {
        return this.getParameterSets("strategysettings");
    }

    @Override
    protected void checkConsistency(Config config) {
        super.checkConsistency(config);
    }

    public void setMaxAgentPlanMemorySize(int maxAgentPlanMemorySize) {
        this.delegate.setMaxAgentPlanMemorySize(maxAgentPlanMemorySize);
    }

    public int getMaxAgentPlanMemorySize() {
        return this.delegate.getMaxAgentPlanMemorySize();
    }

    public void setExternalExeConfigTemplate(String externalExeConfigTemplate) {
        this.delegate.setExternalExeConfigTemplate(externalExeConfigTemplate);
    }

    public String getExternalExeConfigTemplate() {
        return this.delegate.getExternalExeConfigTemplate();
    }

    public void setExternalExeTmpFileRootDir(String externalExeTmpFileRootDir) {
        this.delegate.setExternalExeTmpFileRootDir(externalExeTmpFileRootDir);
    }

    public String getExternalExeTmpFileRootDir() {
        return this.delegate.getExternalExeTmpFileRootDir();
    }

    public void setExternalExeTimeOut(long externalExeTimeOut) {
        this.delegate.setExternalExeTimeOut(externalExeTimeOut);
    }

    public long getExternalExeTimeOut() {
        return this.delegate.getExternalExeTimeOut();
    }

    public String getPlanSelectorForRemoval() {
        return this.delegate.getPlanSelectorForRemoval();
    }

    public void setPlanSelectorForRemoval(String planSelectorForRemoval) {
        switch (planSelectorForRemoval) {
            case "SelectExpBeta": {
                throw new RuntimeException("'SelectExpBeta' was replaced by 'SelectExpBetaForRemoval' in the plans removal setting");
            }
            case "ChangeExpBeta": {
                throw new RuntimeException("'ChangeExpBeta' was replaced by 'ChangeExpBetaForRemoval' in the plans removal setting");
            }
            case "PathSizeLogitSelector": {
                throw new RuntimeException("'PathSizeLogitSelector' was replaced by 'PathSizeLogitSelectorForRemoval' in the plans removal setting");
            }
        }
        this.delegate.setPlanSelectorForRemoval(planSelectorForRemoval);
    }

    public double getFractionOfIterationsToDisableInnovation() {
        return this.delegate.getFractionOfIterationsToDisableInnovation();
    }

    public void setFractionOfIterationsToDisableInnovation(double fraction) {
        this.delegate.setFractionOfIterationsToDisableInnovation(fraction);
    }

    @Override
    public final Map<String, String> getParams() {
        return this.delegate.getParams();
    }

    private static class ReflectiveDelegate
    extends ReflectiveConfigGroup {
        static final String MAX_AGENT_PLAN_MEMORY_SIZE = "maxAgentPlanMemorySize";
        static final String EXTERNAL_EXE_CONFIG_TEMPLATE = "ExternalExeConfigTemplate";
        static final String EXTERNAL_EXE_TMP_FILE_ROOT_DIR = "ExternalExeTmpFileRootDir";
        static final String EXTERNAL_EXE_TIME_OUT = "ExternalExeTimeOut";
        static final String ITERATION_FRACTION_TO_DISABLE_INNOVATION = "fractionOfIterationsToDisableInnovation";
        static final String PLAN_SELECTOR_FOR_REMOVAL = "planSelectorForRemoval";
        private int maxAgentPlanMemorySize = 5;
        private String externalExeConfigTemplate = null;
        private String externalExeTmpFileRootDir = null;
        private long externalExeTimeOut = 3600L;
        private String planSelectorForRemoval = "WorstPlanSelector";
        private double fraction = Double.POSITIVE_INFINITY;

        public ReflectiveDelegate() {
            super(StrategyConfigGroup.GROUP_NAME);
        }

        @ReflectiveConfigGroup.StringSetter(value="maxAgentPlanMemorySize")
        public void setMaxAgentPlanMemorySize(int maxAgentPlanMemorySize) {
            this.maxAgentPlanMemorySize = maxAgentPlanMemorySize;
        }

        @ReflectiveConfigGroup.StringGetter(value="maxAgentPlanMemorySize")
        public int getMaxAgentPlanMemorySize() {
            return this.maxAgentPlanMemorySize;
        }

        @ReflectiveConfigGroup.StringSetter(value="ExternalExeConfigTemplate")
        public void setExternalExeConfigTemplate(String externalExeConfigTemplate) {
            this.externalExeConfigTemplate = externalExeConfigTemplate;
        }

        @ReflectiveConfigGroup.StringGetter(value="ExternalExeConfigTemplate")
        public String getExternalExeConfigTemplate() {
            return this.externalExeConfigTemplate;
        }

        @ReflectiveConfigGroup.StringSetter(value="ExternalExeTmpFileRootDir")
        public void setExternalExeTmpFileRootDir(String externalExeTmpFileRootDir) {
            this.externalExeTmpFileRootDir = externalExeTmpFileRootDir;
        }

        @ReflectiveConfigGroup.StringGetter(value="ExternalExeTmpFileRootDir")
        public String getExternalExeTmpFileRootDir() {
            return this.externalExeTmpFileRootDir;
        }

        @ReflectiveConfigGroup.StringSetter(value="ExternalExeTimeOut")
        public void setExternalExeTimeOut(long externalExeTimeOut) {
            this.externalExeTimeOut = externalExeTimeOut;
        }

        @ReflectiveConfigGroup.StringGetter(value="ExternalExeTimeOut")
        public long getExternalExeTimeOut() {
            return this.externalExeTimeOut;
        }

        @ReflectiveConfigGroup.StringGetter(value="planSelectorForRemoval")
        public String getPlanSelectorForRemoval() {
            return this.planSelectorForRemoval;
        }

        @ReflectiveConfigGroup.StringSetter(value="planSelectorForRemoval")
        public void setPlanSelectorForRemoval(String planSelectorForRemoval) {
            this.planSelectorForRemoval = planSelectorForRemoval;
        }

        @ReflectiveConfigGroup.StringGetter(value="fractionOfIterationsToDisableInnovation")
        public double getFractionOfIterationsToDisableInnovation() {
            return this.fraction;
        }

        @ReflectiveConfigGroup.StringSetter(value="fractionOfIterationsToDisableInnovation")
        public void setFractionOfIterationsToDisableInnovation(double fraction) {
            this.fraction = fraction;
        }
    }

    public static class StrategySettings
    extends ReflectiveConfigGroup
    implements MatsimParameters {
        public static final String SET_NAME = "strategysettings";
        private Id<StrategySettings> id;
        private double probability = -1.0;
        private String strategyName = null;
        private int disableAfter = -1;
        private String exePath = null;
        private String subpopulation = null;

        public StrategySettings() {
            this(Id.create(MatsimRandom.getRandom().nextLong(), StrategySettings.class));
        }

        @Deprecated
        public StrategySettings(Id<StrategySettings> id) {
            super(SET_NAME);
            this.id = id;
        }

        @Override
        public final Map<String, String> getComments() {
            Map<String, String> map = super.getComments();
            StringBuilder sels = new StringBuilder();
            sels.append("SelectRandom");
            sels.append("BestScore");
            sels.append("KeepLastSelected");
            sels.append("ChangeExpBeta");
            sels.append("SelectExpBeta");
            sels.append("SelectPathSizeLogit");
            StringBuilder strats = new StringBuilder();
            strats.append("ReRoute");
            strats.append("TimeAllocationMutator");
            strats.append("TimeAllocationMutator_ReRoute");
            strats.append("ChangeSingleTripMode");
            strats.append("ChangeTripMode");
            strats.append("SubtourModeChoice");
            map.put("strategyName", "strategyName of strategy.  Possible default names: " + sels + " (selectors), " + strats + " (innovative strategies).");
            map.put("weight", "weight of a strategy: for each agent, a strategy will be selected with a probability proportional to its weight");
            map.put("disableAfterIteration", "iteration after which strategy will be disabled.  most useful for ``innovative'' strategies (new routes, new times, ...). Normally, better use fractionOfIterationsToDisableInnovation");
            map.put("executionPath", "path to external executable (if applicable)");
            map.put("subpopulation", "subpopulation to which the strategy applies. \"null\" refers to the default population, that is, the set of persons for which no explicit subpopulation is defined (ie no subpopulation attribute)");
            return map;
        }

        @Override
        protected void checkConsistency(Config config) {
            super.checkConsistency(config);
            if (this.getStrategyName() == null || this.getStrategyName().length() == 0) {
                throw new RuntimeException("Strategy strategyName is not set");
            }
            if (this.getWeight() < 0.0) {
                throw new RuntimeException("Weight for strategy " + this.getStrategyName() + " must be >= 0.0");
            }
        }

        @ReflectiveConfigGroup.StringSetter(value="weight")
        public StrategySettings setWeight(double probability) {
            this.probability = probability;
            return this;
        }

        @ReflectiveConfigGroup.StringGetter(value="weight")
        public double getWeight() {
            return this.probability;
        }

        @ReflectiveConfigGroup.StringSetter(value="strategyName")
        public StrategySettings setStrategyName(String name) {
            this.strategyName = name;
            return this;
        }

        @ReflectiveConfigGroup.StringGetter(value="strategyName")
        public String getStrategyName() {
            return this.strategyName;
        }

        @ReflectiveConfigGroup.StringSetter(value="disableAfterIteration")
        public StrategySettings setDisableAfter(int disableAfter) {
            this.disableAfter = disableAfter;
            return this;
        }

        @ReflectiveConfigGroup.StringGetter(value="disableAfterIteration")
        public int getDisableAfter() {
            return this.disableAfter;
        }

        @ReflectiveConfigGroup.StringSetter(value="executionPath")
        public StrategySettings setExePath(String exePath) {
            this.exePath = exePath;
            return this;
        }

        @ReflectiveConfigGroup.StringGetter(value="executionPath")
        public String getExePath() {
            return this.exePath;
        }

        @Deprecated
        public Id<StrategySettings> getId() {
            return this.id;
        }

        @ReflectiveConfigGroup.StringSetter(value="subpopulation")
        public StrategySettings setSubpopulation(String subpopulation) {
            this.subpopulation = subpopulation;
            return this;
        }

        @ReflectiveConfigGroup.StringGetter(value="subpopulation")
        public String getSubpopulation() {
            return this.subpopulation;
        }
    }
}

