/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.config.groups;

import java.util.Map;
import org.matsim.core.config.ReflectiveConfigGroup;
import org.matsim.core.replanning.modules.SubtourModeChoice;
import org.matsim.core.utils.misc.StringUtils;

public final class SubtourModeChoiceConfigGroup
extends ReflectiveConfigGroup {
    public static final String GROUP_NAME = "subtourModeChoice";
    public static final String MODES = "modes";
    public static final String CHAINBASEDMODES = "chainBasedModes";
    public static final String CARAVAIL = "considerCarAvailability";
    private static final String BEHAVIOR = "behavior";
    private String[] chainBasedModes = new String[]{"car", "bike"};
    private String[] allModes = new String[]{"car", "pt", "bike", "walk"};
    private boolean considerCarAvailability = false;
    private SubtourModeChoice.Behavior behavior = SubtourModeChoice.Behavior.fromSpecifiedModesToSpecifiedModes;
    private double probaForRandomSingleTripMode = 0.0;

    public SubtourModeChoiceConfigGroup() {
        super(GROUP_NAME);
    }

    @ReflectiveConfigGroup.StringGetter(value="modes")
    private String getModesString() {
        return SubtourModeChoiceConfigGroup.toString(this.allModes);
    }

    @ReflectiveConfigGroup.StringGetter(value="chainBasedModes")
    private String getChainBaseModesString() {
        return SubtourModeChoiceConfigGroup.toString(this.chainBasedModes);
    }

    private static String toString(String[] modes) {
        StringBuilder b = new StringBuilder();
        if (modes.length > 0) {
            b.append(modes[0]);
        }
        for (int i = 1; i < modes.length; ++i) {
            b.append(',');
            b.append(modes[i]);
        }
        return b.toString();
    }

    private static String[] toArray(String modes) {
        String[] parts = StringUtils.explode(modes, ',');
        int n = parts.length;
        for (int i = 0; i < n; ++i) {
            parts[i] = parts[i].trim().intern();
        }
        return parts;
    }

    @ReflectiveConfigGroup.StringSetter(value="modes")
    private void setModes(String value) {
        this.setModes(SubtourModeChoiceConfigGroup.toArray(value));
    }

    @ReflectiveConfigGroup.StringSetter(value="chainBasedModes")
    private void setChainBasedModes(String value) {
        this.setChainBasedModes(SubtourModeChoiceConfigGroup.toArray(value));
    }

    @Override
    public Map<String, String> getComments() {
        Map<String, String> comments = super.getComments();
        comments.put(MODES, "Defines all the modes available, including chain-based modes, seperated by commas");
        comments.put(CHAINBASEDMODES, "Defines the chain-based modes, seperated by commas");
        comments.put(CARAVAIL, "Defines whether car availability must be considered or not. A agent has no car only if it has no license, or never access to a car");
        String msg = "Only for backwards compatibility.  Defines if only trips from modes list should change mode, or all trips.  Options: ";
        for (SubtourModeChoice.Behavior behavior : SubtourModeChoice.Behavior.values()) {
            msg = msg + behavior.name() + " ";
        }
        comments.put(BEHAVIOR, msg);
        return comments;
    }

    public void setModes(String[] modes) {
        this.allModes = modes;
    }

    public String[] getModes() {
        return this.allModes;
    }

    public void setChainBasedModes(String[] modes) {
        this.chainBasedModes = modes;
    }

    public String[] getChainBasedModes() {
        return this.chainBasedModes;
    }

    @ReflectiveConfigGroup.StringSetter(value="considerCarAvailability")
    public void setConsiderCarAvailability(boolean value) {
        this.considerCarAvailability = value;
    }

    @ReflectiveConfigGroup.StringGetter(value="considerCarAvailability")
    public boolean considerCarAvailability() {
        return this.considerCarAvailability;
    }

    @ReflectiveConfigGroup.StringSetter(value="behavior")
    public final void setBehavior(SubtourModeChoice.Behavior behavior) {
        this.behavior = behavior;
    }

    @ReflectiveConfigGroup.StringGetter(value="behavior")
    public final SubtourModeChoice.Behavior getBehavior() {
        return this.behavior;
    }

    public double getProbaForRandomSingleTripMode() {
        return this.probaForRandomSingleTripMode;
    }

    public void setProbaForRandomSingleTripMode(double probaForRandomSingleTripMode) {
        this.probaForRandomSingleTripMode = probaForRandomSingleTripMode;
    }
}

