/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.config.groups;

import java.util.Collection;
import java.util.Map;
import org.matsim.core.config.ConfigGroup;
import org.matsim.core.config.ReflectiveConfigGroup;

public final class TimeAllocationMutatorConfigGroup
extends ReflectiveConfigGroup {
    public static final String GROUP_NAME = "TimeAllocationMutator";
    private static final String MUTATION_RANGE = "mutationRange";
    private double mutationRange = 1800.0;
    private static final String MUTATION_AFFECTS_DURATION = "mutationAffectsDuration";
    private boolean affectingDuration = true;
    private static final String USE_INDIVIDUAL_SETTINGS_FOR_SUBPOPULATIONS = "useIndividualSettingsForSubpopulations";
    private boolean useIndividualSettingsForSubpopulations = false;

    public TimeAllocationMutatorConfigGroup() {
        super(GROUP_NAME);
    }

    @Override
    public Map<String, String> getComments() {
        Map<String, String> comments = super.getComments();
        comments.put(MUTATION_RANGE, "Default:1800.0; Defines how many seconds a time mutation can maximally shift a time.");
        comments.put(MUTATION_AFFECTS_DURATION, "Default:true; Defines whether time mutation changes an activity's duration.");
        comments.put(USE_INDIVIDUAL_SETTINGS_FOR_SUBPOPULATIONS, "false; Use individual settings for each subpopulation. If enabled but no settings are found, regular settings are uses as fallback.");
        return comments;
    }

    @ReflectiveConfigGroup.StringGetter(value="mutationRange")
    public double getMutationRange() {
        return this.mutationRange;
    }

    @ReflectiveConfigGroup.StringSetter(value="mutationRange")
    public void setMutationRange(double val) {
        this.mutationRange = val;
    }

    @ReflectiveConfigGroup.StringGetter(value="mutationAffectsDuration")
    public boolean isAffectingDuration() {
        return this.affectingDuration;
    }

    @ReflectiveConfigGroup.StringSetter(value="mutationAffectsDuration")
    public void setAffectingDuration(boolean affectingDuration) {
        this.affectingDuration = affectingDuration;
    }

    public boolean isUseIndividualSettingsForSubpopulations() {
        return this.useIndividualSettingsForSubpopulations;
    }

    public void setUseIndividualSettingsForSubpopulations(boolean useIndividualSettingsForSubpopulations) {
        this.useIndividualSettingsForSubpopulations = useIndividualSettingsForSubpopulations;
    }

    public TimeAllocationMutatorSubpopulationSettings getTimeAllocationMutatorSubpopulationSettings(String subpopulation) {
        if (subpopulation == null) {
            return null;
        }
        Collection<? extends ConfigGroup> configGroups = this.getParameterSets("subpopulationSettings");
        for (ConfigGroup configGroup : configGroups) {
            TimeAllocationMutatorSubpopulationSettings subpopulationSettings;
            if (!(configGroup instanceof TimeAllocationMutatorSubpopulationSettings) || !subpopulation.equals((subpopulationSettings = (TimeAllocationMutatorSubpopulationSettings)configGroup).subpopulation)) continue;
            return subpopulationSettings;
        }
        return null;
    }

    @Override
    public ConfigGroup createParameterSet(String type) {
        switch (type) {
            case "subpopulationSettings": {
                return new TimeAllocationMutatorSubpopulationSettings();
            }
        }
        throw new IllegalArgumentException("unknown set type '" + type + "'");
    }

    @Override
    public void addParameterSet(ConfigGroup set) {
        switch (set.getName()) {
            case "subpopulationSettings": {
                super.addParameterSet(set);
                break;
            }
            default: {
                throw new IllegalArgumentException(set.getName());
            }
        }
    }

    public static class TimeAllocationMutatorSubpopulationSettings
    extends ReflectiveConfigGroup {
        public static final String SET_NAME = "subpopulationSettings";
        private static final String MUTATION_RANGE = "mutationRange";
        private static final String MUTATION_AFFECTS_DURATION = "mutationAffectsDuration";
        private static final String SUBPOPULATION = "subpopulation";
        private double mutationRange = 1800.0;
        private boolean affectingDuration = true;
        private String subpopulation = null;

        public TimeAllocationMutatorSubpopulationSettings() {
            super(SET_NAME);
        }

        @Override
        public final Map<String, String> getComments() {
            Map<String, String> comments = super.getComments();
            comments.put("mutationRange", "Default:1800.0; Defines how many seconds a time mutation can maximally shift a time.");
            comments.put("mutationAffectsDuration", "Default:true; Defines whether time mutation changes an activity's duration.");
            comments.put(SUBPOPULATION, "Subpopulation to which the values from this parameter set are applied.");
            return comments;
        }

        @ReflectiveConfigGroup.StringGetter(value="mutationRange")
        public double getMutationRange() {
            return this.mutationRange;
        }

        @ReflectiveConfigGroup.StringSetter(value="mutationRange")
        public void setMutationRange(double val) {
            this.mutationRange = val;
        }

        @ReflectiveConfigGroup.StringGetter(value="mutationAffectsDuration")
        public boolean isAffectingDuration() {
            return this.affectingDuration;
        }

        @ReflectiveConfigGroup.StringSetter(value="mutationAffectsDuration")
        public void setAffectingDuration(boolean affectingDuration) {
            this.affectingDuration = affectingDuration;
        }

        @ReflectiveConfigGroup.StringSetter(value="subpopulation")
        public void setSubpopulation(String subpopulation) {
            this.subpopulation = subpopulation;
        }

        @ReflectiveConfigGroup.StringGetter(value="subpopulation")
        public String getSubpopulation() {
            return this.subpopulation;
        }
    }
}

